/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FileMonitorTest
extends GenericTest {
    String path = "";
    String minsold = "";
    String debugFlag = "";
    String pattern = "";
    String datepattern = "";
    String pattname = "";
    String currdate = "";
    String filepatt = "";
    String subDir = "";
    String fileFilter = "";
    boolean debug = false;
    boolean isDatePattern = false;
    boolean isSubDir = false;
    boolean isFileFilter = false;
    ArrayList allFiles = null;
    public Hashtable ddFileName = new Hashtable();
    public Hashtable ddLastmod = new Hashtable();
    public Hashtable ddAge = new Hashtable();

    public FileMonitorTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.path = this.getValueForParam("File_Path");
        this.pattern = this.getValueForParam("FileName_Pattern");
        this.datepattern = this.getValueForParam("Date_Pattern");
        this.subDir = this.getValueForParam("Include_Sub_Directory");
        this.fileFilter = this.getValueForParam("File_Extension");
        this.debugFlag = this.getValueForParam("debug");
        if (this.debugFlag == null) {
            this.debug = false;
        }
        if (this.debugFlag != null && (this.debugFlag.equalsIgnoreCase("true") || this.debugFlag.equalsIgnoreCase("yes"))) {
            this.debug = true;
        }
        if (this.subDir != null && (this.subDir.equalsIgnoreCase("true") || this.subDir.equalsIgnoreCase("yes"))) {
            this.isSubDir = true;
        }
        if (this.datepattern != null && (this.datepattern.equalsIgnoreCase("true") || this.datepattern.equalsIgnoreCase("yes"))) {
            this.isDatePattern = true;
        }
        if (this.path == null) {
            this.path = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.fileFilter == null || this.fileFilter.equalsIgnoreCase("NONE")) {
            this.fileFilter = "";
            this.isFileFilter = false;
        } else if (this.fileFilter.length() > 1) {
            this.fileFilter = this.fileFilter.toUpperCase().trim();
            this.isFileFilter = true;
        }
        if (this.debug) {
            System.out.println("[FileMonitorTest].Constructor() Input Param File_Path    ===>" + this.path);
            System.out.println("[FileMonitorTest].Constructor() Input Param Pattern      ===>" + this.pattern);
            System.out.println("[FileMonitorTest].Constructor() Input Param Date_Pattern ===>" + this.datepattern);
            System.out.println();
            System.out.println();
        }
        this.path = this.path.trim();
        this.pattern = this.pattern.trim();
        this.path = FileMonitorTest.replace(this.path, "\\", "/");
    }

    public void computeMeasures(Hashtable hashtable) {
        this.ddFileName = new Hashtable();
        this.ddLastmod = new Hashtable();
        this.ddAge = new Hashtable();
        Hashtable hashtable2 = this.getMultiPathInfo(this.path, this.pattern);
        if (hashtable2 == null) {
            return;
        }
        Hashtable hashtable3 = (Hashtable)hashtable2.get("path");
        Hashtable hashtable4 = (Hashtable)hashtable2.get("patt");
        if (hashtable3 == null || hashtable4 == null) {
            return;
        }
        Enumeration enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable3.get(string);
            String string3 = (String)hashtable4.get(string);
            string = string.trim().toUpperCase();
            if (this.debug) {
                System.out.println("[FileMonitorTest].computeMeasures() currInfo ==> " + string);
                System.out.println("[FileMonitorTest].computeMeasures() currPath ==> " + string2);
                System.out.println("[FileMonitorTest].computeMeasures() currPatt ==> " + string3);
            }
            if (string2 == null || string3 == null) {
                this.logToErrorFile("Error", "FileMonitor.computeMeasures", "Path Pattern Match Missing ==> Check config Input Params");
                return;
            }
            this.allFiles = new ArrayList();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            int n = 0;
            long l = 0L;
            boolean bl = false;
            try {
                File file = new File(string2);
                if (file.isDirectory()) {
                    boolean bl2 = false;
                    File[] fileArray = this.getArchiveLogFiles(file);
                    if (fileArray == null || fileArray.length == 0) {
                        n = 0;
                        l = -5L;
                        if (this.debug) {
                            System.out.println("[FileMonitorTest] No files in File_Path");
                        }
                    } else {
                        long l2 = 0L;
                        l2 = System.currentTimeMillis();
                        if (l2 == 0L) {
                            this.logToErrorFile("Error", "FileMonitor.computeMeasures", "Current Time in Milli Secs not available");
                            return;
                        }
                        for (int i = 0; i < fileArray.length; ++i) {
                            string5 = fileArray[i].getName();
                            String string8 = fileArray[i].getPath();
                            string6 = string5.toUpperCase().trim();
                            if (this.isFileFilter && !string6.endsWith(this.fileFilter)) continue;
                            StringTokenizer stringTokenizer = new StringTokenizer(string6, ".");
                            int n2 = stringTokenizer.countTokens();
                            int n3 = 0;
                            n3 = n2 > 1 ? string6.lastIndexOf(".") : string6.indexOf(".");
                            if (n3 > -1) {
                                string6 = string6.substring(0, n3);
                            }
                            boolean bl3 = false;
                            bl3 = string3.equalsIgnoreCase("all") ? true : this.getFilePatternMatch(string3, string6);
                            if (this.debug) {
                                System.out.println();
                                System.out.println();
                                System.out.println("[FileMonitorTest]===>Pattern val--->" + string3);
                                System.out.println("[FileMonitorTest]===>File name--->" + string6);
                                System.out.println("[FileMonitorTest]===>File pattern Match--->" + bl3);
                            }
                            if (!bl3) continue;
                            try {
                                bl = true;
                                ++n;
                                long l3 = fileArray[i].lastModified();
                                long l4 = l2 - l3;
                                if (l4 > 0L) {
                                    l4 /= 60000L;
                                }
                                if (l4 > l) {
                                    l = l4;
                                }
                                Date date = new Date(l3);
                                String string9 = date.toString();
                                arrayList2.add(string8);
                                arrayList4.add(Long.toString(l4));
                                arrayList3.add(string9);
                                if (!this.debug) continue;
                                System.out.println("[FileMonitorTest] ==> File Pattern Matched successfully");
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                this.logToErrorFile("Error", "FileMonitor.computeMeasures", exception.toString());
                            }
                        }
                        if (!bl) {
                            n = 0;
                            l = -5L;
                            if (this.debug) {
                                this.logToErrorFile("Error", "FileMonitor.computeMeasures", "File Pattern not Matched");
                            }
                        }
                    }
                } else {
                    this.logToErrorFile("Error", "FileMonitor.computeMeasures", "Invalid path or Directory does not exist");
                    return;
                }
                try {
                    arrayList.add(new Double(n));
                }
                catch (Exception exception) {
                    arrayList.add(new Double("-5"));
                }
                try {
                    arrayList.add(new Double(l));
                }
                catch (Exception exception) {
                    arrayList.add(new Double("-5"));
                }
                try {
                    if (arrayList2.size() > 0 && arrayList4.size() > 0 && arrayList3.size() > 0) {
                        this.ddFileName.put(string, arrayList2);
                        this.ddAge.put(string, arrayList4);
                        this.ddLastmod.put(string, arrayList3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.debug) {
                    System.out.println("[FileMonitorTest]===> " + string + "===>" + arrayList);
                    System.out.println("[FileMonitorTest]===> D.D File Names ===>" + this.ddFileName);
                    System.out.println("[FileMonitorTest]===> D.D File Age in Mins ===>" + this.ddAge);
                    System.out.println("[FileMonitorTest]===> D.D File Last Modified ===>" + this.ddLastmod);
                }
                this.addNewMeasure(string, arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error", "FileMonitor.computeMeasures", exception.toString());
                return;
            }
        }
    }

    private boolean getFilePatternMatch(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            String string5 = string3 = string4.toUpperCase().trim();
            if (this.isDatePattern) {
                if ((string3 = this.applyDatePattern(string3)) == null) {
                    string3 = string5;
                }
                if (this.debug) {
                    System.out.println("[FileMonitorTest]===>Date Pattern Replaced Value-->" + string3);
                }
            }
            if (string3 == null || string2 == null || string3.trim().length() == 0 || string2.trim().length() == 0) {
                return false;
            }
            String string6 = "";
            String string7 = "";
            String string8 = "";
            int n = string3.indexOf("*");
            int n2 = string3.length();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "*");
            int n3 = stringTokenizer2.countTokens();
            if (this.debug) {
                System.out.println("[FileMonitorTest].getFilePatternMatch() Index value ==> " + n);
                System.out.println("[FileMonitorTest].getFilePatternMatch() Length value ==> " + n2);
                System.out.println("[FileMonitorTest].getFilePatternMatch() Tokens count ==> " + n3);
            }
            try {
                if (n3 == 1) {
                    if (n == 0 && !string3.endsWith("*")) {
                        string6 = string3.substring(1, n2);
                        if (this.debug) {
                            System.out.println("[FileMonitorTest].getFilePatternMatch() Key patt (*web) ==>" + string6);
                        }
                        if (!string2.endsWith(string6)) continue;
                        return true;
                    }
                    if (n == n2 - 1) {
                        string6 = string3.substring(0, n2 - 1);
                        if (this.debug) {
                            System.out.println("[FileMonitorTest].getFilePatternMatch() Key patt (web*) ==>" + string6);
                        }
                        if (!string2.startsWith(string6)) continue;
                        return true;
                    }
                    if (n == -1) {
                        if (!string2.equals(string3)) continue;
                        if (this.debug) {
                            System.out.println("[FileMonitorTest].getFilePatternMatch() Key patt (weblogic) ==>" + string3);
                        }
                        return true;
                    }
                    if (!string3.startsWith("*") || !string3.endsWith("*")) continue;
                    int n4 = string3.indexOf("*");
                    int n5 = string3.lastIndexOf("*");
                    string6 = string3.substring(n4 + 1, n5);
                    if (this.debug) {
                        System.out.println("[FileMonitorTest].getFilePatternMatch() Key patt (*web*) ==>" + string6);
                    }
                    if (string2.indexOf(string6) <= 0) continue;
                    return true;
                }
                if (n3 != 2 || n <= 0 || n >= n2) continue;
                string7 = string3.substring(0, n);
                string8 = string3.substring(n + 1, n2);
                if (this.debug) {
                    System.out.println("[FileMonitorTest].getFilePatternMatch() Key patt (web*gic) lhs & rhs ==>" + string7 + " vs " + string8);
                }
                if (!string2.startsWith(string7) || !string2.endsWith(string8)) continue;
                return true;
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "FileMonitor.getFilePatternMatch", "This Pattern match not supported ==> " + string3);
                return false;
            }
        }
        return false;
    }

    private Hashtable getMultiPathInfo(String string, String string2) {
        int n;
        int n2;
        int n3;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable<String, Hashtable<String, String>> hashtable3 = new Hashtable<String, Hashtable<String, String>>();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            n3 = string4.length();
            n2 = string4.indexOf("@");
            if (n2 == -1) {
                return null;
            }
            try {
                string3 = string4.substring(0, n2);
                n = string3.length();
                if (n <= 0 || n3 <= n) continue;
                string4 = string4.substring(n2 + 1, n3);
                hashtable.put(string3, string4);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "FileMonitor.getMultiPathInfo", exception.toString());
                return null;
            }
        }
        while (stringTokenizer2.hasMoreTokens()) {
            string5 = stringTokenizer2.nextToken();
            n3 = string5.indexOf("@");
            n2 = string5.length();
            if (n3 == -1) {
                return null;
            }
            try {
                string3 = string5.substring(0, n3);
                n = string3.length();
                if (n <= 0 || n2 <= n) continue;
                string5 = string5.substring(n3 + 1, n2);
                if (hashtable2.containsKey(string3)) {
                    String string6 = (String)hashtable2.get(string3);
                    string5 = string6 + "," + string5;
                }
                hashtable2.put(string3, string5);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "FileMonitor.getMultiPathInfo", exception.toString());
                return null;
            }
        }
        if (this.debug) {
            System.out.println("[FileMonitorTest].getMultiPathInfo() Path Hash values (Info + Path) ==>" + hashtable);
            System.out.println("[FileMonitorTest].getMultiPathInfo() Pattern table Hash values (Info + Pattern) ==>" + hashtable2);
        }
        if (hashtable.size() > 0 && hashtable.size() == hashtable2.size()) {
            hashtable3.put("path", hashtable);
            hashtable3.put("patt", hashtable2);
            return hashtable3;
        }
        this.logToErrorFile("Error", "FileMonitor.getMultiPathInfo", "Path and Pattern Info values not matched");
        return null;
    }

    private String getDateForm(String string) {
        String string2 = "YYYYMMDD";
        String string3 = "YYYYDDMM";
        String string4 = "DDMMYYYY";
        String string5 = "DDYYYYMM";
        String string6 = "MMDDYYYY";
        String string7 = "MMYYYYDD";
        String string8 = "YYMMDD";
        String string9 = "YYDDMM";
        String string10 = "DDMMYY";
        String string11 = "DDYYMM";
        String string12 = "MMDDYY";
        String string13 = "MMYYDD";
        String string14 = "";
        if (string.indexOf(string2) != -1) {
            string14 = string2;
        } else if (string.indexOf(string3) != -1) {
            string14 = string3;
        } else if (string.indexOf(string4) != -1) {
            string14 = string4;
        } else if (string.indexOf(string5) != -1) {
            string14 = string5;
        } else if (string.indexOf(string6) != -1) {
            string14 = string6;
        } else if (string.indexOf(string7) != -1) {
            string14 = string7;
        } else if (string.indexOf(string8) != -1) {
            string14 = string8;
        } else if (string.indexOf(string9) != -1) {
            string14 = string9;
        } else if (string.indexOf(string10) != -1) {
            string14 = string10;
        } else if (string.indexOf(string11) != -1) {
            string14 = string11;
        } else if (string.indexOf(string12) != -1) {
            string14 = string12;
        } else if (string.indexOf(string13) != -1) {
            string14 = string13;
        } else {
            if (this.debug) {
                this.logToErrorFile("Error", "FileMonitor.getDateForm", "This Date format not supported by eG Monitor " + string);
            }
            return null;
        }
        char[] cArray = string14.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == 'Y') {
                cArray[i] = 121;
                continue;
            }
            if (c == 'D') {
                cArray[i] = 100;
                continue;
            }
            if (c != 'm') continue;
            cArray[i] = 77;
        }
        String string15 = new String(cArray);
        return string15;
    }

    private String applyDatePattern(String string) {
        try {
            String string2 = string;
            String string3 = this.getDateForm(string);
            if (string3 == null || string3.trim().length() == 0) {
                return null;
            }
            String string4 = string3.toUpperCase();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
            Date date = new Date();
            String string5 = simpleDateFormat.format(date).toString();
            String string6 = FileMonitorTest.replace(string2, string4, string5);
            return string6;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string2.length();
        int n2 = string.length();
        while ((n2 = string.lastIndexOf(string2, n2 - 1)) > -1) {
            stringBuffer.replace(n2, n2 + n, string3);
        }
        return stringBuffer.toString();
    }

    private File[] getArchiveLogFiles(File file) {
        try {
            int n;
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                for (n = 0; n < fileArray.length; ++n) {
                    if (fileArray[n].isFile()) {
                        this.allFiles.add(fileArray[n]);
                        continue;
                    }
                    if (!this.isSubDir || !fileArray[n].isDirectory()) continue;
                    this.getArchiveLogFiles(fileArray[n]);
                }
            }
            if (this.allFiles != null && this.allFiles.size() > 0) {
                n = this.allFiles.size();
                File[] fileArray2 = new File[n];
                for (int i = 0; i < n; ++i) {
                    fileArray2[i] = (File)this.allFiles.get(i);
                }
                return fileArray2;
            }
            return null;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "FileMonitor.getArchiveLogFiles", exception.toString());
            return null;
        }
    }

    public static void main(String[] stringArray) {
        FileMonitorTest fileMonitorTest = new FileMonitorTest(stringArray);
        fileMonitorTest.computeMeasures(new Hashtable());
    }
}

