/*
 * Decompiled with CFR 0.152.
 */
import com.eg.snmpgetsubtree;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class EgSnmpGenericTest
extends GenericTest {
    public static boolean logOutput = false;
    private boolean useThread = false;
    public String community = "public";
    public String snmpWalkCmd = "snmpgetsubtree";
    private boolean isWindowsOS = false;
    public String[] lhs;
    public String[] rhs;
    public boolean isSnmpV2 = false;
    private EgUtilities egutil = EgUtilities.createInstance();
    private int timeOut = 10;
    public String snmpPortNo = "161";
    private static Hashtable snmpMetrics = new Hashtable();
    private static long maxSnmpMetrics = 100000L;
    public String username = null;
    public String authPass = null;
    public String authType = null;
    public String snmpVersion = "v1";
    public String encryptType = null;
    public String encryptPass = null;
    public String transportLayer = "udp";
    public String managementCardIp = null;
    public String primaryControllerIP = null;
    public String secondaryControllerIP = null;
    public boolean isEncryptionEnabled = false;
    public String str_Context = "";
    public String engineIDVal = "";
    public String test_name = "";
    protected Hashtable resultMsg = new Hashtable();
    public String mibName;
    private static String logSync = new String("log");
    private static String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "SNMPResultLog";
    private static double MB_TO_BYTES = 1048576.0;
    private static double DEBUG_LOG_FILE_SIZE_IN_MB = 10.0;
    private static double debugLogSizeLimitInMB = DEBUG_LOG_FILE_SIZE_IN_MB * MB_TO_BYTES;

    public EgSnmpGenericTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        String string4;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpversion");
        if (this.snmpVersion == null) {
            this.snmpVersion = "v1";
        }
        if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2") || this.snmpVersion.equalsIgnoreCase("none")) {
            this.community = this.getValueForParam("snmpCommunity");
            if (this.community == null) {
                this.community = "none";
            }
        } else {
            this.username = this.getValueForParam("username");
            string4 = this.getValueForParam("authpass");
            if (string4 != null) {
                this.authPass = EgCrypt.decrypt(string4);
            }
            this.authType = this.getValueForParam("authtype");
            string3 = this.getValueForParam("encryptflag");
            if (string3 != null) {
                this.isEncryptionEnabled = new Boolean(string3);
            }
            if (this.isEncryptionEnabled) {
                this.encryptType = this.getValueForParam("encrypttype");
                string2 = this.getValueForParam("encryptpassword");
                if (string2 != null) {
                    this.encryptPass = EgCrypt.decrypt(string2);
                }
                if (this.encryptType == null) {
                    this.encryptType = "des";
                } else if (this.encryptPass == null) {
                    this.encryptPass = "none";
                }
            }
            if (this.username == null) {
                this.username = "none";
            } else if (this.authPass == null) {
                this.authPass = "none";
            } else if (this.authType == null) {
                this.authType = "md5";
            }
            string2 = this.getValueForParam("engineid");
            this.engineIDVal = string2 != null && (string2.trim().equalsIgnoreCase("true") || string2.trim().equalsIgnoreCase("yes")) ? "yes" : "no";
        }
        if ((string4 = System.getProperty("os.name").toLowerCase()).indexOf("win") >= 0) {
            this.isWindowsOS = true;
        }
        if (this.snmpPortNo == null || this.snmpPortNo.equals("")) {
            this.snmpPortNo = "161";
            return;
        }
        if (this.community == null || this.community.equals("")) {
            this.community = "none";
        }
        try {
            Integer.parseInt(this.snmpPortNo);
        }
        catch (NumberFormatException numberFormatException) {
            this.snmpPortNo = "161";
            numberFormatException.printStackTrace();
        }
        string3 = this.getValueForParam("timeout");
        this.timeOut = 10;
        if (string3 != null) {
            try {
                int n;
                this.timeOut = n = Integer.parseInt(string3);
            }
            catch (Exception exception) {}
        } else {
            string2 = System.getProperty("SNMPTIMEOUT");
            if (string2 != null) {
                int n = 10;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeOut = n;
            }
        }
        this.transportLayer = (string = this.getValueForParam("data_over_tcp")) != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes")) ? "tcp" : "udp";
        this.managementCardIp = this.getValueForParam("management_card_ip");
        if (this.managementCardIp != null) {
            this.targetHost = this.managementCardIp;
        }
        this.primaryControllerIP = this.getValueForParam("primary_controller_ip");
        if (this.primaryControllerIP != null) {
            this.targetHost = this.primaryControllerIP;
        }
        this.secondaryControllerIP = this.getValueForParam("secondary_controller_ip");
        this.str_Context = this.getValueForParam("context");
        if (this.str_Context == null || this.str_Context.length() == 0 || this.str_Context.equalsIgnoreCase("none")) {
            this.str_Context = "";
        }
        this.useThread = EgMainAgent.snmpExecThread;
    }

    public boolean runSnmpCmdForOid(String string) {
        long l = System.currentTimeMillis();
        boolean bl = this.runSnmpCmdForOid(string, this.targetHost);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (logOutput) {
            this.printOut(new Date() + "," + string + "," + this.targetHost + "," + l3 + "," + bl);
        }
        return bl;
    }

    public void reportMetrics(String string, String string2, long l, boolean bl) {
        ArrayList arrayList;
        Hashtable hashtable;
        if ((long)snmpMetrics.size() > maxSnmpMetrics) {
            snmpMetrics.clear();
        }
        if ((hashtable = (Hashtable)snmpMetrics.get(this.entity)) == null) {
            hashtable = new Hashtable();
            snmpMetrics.put(this.entity, hashtable);
        }
        if ((arrayList = (ArrayList)hashtable.get(this.reportingName)) == null) {
            arrayList = new ArrayList();
            hashtable.put(this.reportingName, arrayList);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(string);
        arrayList2.add(string2);
        arrayList2.add(new Long(l));
        arrayList2.add(new Boolean(bl));
        arrayList.add(arrayList2);
    }

    public boolean runSnmpCmdForOid(String string, String string2, boolean bl) {
        this.test_name = string2;
        boolean bl2 = this.runSnmpCmdForOid(string, this.targetHost);
        return bl2;
    }

    public boolean runSnmpCmdForOid(String string, String string2) {
        Object object;
        int n;
        int n2;
        Object object2;
        ArrayList arrayList;
        Object object3;
        if (string == null || this.toEnd) {
            return false;
        }
        this.startTime = System.currentTimeMillis();
        if (string.endsWith(".0")) {
            string = string.substring(0, string.lastIndexOf(".0"));
        }
        if (this.isSnmpV2) {
            this.snmpVersion = "v2";
        }
        String[] stringArray = null;
        stringArray = this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2") ? new String[]{"-p", "" + this.snmpPortNo, "-c", this.community, "-o", "-v", this.snmpVersion.equalsIgnoreCase("v1") ? "1" : "2", string2, string, this.transportLayer} : (!this.isEncryptionEnabled ? new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, string2, string, "-n", this.str_Context, this.engineIDVal, this.transportLayer} : new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, "-x", this.encryptType, "-X", this.encryptPass, string2, string, "-n", this.str_Context, this.engineIDVal, this.transportLayer});
        ArrayList arrayList2 = new ArrayList();
        if (this.test_name != null && this.test_name.equalsIgnoreCase("NetworkConnTest")) {
            object3 = new snmpgetsubtree(stringArray, this.timeOut, EgMainAgent.snmpRetries, this.test_name);
            arrayList2 = ((snmpgetsubtree)object3).getSubTree();
        } else if (this.useThread) {
            object3 = new EgSnmpGenericTestHelper(stringArray, this.timeOut, EgMainAgent.snmpRetries, this.test_name);
            boolean bl = this.checkForTimeout((EgSnmpGenericTestHelper)object3, (long)this.timeOut * 1500L);
            arrayList2 = bl ? ((EgSnmpGenericTestHelper)object3).measureValList : null;
        } else {
            object3 = new snmpgetsubtree(stringArray, this.timeOut, EgMainAgent.snmpRetries, this.test_name);
            arrayList2 = ((snmpgetsubtree)object3).getSubTree();
        }
        object3 = "";
        String string3 = "";
        if (arrayList2 != null && arrayList2.size() == 0) {
            object3 = string;
            int n3 = ((String)object3).lastIndexOf(".");
            string3 = ((String)object3).substring(0, n3);
            if (this.isSnmpV2) {
                this.snmpVersion = "v2";
            }
            if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2")) {
                stringArray[8] = string3;
            } else if (!this.isEncryptionEnabled) {
                stringArray[14] = string3;
            } else {
                stringArray[18] = string3;
            }
            arrayList = new ArrayList();
            if (this.test_name != null && this.test_name.equalsIgnoreCase("NetworkConnTest")) {
                object2 = new snmpgetsubtree(stringArray, this.timeOut, EgMainAgent.snmpRetries, this.test_name);
                arrayList = ((snmpgetsubtree)object2).getSubTree();
            } else if (this.useThread) {
                object2 = new EgSnmpGenericTestHelper(stringArray, this.timeOut, EgMainAgent.snmpRetries, this.test_name);
                n2 = this.checkForTimeout((EgSnmpGenericTestHelper)object2, (long)this.timeOut * 1500L) ? 1 : 0;
                if (n2 != 0) {
                    arrayList = ((EgSnmpGenericTestHelper)object2).measureValList;
                }
            } else {
                object2 = new snmpgetsubtree(stringArray, this.timeOut, EgMainAgent.snmpRetries, this.test_name);
                arrayList = ((snmpgetsubtree)object2).getSubTree();
            }
            object2 = "";
            if (arrayList != null && arrayList.size() > 0) {
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    object2 = (String)arrayList.get(n);
                    object = new StringTokenizer((String)object2, "=");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string4 = ((StringTokenizer)object).nextToken();
                        if (!string4.equalsIgnoreCase(string)) continue;
                        arrayList2.add(object2);
                    }
                }
            }
        }
        this.resultMsg = new Hashtable();
        this.lhs = null;
        this.rhs = null;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList = new ArrayList();
        this.mibName = string;
        if (arrayList2 != null && arrayList2.size() > 0) {
            n2 = arrayList2.size();
            for (n = 0; n < n2; ++n) {
                int n4;
                object = ((String)arrayList2.get(n)).trim();
                if (object != null && ((String)object).indexOf("time out after retries") > -1) {
                    this.resultMsg.put("Exception", (String)arrayList2.get(0));
                    return false;
                }
                if (!((String)object).startsWith(string) || (n4 = ((String)object).indexOf(61)) < 0) continue;
                String string5 = ((String)object).substring(0, n4);
                String string6 = ((String)object).substring(n4 + 1);
                String string7 = this.replace(string5, string, "");
                if (string7.length() > 0) {
                    string7 = new String(string7.substring(1));
                }
                if (string6.indexOf("\"") > -1) {
                    string6 = this.replace(string6, "\"", "");
                }
                arrayList3.add(string6);
                arrayList.add(string7);
            }
            object2 = arrayList3.toArray();
            this.rhs = new String[((Object[])object2).length];
            for (n = 0; n < ((Object[])object2).length; ++n) {
                this.rhs[n] = object2[n].toString();
            }
            object2 = arrayList.toArray();
            this.lhs = new String[((Object)object2).length];
            for (n = 0; n < ((Object)object2).length; ++n) {
                this.lhs[n] = object2[n].toString();
            }
            return this.lhs.length > 0;
        }
        String string8 = "Failed to get output from the target host, Kindly check the credentials which you have provided";
        this.resultMsg.put("Exception", string8);
        StringBuffer stringBuffer = new StringBuffer("java com/eg/snmpgetsubtree");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" ");
            if (this.snmpVersion.equalsIgnoreCase("v3")) {
                if (this.str_Context != null && this.str_Context.trim().length() == 0) {
                    if (!this.isEncryptionEnabled && i == 16) {
                        stringArray[i] = "\"\"";
                    } else if (this.isEncryptionEnabled && i == 20) {
                        stringArray[i] = "\"\"";
                    }
                }
                if (this.engineIDVal == null || this.engineIDVal.trim().length() == 0) {
                    if (!this.isEncryptionEnabled && i == 17) {
                        stringArray[i] = "no";
                    } else if (this.isEncryptionEnabled && i == 21) {
                        stringArray[i] = "no";
                    }
                }
                if (this.authPass != null && this.authPass.trim().length() == 0 && i == 12) {
                    stringArray[i] = "\" \"";
                }
                if (this.authPass != null && this.authPass.trim().length() > 0 && i == 12) {
                    stringArray[i] = EgCrypt.encrypt(stringArray[i]);
                }
                if (this.isEncryptionEnabled) {
                    if (this.encryptPass != null && this.encryptPass.trim().length() == 0 && i == 16) {
                        stringArray[i] = "\" \"";
                    }
                    if (this.encryptPass != null && this.encryptPass.trim().length() > 0 && i == 16) {
                        stringArray[i] = EgCrypt.encrypt(stringArray[i]);
                    }
                }
            }
            stringBuffer.append(stringArray[i]);
        }
        this.errorMsg = new String("Failed to run " + stringBuffer + " for " + this.reportingName + " with community " + this.community + " and MIB=" + this.mibName);
        System.out.println(new Date() + "From EgSnmpGenericTest :" + this.errorMsg);
        return false;
    }

    public String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    public void freeTest() {
        this.lhs = null;
        this.rhs = null;
    }

    public boolean checkForTimeout(EgSnmpGenericTestHelper egSnmpGenericTestHelper, long l) {
        long l2;
        long l3 = 0L;
        long l4 = 50L;
        do {
            this.suspendForPeriod(l4);
            if (egSnmpGenericTestHelper.done) {
                return true;
            }
            if ((l3 += l4) >= l) {
                egSnmpGenericTestHelper.interrupt();
                Thread.currentThread();
                Thread.yield();
                egSnmpGenericTestHelper.stop();
                System.out.println(new Date() + " ====> [EgSnmpGenericTest] totalSleepTime is greater than timeout ,thread killed and checkForTimeout returned false for " + this.reportingName);
                return false;
            }
            l2 = l4;
            if (l - l3 >= l2) continue;
            l2 = l - l3;
        } while ((l4 = l2) > 0L);
        egSnmpGenericTestHelper.interrupt();
        Thread.currentThread();
        Thread.yield();
        egSnmpGenericTestHelper.stop();
        System.out.println(new Date() + " ====>[EgSnmpGenericTest] sleepTime less than zero ,thread killed and checkForTimeout returned false for " + this.reportingName);
        return false;
    }

    public void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void printOut(String string) {
        this.debugLogToFile(this.reportingName + "," + this.entity + "," + string, debugLogSizeLimitInMB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = logSync;
                synchronized (string3) {
                    if (file.exists() && (double)file.length() >= d) {
                        String string4 = string2 + ".1";
                        File file2 = new File(string4);
                        if (file2.exists() && (double)file2.length() >= d) {
                            String string5 = string2 + ".2";
                            File file3 = new File(string5);
                            if (file3.exists() && (double)file3.length() >= d) {
                                String string6 = string2 + ".3";
                                File file4 = new File(string6);
                                if (file4.exists()) {
                                    file4.delete();
                                }
                                EgInstallInfo.fileRename(string5, string6);
                            }
                            EgInstallInfo.fileRename(string4, string5);
                        }
                        EgInstallInfo.fileRename(string2, string4);
                    }
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract void computeMeasures(Hashtable var1);

    class EgSnmpGenericTestHelper
    extends Thread {
        public boolean done = false;
        private String[] args = null;
        private int timeOut1 = 10;
        private int retry1 = 2;
        private String testName1 = "";
        public ArrayList measureValList = null;

        public EgSnmpGenericTestHelper(String[] stringArray, int n, int n2, String string) {
            this.start();
            this.args = stringArray;
            this.timeOut1 = n;
            this.retry1 = n2;
            this.testName1 = string;
            this.measureValList = new ArrayList();
        }

        public void run() {
            snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(this.args, this.timeOut1, this.retry1, this.testName1);
            this.measureValList = snmpgetsubtree2.getSubTree();
            this.done = true;
        }
    }
}

