/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.PCFParameter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ServiceConfigurationError;

public class EgMq {
    PCFMessageAgent pcfmessageagent;
    MQQueueManager mqQueueManager;
    MQQueueManager qMgr = null;
    MQQueue queue;
    public int numDDMessages = 20;
    public int messageLimit = 1000;
    public boolean messageOverLimit = false;
    EgDateInfo dateInfo = null;
    boolean pcf_init = false;
    String host = null;
    int port = -1;
    String srvConn = null;
    String qmgr = null;
    public double qmgr_avail = 0.0;
    public double qmgr_resp = -1.0;
    public double port_avail = 0.0;
    public double conn_avail = 0.0;
    public Hashtable messageHash = new Hashtable();
    public Hashtable qstats = new Hashtable();
    public Hashtable corruptedQueuestats = new Hashtable();
    private Hashtable htProps = new Hashtable();
    public Hashtable channelstats = new Hashtable();
    String[] lqueues = null;
    String[] channels = null;
    private String user = null;
    private String pass = null;
    private int numQstats = 4;
    private int numChannelstats = 9;
    private Hashtable lastChannelTime = new Hashtable();
    private Hashtable lastChannelSend = new Hashtable();
    private boolean isQMconnect = false;
    boolean ignoreSystemChannels = true;
    ArrayList includeChannelsList = new ArrayList();
    boolean includeChannelsFlag = false;
    ArrayList excludeChannelsList = new ArrayList();
    boolean excludeChannelsFlag = false;
    boolean showInactiveChannels = true;
    protected static String logMessage = "";
    protected static String strLogSizeLimitInMB = null;
    protected long collectionTimeout = 120L;
    protected static final String TEST_NAME = "EgMq";
    protected static final String LOG_FILE_NAME = "EgMqLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "EgMqLogSizeLimitInMB";
    protected static final String DEBUG_LOG_ABSOLUTE_PATH = EgInstallInfo.getInstallDir() + "/agent/logs/" + "EgMqLog";
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double MB_TO_TB = 1048576.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 20.0;
    protected double debugLogSizeLimitInMB = 2.097152E7;
    String entity = "";
    String reportingName = "";

    private boolean mqConnect() {
        try {
            double d = System.currentTimeMillis();
            this.mqQueueManager = new MQQueueManager(this.qmgr, this.htProps);
            double d2 = System.currentTimeMillis();
            this.qmgr_avail = 100.0;
            this.qmgr_resp = (d2 - d) / 1000.0;
            this.isQMconnect = true;
            return true;
        }
        catch (MQException mQException) {
            this.logToErrorFile("ERROR", "EgMq.mqConnect()", "Unable to Connect Queue Manager " + this.qmgr);
            System.out.println("Error in queue manager connect....");
            System.out.println("QMGR Name : " + this.qmgr);
            System.out.println("CC   : " + mQException.completionCode);
            System.out.println("RC   : " + mQException.reasonCode);
            mQException.printStackTrace();
            System.out.println("[EgMq]Mqconnect host:" + this.host + " " + new Date());
            System.out.println("[EgMq]Mqconnect Port:" + this.port + " " + new Date());
            System.out.println("[EgMq]Mqconnect user:" + this.user + " " + new Date());
            System.out.println("[EgMq]Mqconnect srvConn:" + this.srvConn + " " + new Date());
            this.qmgr_avail = 0.0;
            this.qmgr_resp = -1.0;
            this.isQMconnect = false;
            this.mqQueueManager = null;
            this.printOutStackTrace("EgMq.mqConnect() Unable to Connect Queue Manager " + this.qmgr, (Exception)((Object)mQException));
            return false;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.mqConnect()", "Unable to Connect Queue Manager " + this.qmgr);
            System.out.println("Error in queue manager connect....");
            System.out.println("QMGR Name : " + this.qmgr + " " + new Date());
            System.out.println("[EgMq]Mqconnect host:" + this.host + " " + new Date());
            System.out.println("[EgMq]Mqconnect Port:" + this.port + " " + new Date());
            System.out.println("[EgMq]Mqconnect user:" + this.user + " " + new Date());
            System.out.println("[EgMq]Mqconnect srvConn:" + this.srvConn + " " + new Date());
            exception.printStackTrace();
            this.qmgr_avail = 0.0;
            this.qmgr_resp = -1.0;
            this.isQMconnect = false;
            this.mqQueueManager = null;
            this.printOutStackTrace("EgMq.mqConnect() Unable to Connect Queue Manager " + this.qmgr, exception);
            return false;
        }
    }

    private void mqDisconnect() {
        if (this.pcfmessageagent != null) {
            try {
                this.pcfmessageagent.disconnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pcfmessageagent = null;
        }
        try {
            if (this.mqQueueManager != null) {
                this.mqQueueManager.disconnect();
                this.mqQueueManager = null;
            }
        }
        catch (MQException mQException) {
            this.logToErrorFile("ERROR", "EgMq.mqDisconnect()", "Unable to DisConnect Queue Manager " + this.qmgr);
            System.out.println("Error in queue manager disconnect....");
            System.out.println("QMGR Name : " + this.qmgr);
            System.out.println("CC   : " + mQException.completionCode);
            System.out.println("RC   : " + mQException.reasonCode);
            System.out.println("[EgMq]mqDisconnect host:" + this.host + " " + new Date());
            System.out.println("[EgMq]mqDisconnect Port:" + this.port + " " + new Date());
            System.out.println("[EgMq]mqDisconnect user:" + this.user + " " + new Date());
            System.out.println("[EgMq]mqDisconnect srvConn:" + this.srvConn + " " + new Date());
            this.mqQueueManager = null;
            mQException.printStackTrace();
            this.printOutStackTrace("EgMq.mqDisconnect()Unable to DisConnect Queue Manager " + this.qmgr, (Exception)((Object)mQException));
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.mqDisconnect()", "Unable to DisConnect Queue Manager " + this.qmgr);
            System.out.println("Error in QManager disconnect ");
            System.out.println("[EgMq]mqDisconnect host:" + this.host + " " + new Date());
            System.out.println("[EgMq]mqDisconnect Port:" + this.port + " " + new Date());
            System.out.println("[EgMq]mqDisconnect user:" + this.user + " " + new Date());
            System.out.println("[EgMq]mqDisconnect srvConn:" + this.srvConn + " " + new Date());
            this.mqQueueManager = null;
            exception.printStackTrace();
            this.printOutStackTrace("EgMq.mqDisconnect()Unable to DisConnect Queue Manager " + this.qmgr, exception);
        }
        this.isQMconnect = false;
    }

    public boolean isOpen() {
        return this.doesSocketExist(this.host, this.port, 15000);
    }

    private boolean doesSocketExist(String string, int n, int n2) {
        long l;
        TcpHelperThread tcpHelperThread = new TcpHelperThread(string, n, n2);
        long l2 = 0L;
        long l3 = 10L;
        do {
            this.suspendForPeriod(l3);
            if (tcpHelperThread.done) {
                this.logToErrorFile("INFO :", "EgMq.doesSocketExist()", "host:" + this.host + " , Port:" + this.port + " TcpHelperThread complete the process and status : " + tcpHelperThread.status);
                return tcpHelperThread.status;
            }
            if ((l2 += l3) >= (long)n2) {
                tcpHelperThread.interrupt();
                this.logToErrorFile("WARNING :", "EgMq.doesSocketExist()", "host:" + this.host + " , Port:" + this.port + "totalSleepTime  : " + l2 + " timeOut: " + n2 + "  TcpHelperThread interrupt the process and doesSocketExist method returned as  false ");
                this.printOut("WARNING :EgMq.doesSocketExist() host:" + this.host + " , Port:" + this.port + "totalSleepTime  : " + l2 + " timeOut: " + n2 + "  TcpHelperThread interrupt the process and doesSocketExist method returned as  false ");
                Thread.currentThread();
                Thread.yield();
                tcpHelperThread = null;
                return false;
            }
            l = l3;
            if ((long)n2 - l2 >= l) continue;
            l = (long)n2 - l2;
        } while ((l3 = l) > 0L);
        tcpHelperThread.interrupt();
        this.logToErrorFile("WARNING :", "EgMq.doesSocketExist()", "host:" + this.host + " , Port:" + this.port + " sleepTime  : " + l3 + "  TcpHelperThread interrupt the process and and doesSocketExist method returned as  false  ");
        this.printOut("WARNING :EgMq.doesSocketExist() host:" + this.host + " , Port:" + this.port + " sleepTime  : " + l3 + "  TcpHelperThread interrupt the process and and doesSocketExist method returned as  false  ");
        Thread.currentThread();
        Thread.yield();
        tcpHelperThread = null;
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", "EgMq.suspendForPeriod()", "host:" + this.host + " , Port:" + this.port + " sleepPeriod  : " + l + "  exception raised in the  Thread.currentThread().sleep method   ");
                this.printOut("ERROR :EgMq.suspendForPeriod() host:" + this.host + " , Port:" + this.port + " sleepPeriod  : " + l + "  exception raised in the  Thread.currentThread().sleep method   ");
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void checkPorts() {
        this.port_avail = 0.0;
        this.conn_avail = 0.0;
        boolean bl = this.isOpen();
        if (!bl) {
            return;
        }
        this.port_avail = 100.0;
        bl = this.initPcf();
        if (!bl) {
            return;
        }
        this.conn_avail = 100.0;
    }

    public static void main(String[] stringArray) {
        EgMq egMq = new EgMq();
        if (stringArray.length < 2) {
            System.out.println("Args: ip port srvrConnection");
            return;
        }
        int n = Integer.parseInt(stringArray[1]);
        if (stringArray.length < 3) {
            egMq.setAttributes(stringArray[0], n, "SYSTEM.DEF.SVRCONN");
        } else if (stringArray.length < 5) {
            egMq.setAttributes(stringArray[0], n, stringArray[2]);
        } else {
            egMq.setAttributes(stringArray[0], n, stringArray[2], stringArray[3], stringArray[4]);
        }
        egMq.checkPorts();
        System.out.println("CheckPorts: " + egMq.port_avail + " " + egMq.conn_avail);
        egMq.checkQmgr(true);
        System.out.println("QueueManager: " + egMq.qmgr + " " + egMq.qmgr_avail + " " + egMq.qmgr_resp);
        egMq.checkQueues();
        egMq.checkChannels();
        egMq.end();
        egMq.printResults(egMq.qstats, "*********** QUEUE STATS *************", egMq.numQstats);
        egMq.printResults(egMq.channelstats, "*********** CHANNEL STATS *************", egMq.numChannelstats);
    }

    public void printResults(Hashtable hashtable, String string, int n) {
        System.out.println(string);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            double[] dArray = (double[])hashtable.get(string2);
            if (dArray == null || dArray.length < n) continue;
            String string3 = "";
            for (int i = 0; i < n; ++i) {
                string3 = string3 + dArray[i] + " ";
            }
            System.out.println(string2 + " --- " + string3);
        }
    }

    public void checkChannels() {
        try {
            String string;
            int n;
            this.channelstats = new Hashtable();
            if (!this.pcf_init) {
                this.initPcf();
            }
            if (!this.pcf_init) {
                this.endPcf();
                return;
            }
            try {
                this.getChannelnames();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "EgMq.checkChannels()", "host:" + this.host + " , Port:" + this.port + " Unable to get Channel Names " + exception.toString());
                this.printOutStackTrace("ERROR  EgMq.checkChannels() host:" + this.host + " , Port:" + this.port + " Unable to get Channel Names ", exception);
            }
            if (this.channels == null) {
                this.endPcf();
                return;
            }
            for (n = 0; n < this.channels.length; ++n) {
                string = this.channels[n].trim();
                double[] dArray = this.getChannelStatus(string);
                if (dArray != null) {
                    this.channelstats.put(string, dArray);
                    continue;
                }
                boolean bl = false;
                if (this.includeChannelToList(string)) {
                    bl = true;
                } else if (!this.excludeChannelToList(string) && this.showInactiveChannels && !this.ignoreSystemChannelToList(string)) {
                    bl = true;
                }
                if (!bl) continue;
                dArray = this.getInactiveChannelStatus();
                this.channelstats.put(string, dArray);
            }
            for (n = 0; n < this.channels.length; ++n) {
                string = this.channels[n].trim();
                if (!this.excludeChannelToList(string) || this.includeChannelToList(string)) continue;
                this.channelstats.remove(string);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.checkChannels()", "host:" + this.host + " , Port:" + this.port + " Unable to get Channel Names " + exception.toString());
            this.printOutStackTrace("ERROR EgMq.checkChannels() host:" + this.host + " , Port:" + this.port + " Unable to get Channel Names ", exception);
            exception.printStackTrace();
        }
    }

    public void checkChannels(boolean bl) {
        try {
            if (!bl) {
                this.checkChannels();
            } else {
                this.getChannelStatusV6();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable peekQueues() {
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        try {
            this.checkQmgr(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qmgr == null) {
            return null;
        }
        if (this.mqConnect()) {
            try {
                this.lqueues = this.getQnames();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.lqueues == null) {
                this.mqDisconnect();
                return null;
            }
            try {
                for (int i = 0; i < this.lqueues.length; ++i) {
                    ArrayList arrayList = this.mqPeek(this.lqueues[i]);
                    if (arrayList == null || arrayList.size() == 0) {
                        hashtable.put(this.lqueues[i], new ArrayList());
                        continue;
                    }
                    hashtable.put(this.lqueues[i], arrayList);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mqDisconnect();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable peekQueues(boolean bl, ArrayList arrayList) {
        Hashtable<String, ArrayList> hashtable;
        block25: {
            hashtable = new Hashtable<String, ArrayList>();
            if (this.messageHash != null) {
                this.messageHash.clear();
            }
            try {
                String string;
                try {
                    this.checkQmgr(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.qmgr == null) {
                    Hashtable hashtable2 = null;
                    return hashtable2;
                }
                if (!this.mqConnect()) break block25;
                try {
                    this.lqueues = this.getQnames();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.lqueues == null) {
                    this.mqDisconnect();
                    string = null;
                    return string;
                }
                try {
                    string = "";
                    for (int i = 0; i < this.lqueues.length; ++i) {
                        if (this.lqueues[i] == null) continue;
                        string = this.lqueues[i].trim().toLowerCase();
                        if (bl && string.startsWith("system.")) continue;
                        if (arrayList != null && arrayList.size() > 0) {
                            boolean bl2 = false;
                            for (int j = 0; j < arrayList.size(); ++j) {
                                String string2 = (String)arrayList.get(j);
                                if (!EgUtilities.isMatch((String)string, (String)string2)) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            try {
                                ArrayList arrayList2 = this.mqPeek(this.lqueues[i]);
                                if (arrayList2 == null || arrayList2.size() == 0) {
                                    hashtable.put(this.lqueues[i], new ArrayList());
                                    continue;
                                }
                                hashtable.put(this.lqueues[i], arrayList2);
                            }
                            catch (Exception exception) {
                                this.printOutStackTrace("ERROR while call the mqPeek  @@@  " + this.lqueues[i] + " - peekQueues_1 host:" + this.host + " , Port:" + this.port + " Exception happened before finally ", exception);
                            }
                            continue;
                        }
                        try {
                            ArrayList arrayList3 = this.mqPeek(this.lqueues[i]);
                            if (arrayList3 == null || arrayList3.size() == 0) {
                                hashtable.put(this.lqueues[i], new ArrayList());
                                continue;
                            }
                            hashtable.put(this.lqueues[i], arrayList3);
                            continue;
                        }
                        catch (Exception exception) {
                            this.printOutStackTrace("ERROR while call the mqPeek  ### " + this.lqueues[i] + " - peekQueues_1 host:" + this.host + " , Port:" + this.port + " Exception happened before finally ", exception);
                        }
                    }
                }
                catch (Exception exception) {
                    this.printOutStackTrace("ERROR peekQueues_1 host:" + this.host + " , Port:" + this.port + " Exception happened before finally ", exception);
                }
                this.mqDisconnect();
                this.endPcf();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "peekQueues_1", "host:" + this.host + " , Port:" + this.port + " Exception happened before finally ");
                this.printOutStackTrace("ERROR peekQueues_1 host:" + this.host + " , Port:" + this.port + " Exception happened before finally ", exception);
                System.out.println("host:" + this.host + " , Port:" + this.port + " [ERROR] peekQueues_1 : Exception happened before finally");
                exception.printStackTrace();
            }
            finally {
                System.out.println("host:" + this.host + " , Port:" + this.port + " [ERROR] peekQueues_1 : Inside finally");
                this.printOut("peekQueues_1 : Inside finally");
                this.mqDisconnect();
                this.endPcf();
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable peekQueues(boolean bl, ArrayList arrayList, boolean bl2) {
        Hashtable<String, ArrayList> hashtable;
        block22: {
            hashtable = new Hashtable<String, ArrayList>();
            if (this.messageHash != null) {
                this.messageHash.clear();
            }
            try {
                String string;
                try {
                    this.checkQmgr(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.qmgr == null) {
                    this.endPcf();
                    Hashtable hashtable2 = null;
                    return hashtable2;
                }
                if (!this.mqConnect()) break block22;
                try {
                    this.lqueues = this.getQnames();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.lqueues == null) {
                    this.mqDisconnect();
                    this.endPcf();
                    string = null;
                    return string;
                }
                try {
                    string = "";
                    if (arrayList != null && arrayList.size() > 0) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            String string2 = (String)arrayList.get(i);
                            for (int j = 0; j < this.lqueues.length; ++j) {
                                if (this.lqueues[j] == null) continue;
                                string = this.lqueues[j].trim().toLowerCase();
                                if (bl && string.startsWith("system.") || !EgUtilities.isMatch((String)string, (String)string2)) continue;
                                try {
                                    ArrayList arrayList2 = this.mqPeek(this.lqueues[j]);
                                    if (arrayList2 == null || arrayList2.size() == 0) {
                                        hashtable.put(this.lqueues[j], new ArrayList());
                                        continue;
                                    }
                                    hashtable.put(this.lqueues[j], arrayList2);
                                    continue;
                                }
                                catch (Exception exception) {
                                    this.printOutStackTrace("ERROR while call the mqPeek  %%%%  " + this.lqueues[j] + " - peekQueues host:" + this.host + " , Port:" + this.port + " Exception happened before finally ", exception);
                                }
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mqDisconnect();
                this.endPcf();
            }
            catch (Exception exception) {
                this.logToErrorFile("host:" + this.host + " , Port:" + this.port + " ERROR", "peekQueues_1", "Exception happened before finally ");
                this.printOutStackTrace("peekQueues : Exception happened before finally", exception);
                exception.printStackTrace();
            }
            finally {
                this.printOut("peekQueues : Inside finally");
                this.mqDisconnect();
                this.endPcf();
            }
        }
        return hashtable;
    }

    public void checkQueues() {
        this.qstats = new Hashtable();
        this.corruptedQueuestats = new Hashtable();
        try {
            this.checkQmgr(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qmgr == null) {
            return;
        }
        if (this.mqConnect()) {
            this.lqueues = this.getQnames();
            if (this.lqueues == null) {
                this.mqDisconnect();
                return;
            }
            for (int i = 0; i < this.lqueues.length; ++i) {
                Object object;
                if (this.mqOpen(this.lqueues[i])) {
                    try {
                        object = this.mqStats(this.lqueues[i]);
                        if (object != null) {
                            this.qstats.put(this.lqueues[i], object);
                        }
                    }
                    catch (Exception exception) {
                        this.printOutStackTrace("peekQueues : Exception happened while mqStats  ****", exception);
                        exception.printStackTrace();
                    }
                    this.mqClose(this.lqueues[i]);
                    continue;
                }
                object = new ArrayList();
                try {
                    int n = 0;
                    n = 40;
                    this.queue = this.mqQueueManager.accessQueue(this.lqueues[i], n, null, null, null);
                }
                catch (MQException mQException) {
                    this.printOutStackTrace("peekQueues : Exception happened while mqStats  mqExp &&& ", (Exception)((Object)mQException));
                    System.out.println("host:" + this.host + " , Port:" + this.port + " Error in opening queue ....");
                    System.out.println("host:" + this.host + " , Port:" + this.port + " Queue Name : " + this.lqueues[i]);
                    System.out.println("host:" + this.host + " , Port:" + this.port + " CC   : " + mQException.completionCode);
                    System.out.println("host:" + this.host + " , Port:" + this.port + " RC   : " + mQException.reasonCode);
                    ((ArrayList)object).add("" + mQException.completionCode);
                    ((ArrayList)object).add("" + mQException.reasonCode);
                    String string = null;
                    try {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        mQException.printStackTrace(printWriter);
                        string = stringWriter.toString();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        string = mQException.toString();
                    }
                    System.out.println(string);
                    ((ArrayList)object).add(string);
                    mQException.printStackTrace();
                }
                catch (Exception exception) {
                    this.printOutStackTrace("peekQueues : Exception happened while mqStats  grr ^^^ ", exception);
                    exception.printStackTrace();
                }
                double[] dArray = new double[]{-5.0, 1.0, -5.0, -5.0, -5.0, -5.0, 0.0};
                this.qstats.put(this.lqueues[i], dArray);
                this.corruptedQueuestats.put(this.lqueues[i], object);
                this.logToErrorFile("ERROR", "checkQueus", "host:" + this.host + " , Port:" + this.port + " Unable to open Queue or Queue corrupted " + this.lqueues[i]);
                System.out.println("host:" + this.host + " , Port:" + this.port + " [ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[i]);
                this.printOut("[ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[i]);
            }
            this.mqDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap checkQueues(boolean bl, ArrayList arrayList) {
        HashMap<String, Object> hashMap;
        block26: {
            this.qstats = new Hashtable();
            this.corruptedQueuestats = new Hashtable();
            hashMap = new HashMap<String, Object>();
            try {
                try {
                    this.checkQmgr(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.qmgr == null) {
                    this.endPcf();
                    HashMap hashMap2 = null;
                    return hashMap2;
                }
                if (!this.mqConnect()) break block26;
                this.lqueues = this.getQnames();
                this.printOut("checkQueues  List of queue size " + this.lqueues.length + " ,  Queues :" + this.lqueues);
                if (this.lqueues == null) {
                    this.printOut("List of queue is null, returning ");
                    this.mqDisconnect();
                    this.endPcf();
                    HashMap hashMap3 = null;
                    return hashMap3;
                }
                String string = "";
                this.printOut("checkQueues  Ignore queue list   : " + arrayList);
                for (int i = 0; i < this.lqueues.length; ++i) {
                    String string2;
                    int n;
                    this.printOut("Processing queue name  : " + this.lqueues[i].trim());
                    if (this.lqueues[i] == null) continue;
                    string = this.lqueues[i].trim().toLowerCase();
                    this.lqueues[i] = this.lqueues[i].trim();
                    if (bl && string.startsWith("system.")) continue;
                    if (arrayList != null && arrayList.size() > 0) {
                        boolean bl2 = false;
                        for (n = 0; n < arrayList.size(); ++n) {
                            string2 = (String)arrayList.get(n);
                            if (!EgUtilities.isMatch((String)string, (String)string2)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                    }
                    this.printOut("checkQueues  Processing to open the queue name  : " + this.lqueues[i].trim());
                    if (this.mqOpen(this.lqueues[i])) {
                        Object object;
                        try {
                            object = this.mqStats(this.lqueues[i]);
                            if (object != null) {
                                this.qstats.put(this.lqueues[i], object);
                            }
                        }
                        catch (Exception exception) {
                            this.printOutStackTrace("checkQueues  Processing to open the queue name  : " + this.lqueues[i].trim(), exception);
                            exception.printStackTrace();
                        }
                        this.mqClose(this.lqueues[i]);
                        try {
                            object = this.mqPeek(this.lqueues[i]);
                            if (object != null && ((ArrayList)object).size() > 0) {
                                hashMap.put(this.lqueues[i], object);
                            }
                            this.printOut("checkQueues  Processing to open the queue name  : " + this.lqueues[i].trim() + "  data  : " + object);
                        }
                        catch (Exception exception) {
                            this.printOutStackTrace("checkQueues  Processing to open the queue name  in mqPeek : " + this.lqueues[i].trim(), exception);
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    try {
                        n = 0;
                        n = 40;
                        this.queue = this.mqQueueManager.accessQueue(this.lqueues[i], n, null, null, null);
                        this.printOut("checkQueues  Processing to open the queue name  : " + this.lqueues[i].trim() + " Open queue sucessfull... ");
                    }
                    catch (MQException mQException) {
                        System.out.println("host:" + this.host + " , Port:" + this.port + " Error in opening queue ....");
                        System.out.println("host:" + this.host + " , Port:" + this.port + " Queue Name : " + this.lqueues[i]);
                        System.out.println("host:" + this.host + " , Port:" + this.port + " CC   : " + mQException.completionCode);
                        System.out.println("host:" + this.host + " , Port:" + this.port + " RC   : " + mQException.reasonCode);
                        arrayList2.add("" + mQException.completionCode);
                        arrayList2.add("" + mQException.reasonCode);
                        this.printOutStackTrace("checkQueues  Processing to open the queue name  in mqPeek : " + this.lqueues[i].trim(), (Exception)((Object)mQException));
                        string2 = null;
                        try {
                            StringWriter stringWriter = new StringWriter();
                            PrintWriter printWriter = new PrintWriter(stringWriter);
                            mQException.printStackTrace(printWriter);
                            string2 = stringWriter.toString();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            string2 = mQException.toString();
                        }
                        arrayList2.add(string2);
                        mQException.printStackTrace();
                    }
                    catch (Exception exception) {
                        this.printOutStackTrace("checkQueues  Processing to open the queue name  in mqPeek :!!!!  " + this.lqueues[i].trim(), exception);
                        exception.printStackTrace();
                    }
                    double[] dArray = new double[]{-5.0, 1.0, -5.0, -5.0, -5.0, -5.0, 0.0};
                    this.qstats.put(this.lqueues[i], dArray);
                    this.corruptedQueuestats.put(this.lqueues[i], arrayList2);
                    this.logToErrorFile("ERROR", "checkQueus", "host:" + this.host + " , Port:" + this.port + "Unable to open Queue or Queue corrupted " + this.lqueues[i]);
                    System.out.println("host:" + this.host + " , Port:" + this.port + " [ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[i]);
                    this.printOut("[ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[i]);
                }
                this.mqDisconnect();
                this.endPcf();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "checkQueus", "host:" + this.host + " , Port:" + this.port + " Exception happened before finally ");
                System.out.println("host:" + this.host + " , Port:" + this.port + " [ERROR] checkQueus : Exception happened before finally");
                this.printOutStackTrace("checkQueues  Processing to open the queue name  in mqPeek : [ERROR] checkQueus : Exception happened before finally ", exception);
                exception.printStackTrace();
            }
            finally {
                this.printOut("[ERROR] checkQueus Inside finally");
                this.mqDisconnect();
                this.endPcf();
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap checkQueues(boolean bl, ArrayList arrayList, boolean bl2) {
        HashMap<String, Object> hashMap;
        block25: {
            this.qstats = new Hashtable();
            this.corruptedQueuestats = new Hashtable();
            this.printOut("checkQueues  : ignoreSystemQueues  :" + bl + " ,includeList  : " + arrayList + "  ,include  " + bl2);
            hashMap = new HashMap<String, Object>();
            try {
                try {
                    this.checkQmgr(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.qmgr == null) {
                    HashMap hashMap2 = null;
                    return hashMap2;
                }
                if (!this.mqConnect()) break block25;
                this.lqueues = this.getQnames();
                this.printOut("checkQueues  : lqueues  : " + this.lqueues);
                if (this.lqueues == null) {
                    this.printOut("checkQueues  : lqueues  is null ");
                    this.mqDisconnect();
                    this.endPcf();
                    HashMap hashMap3 = null;
                    return hashMap3;
                }
                String string = "";
                this.printOut("checkQueues  : includeList  :" + arrayList);
                if (arrayList == null || arrayList.size() <= 0) break block25;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    for (int j = 0; j < this.lqueues.length; ++j) {
                        Object object;
                        this.printOut("checkQueues  : includeList  queue patterr :" + string2 + "   , lqueues[i] :" + this.lqueues[j]);
                        if (this.lqueues[j] == null) continue;
                        string = this.lqueues[j].trim().toLowerCase();
                        this.lqueues[j] = this.lqueues[j].trim();
                        if (bl && string.startsWith("system.") || !EgUtilities.isMatch((String)string, (String)string2)) continue;
                        if (this.mqOpen(this.lqueues[j])) {
                            this.printOut("checkQueues  : mqOpen  process " + this.lqueues[j]);
                            try {
                                object = this.mqStats(this.lqueues[j]);
                                this.printOut("checkQueues  : mqStats for   process " + this.lqueues[j]);
                                if (object != null) {
                                    this.qstats.put(this.lqueues[j], object);
                                }
                                this.printOut("checkQueues  : mqStats    qstats data  " + this.qstats);
                            }
                            catch (Exception exception) {
                                this.printOutStackTrace(" checkQueues  : mqStats    Exception  for the queue " + this.lqueues[j], exception);
                                exception.printStackTrace();
                            }
                            this.printOut(" checkQueues  :    mqClose  " + this.lqueues[j]);
                            this.mqClose(this.lqueues[j]);
                            try {
                                this.printOut(" checkQueues  :    mqPeek   " + this.lqueues[j]);
                                object = this.mqPeek(this.lqueues[j]);
                                if (object != null && ((ArrayList)object).size() > 0) {
                                    hashMap.put(this.lqueues[j], object);
                                }
                                this.printOut(" checkQueues  :    mqPeek   " + this.lqueues[j] + " data : " + object);
                            }
                            catch (Exception exception) {
                                this.printOutStackTrace(" checkQueues  : mqStats    Exception  for the queue " + this.lqueues[j], exception);
                                exception.printStackTrace();
                            }
                            continue;
                        }
                        object = new ArrayList();
                        try {
                            int n = 0;
                            n = 40;
                            this.queue = this.mqQueueManager.accessQueue(this.lqueues[j], n, null, null, null);
                            this.printOut(" checkQueues  :    Open queue sucessfull   " + this.lqueues[j] + "  ");
                        }
                        catch (MQException mQException) {
                            System.out.println("host:" + this.host + " , Port:" + this.port + " Error in opening queue ....");
                            System.out.println("host:" + this.host + " , Port:" + this.port + " Queue Name : " + this.lqueues[j]);
                            System.out.println("host:" + this.host + " , Port:" + this.port + " CC   : " + mQException.completionCode);
                            System.out.println("host:" + this.host + " , Port:" + this.port + " RC   : " + mQException.reasonCode);
                            ((ArrayList)object).add("" + mQException.completionCode);
                            ((ArrayList)object).add("" + mQException.reasonCode);
                            this.printOutStackTrace(" checkQueues  : mqStats    Exception  for the queue " + this.lqueues[j], (Exception)((Object)mQException));
                            String string3 = null;
                            try {
                                StringWriter stringWriter = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(stringWriter);
                                mQException.printStackTrace(printWriter);
                                string3 = stringWriter.toString();
                                printWriter.close();
                            }
                            catch (Exception exception) {
                                string3 = mQException.toString();
                            }
                            ((ArrayList)object).add(string3);
                            mQException.printStackTrace();
                        }
                        catch (Exception exception) {
                            this.printOutStackTrace(" checkQueues  : mqStats    Exception  for the queue " + this.lqueues[j], exception);
                            exception.printStackTrace();
                        }
                        double[] dArray = new double[]{-5.0, 1.0, -5.0, -5.0, -5.0, -5.0, 0.0};
                        this.qstats.put(this.lqueues[j], dArray);
                        this.corruptedQueuestats.put(this.lqueues[j], object);
                        this.logToErrorFile("ERROR", "checkQueus", "host:" + this.host + " , Port:" + this.port + " Unable to open Queue or Queue corrupted " + this.lqueues[j]);
                        System.out.println("host:" + this.host + " , Port:" + this.port + " [ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[j]);
                        this.printOut("[ERROR] checkQueus : Unable to open Queue or Queue corrupted " + this.lqueues[j]);
                    }
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "checkQueus", "host:" + this.host + " , Port:" + this.port + " Exception happened before finally ");
                System.out.println("host:" + this.host + " , Port:" + this.port + " [ERROR] checkQueus : Exception happened before finally");
                this.printOutStackTrace("[ERROR] checkQueus : Exception happened before finally ", exception);
                exception.printStackTrace();
                return hashMap;
            }
        }
        this.mqDisconnect();
        this.endPcf();
        return hashMap;
        finally {
            this.printOut(" checkQueus : Inside finally");
            this.mqDisconnect();
            this.endPcf();
        }
    }

    public ArrayList mqPeek(String string) {
        long l = System.currentTimeMillis();
        this.printOut("mqPeek call for the queue " + string);
        ArrayList arrayList = new ArrayList();
        if (this.qmgr == null) {
            return arrayList;
        }
        boolean bl = false;
        if (!this.isQMconnect) {
            bl = true;
            if (!this.mqConnect()) {
                return arrayList;
            }
        }
        if (this.mqOpenPeek(string)) {
            this.printOut("Going to call mqBrowse from mqPeek  for the queue " + string);
            try {
                arrayList = this.mqBrowse(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mqClose(string);
        }
        if (bl) {
            this.mqDisconnect();
        }
        long l2 = System.currentTimeMillis();
        this.printOut("mqPeek call for the queue " + string + " took to complete the process " + (l2 - l) + " . ms");
        return arrayList;
    }

    public ArrayList mqBrowse(String string) {
        this.printOut("mqBrowse for the queue " + string);
        double d = 0.0;
        try {
            d = this.queue.getCurrentDepth();
        }
        catch (MQException mQException) {
            this.logToErrorFile("INFO", "EgMq.browseQueue for queue " + string, "host:" + this.host + " , Port:" + this.port + " while collect getCurrentDepth with mqBrowse MQ exception: CC = " + mQException.completionCode + " RC = " + mQException.reasonCode + " " + mQException.toString());
            this.printOutStackTrace("INFO EgMq.browseQueue for queue " + string + " host:" + this.host + " , Port:" + this.port + " while collect getCurrentDepth with mqBrowse MQ exception: CC = " + mQException.completionCode + " RC = " + mQException.reasonCode + " ", (Exception)((Object)mQException));
            mQException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.messageHash.put(string, new Double(d));
        this.messageOverLimit = d >= (double)this.messageLimit;
        int n = 0;
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = 17;
        MQMessage mQMessage = new MQMessage();
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        do {
            try {
                mQMessage.clearMessage();
                mQMessage.correlationId = MQC.MQCI_NONE;
                mQMessage.messageId = MQC.MQMI_NONE;
                try {
                    this.queue.get(mQMessage, mQGetMessageOptions);
                }
                catch (MQException mQException) {
                    if (mQException.completionCode == 2 && mQException.reasonCode == 2033) {
                        this.printOut("EgMg.mqBrowse  : No messages  to read ,loop stopped ######### " + string);
                        bl = true;
                    } else {
                        this.printOutStackTrace(" EgMq.browseQueue : Error while get myMessage for queue " + string + " host:" + this.host + " , Port:" + this.port + " MQ exception: CC = " + mQException.completionCode + " RC = " + mQException.reasonCode + " ", (Exception)((Object)mQException));
                        bl = true;
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    bl = true;
                    this.printOut("EgMg.mqBrowse  : loop stopped $$$$$$ " + string + "  , ServiceConfigurationError " + serviceConfigurationError.getMessage());
                }
                try {
                    Object object;
                    int n2;
                    GregorianCalendar gregorianCalendar = mQMessage.putDateTime;
                    Date date = gregorianCalendar.getTime();
                    String string2 = "";
                    byte[] byArray = mQMessage.messageId;
                    String string3 = "";
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        if (byArray[n2] >= 0 && byArray[n2] <= 31 || byArray[n2] == 127) continue;
                        char c = (char)byArray[n2];
                        object = "" + c;
                        string3 = string3 + (String)object;
                    }
                    string2 = string3.endsWith("(") ? string3.substring(0, string3.indexOf("(")) : string3;
                    n2 = string2.indexOf("\n");
                    if (n2 >= 0) {
                        string2 = string2.substring(0, n2);
                    }
                    String string4 = new String(mQMessage.correlationId);
                    object = new ArrayList();
                    ((ArrayList)object).add(date);
                    ((ArrayList)object).add(string2.trim());
                    ((ArrayList)object).add(string4.trim());
                    ((ArrayList)object).add(mQMessage.putApplicationName.trim());
                    ((ArrayList)object).add(new Long(mQMessage.messageSequenceNumber));
                    ((ArrayList)object).add(mQMessage.userId.trim());
                    int n3 = -1;
                    try {
                        n3 = mQMessage.getMessageLength();
                    }
                    catch (Exception exception) {
                        this.printOutStackTrace("Error while calculate myMessage.getMessageLength  ", exception);
                    }
                    ((ArrayList)object).add(new Long(n3));
                    if (n3 > 0) {
                        arrayList.add(object);
                    }
                    ++n;
                    mQGetMessageOptions.options = 33;
                }
                catch (Exception exception) {
                    bl = true;
                    this.printOutStackTrace("mqBrowse for the queue " + string + " Error while get myMessage   ", exception);
                }
            }
            catch (IOException iOException) {
                this.printOutStackTrace("INFO EgMq.browseQueue IOException For queue " + string + " host:" + this.host + " , Port:" + this.port + "  ,", iOException);
                this.logToErrorFile("INFO", "EgMq.browseQueue For queue " + string, "host:" + this.host + " , Port:" + this.port + "  ," + iOException.toString());
                bl = true;
            }
            catch (Exception exception) {
                this.printOutStackTrace("INFO EgMq.browseQueue General exception For queue  " + string + " host:" + this.host + " , Port:" + this.port + "  ,", exception);
                bl = true;
            }
        } while ((!this.messageOverLimit || this.numDDMessages <= 0 || n < this.numDDMessages) && !bl);
        return arrayList;
    }

    public void end() {
        this.endPcf();
    }

    public void checkQmgr(boolean bl) {
        try {
            this.printOut("host:" + this.host + " , Port:" + this.port + "  pcf_init  value is :" + this.pcf_init);
            if (!this.pcf_init) {
                this.initPcf();
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("EgMq.checkQmgr.initPcf()  host:" + this.host + " , Port:" + this.port + "  Unable to Init PCF ", exception);
            this.logToErrorFile("ERROR", "EgMq.checkQmgr.initPcf()", "host:" + this.host + " , Port:" + this.port + "  Unable to Init PCF " + exception.toString());
            exception.printStackTrace();
        }
        this.qmgr_avail = 0.0;
        this.qmgr_resp = -1.0;
        this.qmgr = null;
        if (this.pcf_init) {
            this.discoverQmgr();
            if (this.qmgr == null) {
                this.qmgr_avail = 0.0;
                this.qmgr_resp = -1.0;
                return;
            }
            if (bl) {
                this.mqConnect();
                this.mqDisconnect();
            }
        } else {
            this.printOut("host:" + this.host + " , Port:" + this.port + " WARNING:  EgMq.checkQmgr.initPcf() ,Init PCF value is  " + this.pcf_init);
        }
    }

    public boolean discoverQmgr() {
        PCFMessage pCFMessage;
        int n = 2015;
        if (this.pcfmessageagent == null) {
            this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "host:" + this.host + " , Port:" + this.port + " PCF message agent is null ,So unable to discover Qmanagers  ");
            System.out.println("host:" + this.host + " , Port:" + this.port + " EgMq.discoverQmgr() : PCF message agent is null ,So unable to discover Qmanagers  ");
            this.endPcf();
            this.qmgr = null;
            return false;
        }
        try {
            pCFMessage = new PCFMessage(2);
            pCFMessage.addParameter(1001, new int[]{n});
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "host:" + this.host + " , Port:" + this.port + " Unable to discover Qmanagers  " + exception.toString());
            this.printOutStackTrace("host:" + this.host + " , Port:" + this.port + " Unable to discover Qmanagers ", exception);
            exception.printStackTrace();
            this.endPcf();
            this.qmgr = null;
            return false;
        }
        this.qmgr = null;
        try {
            PCFMessage[] pCFMessageArray = this.pcfmessageagent.send(pCFMessage);
            Enumeration enumeration = pCFMessageArray[0].getParameters();
            while (enumeration.hasMoreElements()) {
                PCFParameter pCFParameter = (PCFParameter)enumeration.nextElement();
                if (pCFParameter.getParameter() != n) continue;
                this.qmgr = (String)pCFParameter.getValue();
                this.qmgr = this.qmgr.trim();
            }
            return true;
        }
        catch (PCFException pCFException) {
            this.printOutStackTrace("Unable to discover Qmanagers  &(* ", (Exception)((Object)pCFException));
            PCFMessage[] pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (int i = 0; i < pCFMessageArray.length; ++i) {
                this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "host:" + this.host + " , Port:" + this.port + " Unable to discover Qmanagers  " + pCFMessageArray[i].toString());
                System.out.println(pCFMessageArray[i].toString());
            }
            pCFException.printStackTrace();
            this.endPcf();
            this.qmgr = null;
            return false;
        }
        catch (Exception exception) {
            this.printOutStackTrace("  Unable to discover Qmanagers   (&^ :", exception);
            this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "host:" + this.host + " , Port:" + this.port + " Unable to discover Qmanagers  " + exception.toString());
            exception.printStackTrace();
            this.endPcf();
            this.qmgr = null;
            return false;
        }
    }

    public void init() {
        try {
            this.htProps.put("hostname", this.host);
            this.htProps.put("channel", this.srvConn);
            this.htProps.put("port", new Integer(this.port));
            System.out.println("htProps " + this.htProps);
            if (this.user != null && !this.user.equalsIgnoreCase("none")) {
                this.htProps.put("userID", this.user);
            }
            if (this.pass != null && !this.pass.equalsIgnoreCase("none")) {
                this.htProps.put("password", this.pass);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "EgMq.discoverQmgr()", "host:" + this.host + " , Port:" + this.port + " Unable to set Qmanager property  " + exception.toString());
            this.printOutStackTrace("ERROR EgMq.discoverQmgr() host:" + this.host + " , Port:" + this.port + " Unable to set Qmanager property  ", exception);
            exception.printStackTrace();
        }
    }

    public void setAttributes(String string, int n, String string2) {
        this.host = string;
        this.port = n;
        this.srvConn = string2;
        this.init();
    }

    public void setAttributesReportName(String string, String string2) {
        this.entity = string;
        this.reportingName = string2;
    }

    public void setAttributes(String string, int n, String string2, String string3, String string4) {
        this.host = string;
        this.port = n;
        this.srvConn = string2;
        this.user = string3;
        this.pass = string4;
        this.init();
    }

    public boolean initPcf() {
        int n;
        PCFMessage[] pCFMessageArray;
        String string = "[initPcf] :";
        String string2 = null;
        this.end();
        try {
            this.qMgr = new MQQueueManager(null, this.htProps);
            this.printOut(string + "host:" + this.host + " , Port:" + this.port + " QManager object  :" + this.qMgr);
        }
        catch (PCFException pCFException) {
            pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (n = 0; n < pCFMessageArray.length; ++n) {
                this.printOut(string + "  " + pCFMessageArray[n].toString());
            }
            string2 = string + "host:" + this.host + " , Port:" + this.port + " Exception  while create MQQueuemanager object :";
            this.printOutStackTrace(string2, (Exception)((Object)pCFException));
            string2 = null;
        }
        catch (MQException mQException) {
            string2 = string + "host:" + this.host + " , Port:" + this.port + " Exception  while create MQQueuemanager object :";
            this.printOutStackTrace(string2, (Exception)((Object)mQException));
            string2 = null;
        }
        catch (Exception exception) {
            string2 = string + "host:" + this.host + " , Port:" + this.port + " General exception caused :";
            this.printOutStackTrace(string2, exception);
            string2 = null;
        }
        if (this.qMgr == null) {
            this.printOut(string + "host:" + this.host + " , Port:" + this.port + " Qmanager instance  is null, so returning with null data");
            this.endPcf();
            this.pcf_init = false;
            return false;
        }
        try {
            this.pcfmessageagent = new PCFMessageAgent(this.qMgr);
            this.printOut(string + "host:" + this.host + " , Port:" + this.port + " PCFMessageAgent object  :" + this.pcfmessageagent);
        }
        catch (PCFException pCFException) {
            string2 = "Exception ^%$  ";
            this.printOutStackTrace(string2, (Exception)((Object)pCFException));
            pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (n = 0; n < pCFMessageArray.length; ++n) {
                this.printOut(string + "  " + pCFMessageArray[n].toString());
            }
            string2 = string + "";
            this.printOut(string2 + (Object)((Object)pCFException));
            string2 = null;
        }
        catch (MQException mQException) {
            string2 = string + "host:" + this.host + " , Port:" + this.port + " Message Agent is null!  :";
            this.printOutStackTrace(string2, (Exception)((Object)mQException));
            string2 = null;
        }
        catch (Exception exception) {
            string2 = string + "host:" + this.host + " , Port:" + this.port + " General exception caused :";
            this.printOutStackTrace(string2, exception);
            string2 = null;
        }
        if (this.pcfmessageagent == null) {
            this.printOut(string + "host:" + this.host + " , Port:" + this.port + " pcfmessageagent is null, so returning with null data");
            this.endPcf();
            this.pcf_init = false;
            return false;
        }
        this.pcf_init = true;
        return true;
    }

    public void endPcf() {
        if (this.pcfmessageagent != null) {
            try {
                this.pcfmessageagent.disconnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pcfmessageagent = null;
        }
        if (this.qMgr != null) {
            try {
                this.qMgr.disconnect();
            }
            catch (Exception exception) {
                this.printOutStackTrace(" Unable to DisConnect Queue Manager  ", exception);
                this.logToErrorFile("ERROR", "EgMq.endPcf()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                System.out.println("ERROR   EgMq.endPcf() host:" + this.host + " , Port:" + this.port + "  Unable to DisConnect Queue Manager ");
                exception.printStackTrace();
            }
            this.qMgr = null;
        }
        this.pcf_init = false;
    }

    private boolean isValidDateTime(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.trim().length() < 8) {
            return false;
        }
        return string2.trim().length() >= 8;
    }

    private double calcTimeDiff(String string, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh.mm.ss");
        double d = -1.0;
        if (string.length() == 0 || string2.length() == 0) {
            return -1.0;
        }
        try {
            Date date = simpleDateFormat.parse(string + " " + string2);
            Date date2 = simpleDateFormat.parse(string3 + " " + string4);
            long l = date.getTime();
            long l2 = date2.getTime();
            d = (double)(l2 - l) / 1000.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double[] getInactiveChannelStatus() {
        double[] dArray = new double[9];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = -5.0;
        }
        dArray[8] = 0.0;
        return dArray;
    }

    public double[] getChannelStatus(String string) {
        Long l;
        Object object;
        Object object2;
        Object var2_2 = null;
        if (this.pcfmessageagent == null) {
            return null;
        }
        double d = -1.0;
        PCFMessage[] pCFMessageArray = null;
        int[] nArray = new int[]{3525, 3524};
        try {
            object2 = new PCFMessage(42);
            object2.addParameter(3501, string);
            object2.addParameter(1524, nArray);
            try {
                pCFMessageArray = this.pcfmessageagent.send(object2);
            }
            catch (PCFException pCFException) {
                this.printOutStackTrace("ERROR  : EgMq.getChannelStatus  host:" + this.host + " , Port:" + this.port + " Unable to add pcf paramter  ", (Exception)((Object)pCFException));
                this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "host:" + this.host + " , Port:" + this.port + " Unable to add pcf paramter  " + pCFException.toString());
                return null;
            }
            catch (MQException mQException) {
                this.printOutStackTrace("ERROR  EgMq.getChannelStatus  host:" + this.host + " , Port:" + this.port + " MQExeception   ", (Exception)((Object)mQException));
                this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "host:" + this.host + " , Port:" + this.port + " MQExeception   " + mQException.toString());
            }
            catch (IOException iOException) {
                this.printOutStackTrace("ERROR EgMq.getChannelStatus host:" + this.host + " , Port:" + this.port + " IOExeception   ", iOException);
                this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "host:" + this.host + " , Port:" + this.port + " IOExeception   " + iOException.toString());
                iOException.printStackTrace();
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("ERROR EgMq.getChannelStatus host:" + this.host + " , Port:" + this.port + " Unable to add pcf paramter  ", exception);
            this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "host:" + this.host + " , Port:" + this.port + " Unable to add pcf paramter  " + exception.toString());
            return null;
        }
        try {
            object2 = (String)pCFMessageArray[0].getParameterValue(nArray[0]);
            object = (String)pCFMessageArray[0].getParameterValue(nArray[1]);
            String string2 = (String)this.lastChannelTime.get(string);
            if (this.isValidDateTime((String)object2, (String)object)) {
                String string3 = (String)object2 + " " + (String)object;
                if (string2 != null && !string3.equals(string2)) {
                    this.lastChannelSend.put(string, new Long(System.currentTimeMillis()));
                    this.lastChannelTime.put(string, string3);
                    d = 0.0;
                } else {
                    l = (Long)this.lastChannelSend.get(string);
                    if (l == null) {
                        this.lastChannelSend.put(string, new Long(System.currentTimeMillis()));
                        d = -1.0;
                    } else {
                        d = System.currentTimeMillis() - l;
                        d = d < 0.0 ? -1.0 : d / 1000.0;
                    }
                    this.lastChannelTime.put(string, string3);
                }
            } else {
                d = -1.0;
                this.lastChannelTime.remove(string);
                this.lastChannelSend.remove(string);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("ERROR EgMq.getChannelStatus host:" + this.host + " , Port:" + this.port + " Unable to collect channel last message time  ", exception);
            this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "host:" + this.host + " , Port:" + this.port + " Unable to collect channel last message time  " + exception.toString());
            return null;
        }
        try {
            PCFMessage[] pCFMessageArray2;
            object2 = new PCFMessage(42);
            object2.addParameter(3501, string);
            try {
                pCFMessageArray2 = this.pcfmessageagent.send(object2);
            }
            catch (Exception exception) {
                this.printOutStackTrace("ERROR EgMq.getChannelStatus host:" + this.host + " , Port:" + this.port + " Unable to collect channel status  ", exception);
                this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "host:" + this.host + " , Port:" + this.port + " Unable to collect channel status  " + exception.toString());
                return null;
            }
            object = new double[9];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = 0.0;
            }
            object[7] = d;
            Enumeration enumeration = pCFMessageArray2[0].getParameters();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                l = (PCFParameter)enumeration.nextElement();
                int n = -1;
                double d2 = -1.0;
                try {
                    n = l.getParameter();
                    if (n != 1539 && n != 1538 && n != 1536 && n != 1535 && n != 1527 && n != 1531 && n != 1534) continue;
                    Integer n2 = (Integer)l.getValue();
                    d2 = n2.intValue();
                }
                catch (Exception exception) {
                    continue;
                }
                if (n == 1539) {
                    bl = true;
                    object[0] = d2;
                    continue;
                }
                if (n == 1538) {
                    bl = true;
                    object[1] = d2;
                    continue;
                }
                if (n == 1536) {
                    object[2] = d2;
                    bl = true;
                    continue;
                }
                if (n == 1535) {
                    object[3] = d2;
                    bl = true;
                    continue;
                }
                if (n == 1527) {
                    bl = true;
                    object[4] = d2;
                    object[8] = d2;
                    continue;
                }
                if (n == 1531) {
                    bl = true;
                    object[5] = d2;
                    continue;
                }
                if (n != 1534) continue;
                object[6] = d2;
                bl = true;
            }
            if (bl) {
                return object;
            }
            return null;
        }
        catch (Exception exception) {
            this.printOutStackTrace("ERROR EgMq.getChannelStatus host:" + this.host + " , Port:" + this.port + " Unable to channel details  ", exception);
            this.logToErrorFile("ERROR", "EgMq.getChannelStatus", "host:" + this.host + " , Port:" + this.port + " Unable to channel details  " + exception.toString());
            return null;
        }
    }

    public String[] getChannelnames() {
        this.channels = null;
        try {
            PCFMessage pCFMessage = new PCFMessage(20);
            pCFMessage.addParameter(3501, "*");
            pCFMessage.addParameter(1511, 5);
            PCFMessage[] pCFMessageArray = this.pcfmessageagent.send(pCFMessage);
            this.channels = (String[])pCFMessageArray[0].getParameterValue(3512);
            return this.channels;
        }
        catch (PCFException pCFException) {
            this.printOutStackTrace("ERROR EgMq.getChannelnames host:" + this.host + " , Port:" + this.port + " Unable to get channel names  ", (Exception)((Object)pCFException));
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "host:" + this.host + " , Port:" + this.port + " Unable to get channel names  " + pCFException.toString());
            PCFMessage[] pCFMessageArray = (PCFMessage[])pCFException.exceptionSource;
            for (int i = 0; i < pCFMessageArray.length; ++i) {
                System.out.println(pCFMessageArray[i].toString());
            }
        }
        catch (MQException mQException) {
            this.printOutStackTrace("ERROR EgMq.getChannelnames host:" + this.host + " , Port:" + this.port + " Unable to get channel names  ", (Exception)((Object)mQException));
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "host:" + this.host + " , Port:" + this.port + " Unable to get channel names  " + mQException.toString());
            mQException.printStackTrace();
        }
        catch (IOException iOException) {
            this.printOutStackTrace("ERROR EgMq.getChannelnames host:" + this.host + " , Port:" + this.port + " Unable to get channel names  ", iOException);
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "host:" + this.host + " , Port:" + this.port + " Unable to get channel names  " + iOException.toString());
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            this.printOutStackTrace("ERROR EgMq.getChannelnames host:" + this.host + " , Port:" + this.port + " Unable to get channel names  ", exception);
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "host:" + this.host + " , Port:" + this.port + " Unable to get channel names  " + exception.toString());
            exception.printStackTrace();
        }
        return this.channels;
    }

    public String[] getQnames() {
        this.printOut("getQnames  : collecting queue names ");
        try {
            PCFMessage pCFMessage = new PCFMessage(18);
            pCFMessage.addParameter(2016, "*");
            pCFMessage.addParameter(20, 1);
            PCFMessage[] pCFMessageArray = this.pcfmessageagent.send(pCFMessage);
            String[] stringArray = (String[])pCFMessageArray[0].getParameterValue(3011);
            return stringArray;
        }
        catch (PCFException pCFException) {
            this.printOutStackTrace("EgMq.getQnames host: Unable to get Queue  names  ", (Exception)((Object)pCFException));
            this.logToErrorFile("ERROR", "EgMq.getQnames", "host:" + this.host + " , Port:" + this.port + " Unable to get Queue  names  " + pCFException.toString());
            System.out.println("PCF error: " + (Object)((Object)pCFException));
            pCFException.printStackTrace();
        }
        catch (MQException mQException) {
            this.printOutStackTrace("EgMq.getQnames host: Unable to get Queue  names  ", (Exception)((Object)mQException));
            this.logToErrorFile("ERROR", "EgMq.getQnames", "host:" + this.host + " , Port:" + this.port + " Unable to get Queue names  " + mQException.toString());
            System.out.println((Object)mQException);
        }
        catch (IOException iOException) {
            this.printOutStackTrace("EgMq.getQnames host: Unable to get Queue  names  ", iOException);
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "host:" + this.host + " , Port:" + this.port + " Unable to get Queue names  " + iOException.toString());
            System.out.println(iOException);
        }
        catch (Exception exception) {
            this.printOutStackTrace("EgMq.getQnames host: Unable to get Queue  names  ", exception);
            this.logToErrorFile("ERROR", "EgMq.getChannelnames", "host:" + this.host + " , Port:" + this.port + " Unable to get Queue names  " + exception.toString());
            exception.printStackTrace();
        }
        return null;
    }

    private double[] mqStats(String string) {
        this.printOut("mqStats  inside for queue " + string);
        double[] dArray = null;
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        int n = -1;
        int n2 = -1;
        long l4 = -1L;
        if (this.queue != null) {
            try {
                l = this.queue.getCurrentDepth();
                l4 = this.queue.getMaximumDepth();
                l2 = this.queue.getOpenInputCount();
                l3 = this.queue.getOpenOutputCount();
                n = this.queue.getInhibitGet();
                n2 = this.queue.getInhibitPut();
                this.printOut(" mqStats  Qname :" + string + "  ,Get message state :" + n + "  ,Put message state :" + n2);
                System.out.println("host:" + this.host + " , Port:" + this.port + "  Qname :" + string + "  ,Get message state :" + n + "  ,Put message state :" + n2);
                dArray = new double[]{l, l4, l2, l3, n, n2, 100.0};
                return dArray;
            }
            catch (Exception exception) {
                this.printOutStackTrace("mqStats  inside for queue " + string, exception);
                dArray = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
                return dArray;
            }
        }
        return null;
    }

    private boolean mqOpenPeek(String string) {
        try {
            int n = 0;
            n = 42;
            this.queue = this.mqQueueManager.accessQueue(string, n, null, null, null);
            return true;
        }
        catch (MQException mQException) {
            this.printOutStackTrace(" Error in opening queue   :" + string + " ,so return with false ", (Exception)((Object)mQException));
            System.out.println("host:" + this.host + " , Port:" + this.port + " Error in opening queue ....");
            System.out.println("host:" + this.host + " , Port:" + this.port + " Queue Name : " + string);
            System.out.println("host:" + this.host + " , Port:" + this.port + " CC   : " + mQException.completionCode);
            System.out.println("host:" + this.host + " , Port:" + this.port + " RC   : " + mQException.reasonCode);
            mQException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            this.printOutStackTrace(" Common Error in opening queue   ", exception);
            exception.printStackTrace();
            return false;
        }
    }

    private boolean mqOpen(String string) {
        this.printOut("  mqOpen  inside for the qname  " + string);
        try {
            int n = 0;
            n = 40;
            this.queue = this.mqQueueManager.accessQueue(string, n, null, null, null);
            return true;
        }
        catch (MQException mQException) {
            this.printOutStackTrace("accessQueue error    ", (Exception)((Object)mQException));
            System.out.println("host:" + this.host + " , Port:" + this.port + " Error in opening queue ....");
            System.out.println("host:" + this.host + " , Port:" + this.port + " Queue Name : " + string);
            System.out.println("host:" + this.host + " , Port:" + this.port + " CC   : " + mQException.completionCode);
            System.out.println("host:" + this.host + " , Port:" + this.port + " RC   : " + mQException.reasonCode);
            mQException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            this.printOutStackTrace(" accessQueue Error   ", exception);
            exception.printStackTrace();
            return false;
        }
    }

    private void mqClose(String string) {
        try {
            if (this.queue != null) {
                this.queue.close();
            }
        }
        catch (MQException mQException) {
            this.printOutStackTrace("Error in closing queue  ", (Exception)((Object)mQException));
            System.out.println("host:" + this.host + " , Port:" + this.port + " Error in closing queue ....");
            System.out.println("host:" + this.host + " , Port:" + this.port + " Queue Name : " + string);
            System.out.println("host:" + this.host + " , Port:" + this.port + " CC   : " + mQException.completionCode);
            System.out.println("host:" + this.host + " , Port:" + this.port + " RC   : " + mQException.reasonCode);
            mQException.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setChannelAttributes(boolean bl, boolean bl2, ArrayList arrayList, ArrayList arrayList2) {
        this.ignoreSystemChannels = bl2;
        this.includeChannelsList = arrayList;
        this.excludeChannelsList = arrayList2;
        this.showInactiveChannels = bl;
        if (arrayList != null && !arrayList.isEmpty() && arrayList.size() > 0) {
            this.includeChannelsFlag = true;
        }
        if (arrayList2 != null && !arrayList2.isEmpty() && arrayList2.size() > 0) {
            this.excludeChannelsFlag = true;
        }
    }

    private boolean includeChannelToList(String string) {
        boolean bl = false;
        if (this.includeChannelsFlag) {
            for (int i = 0; i < this.includeChannelsList.size(); ++i) {
                for (int j = 0; j < this.includeChannelsList.size(); ++j) {
                    String string2 = (String)this.includeChannelsList.get(j);
                    String string3 = string.trim().toLowerCase();
                    if (!EgUtilities.isMatch((String)string3, (String)string2)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean excludeChannelToList(String string) {
        boolean bl = false;
        if (this.excludeChannelsFlag) {
            for (int i = 0; i < this.excludeChannelsList.size(); ++i) {
                for (int j = 0; j < this.excludeChannelsList.size(); ++j) {
                    String string2 = (String)this.excludeChannelsList.get(j);
                    String string3 = string.trim().toLowerCase();
                    if (!EgUtilities.isMatch((String)string3, (String)string2)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean ignoreSystemChannelToList(String string) {
        boolean bl = false;
        String string2 = string.trim().toLowerCase();
        if (this.ignoreSystemChannels && string2.startsWith("system.")) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getChannelStatusV6() {
        var1_1 = false;
        this.channelstats = new Hashtable<K, V>();
        var2_2 = null;
        var5_3 = "";
        var6_4 = "";
        var7_5 = "";
        var8_6 = "";
        var16_7 = -1.0;
        var18_8 = null;
        try {
            block130: {
                block129: {
                    var3_9 = new PCFMessage(42);
                    var3_9.addParameter(3501, "*");
                    var3_9.addParameter(1523, 1011);
                    var19_10 = new int[]{3501, 3506, 1534, 3525, 3524, 1527, 1539, 1538, 1536, 1535, 1531};
                    var3_9.addParameter(1524, var19_10);
                    var20_12 = "[getChannelStatusV6] :";
                    var21_13 = null;
                    try {
                        var18_8 = new MQQueueManager(null, this.htProps);
                        this.printOut(var20_12 + "host:" + this.host + " , Port:" + this.port + "  QManager object  :" + var18_8);
                    }
                    catch (PCFException var22_14) {
                        var23_25 = (PCFMessage[])var22_14.exceptionSource;
                        for (var24_33 = 0; var24_33 < var23_25.length; ++var24_33) {
                            this.printOut(var20_12 + "  " + var23_25[var24_33].toString());
                        }
                        var21_13 = var20_12 + "host:" + this.host + " , Port:" + this.port + " Exception  while create MQQueuemanager object :";
                        this.printOutStackTrace(var21_13, (Exception)var22_14);
                        var21_13 = null;
                        var31_49 = null;
                        this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                        System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                        if (var2_2 != null) {
                            try {
                                var2_2.disconnect();
                                var2_2 = null;
                            }
                            catch (Exception var32_60) {
                                var32_60.printStackTrace();
                            }
                        }
                        if (var18_8 == null) return;
                        try {
                            var18_8.disconnect();
                            return;
                        }
                        catch (Exception var32_60) {
                            this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_60);
                            this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                            System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                            var32_60.printStackTrace();
                        }
                        return;
                    }
                    catch (MQException var22_15) {
                        block117: {
                            var21_13 = var20_12 + "host:" + this.host + " , Port:" + this.port + " Exception  while create MQQueuemanager object :";
                            this.printOutStackTrace(var21_13, (Exception)var22_15);
                            var21_13 = null;
                            var31_50 = null;
                            this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                            System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                            if (var2_2 != null) {
                                ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl63:
                                // 1 sources

                                var2_2.disconnect();
                                var2_2 = null;
                                break block117;
lbl66:
                                // 1 sources

                                catch (Exception var32_61) {
                                    var32_61.printStackTrace();
                                }
                            }
                        }
                        if (var18_8 == null) return;
                        ** try [egrp 22[TRYBLOCK] [49 : 3228->3239)] { 
lbl71:
                        // 1 sources

                        var18_8.disconnect();
                        return;
lbl73:
                        // 1 sources

                        catch (Exception var32_61) {
                            this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_61);
                            this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                            System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                            var32_61.printStackTrace();
                        }
                        return;
                    }
                    catch (Exception var22_16) {
                        block118: {
                            var21_13 = var20_12 + "host:" + this.host + " , Port:" + this.port + " General exception caused :";
                            this.printOutStackTrace(var21_13, var22_16);
                            var21_13 = null;
                            var31_51 = null;
                            this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                            System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                            if (var2_2 != null) {
                                ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl89:
                                // 1 sources

                                var2_2.disconnect();
                                var2_2 = null;
                                break block118;
lbl92:
                                // 1 sources

                                catch (Exception var32_62) {
                                    var32_62.printStackTrace();
                                }
                            }
                        }
                        if (var18_8 == null) return;
                        ** try [egrp 22[TRYBLOCK] [49 : 3228->3239)] { 
lbl97:
                        // 1 sources

                        var18_8.disconnect();
                        return;
lbl99:
                        // 1 sources

                        catch (Exception var32_62) {
                            this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_62);
                            this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                            System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                            var32_62.printStackTrace();
                        }
                        return;
                    }
                    if (var18_8 != null) break block129;
                    this.printOut(var20_12 + "host:" + this.host + " , Port:" + this.port + " Qmanager instance  is null, so returning with null data");
                    if (var18_8 != null) {
                        try {
                            var18_8.disconnect();
                            var18_8 = null;
                        }
                        catch (Exception var22_17) {
                            this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var22_17);
                            this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                            System.out.println("ERROR   EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + "  Unable to DisConnect Queue Manager ");
                            var22_17.printStackTrace();
                        }
                    }
                    var31_52 = null;
                    this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                    System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                    if (var2_2 == null) ** GOTO lbl512
                    ** GOTO lbl506
                }
                try {
                    var2_2 = new PCFMessageAgent(var18_8);
                }
                catch (PCFException var22_18) {
                    block119: {
                        var23_26 = (PCFMessage[])var22_18.exceptionSource;
                        for (var24_34 = 0; var24_34 < var23_26.length; ++var24_34) {
                            this.printOut(var20_12 + "  " + var23_26[var24_34].toString());
                        }
                        var21_13 = var20_12 + "";
                        this.printOutStackTrace(var21_13, (Exception)var22_18);
                        var21_13 = null;
                        var31_53 = null;
                        this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                        System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                        if (var2_2 != null) {
                            ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl141:
                            // 1 sources

                            var2_2.disconnect();
                            var2_2 = null;
                            break block119;
lbl144:
                            // 1 sources

                            catch (Exception var32_64) {
                                var32_64.printStackTrace();
                            }
                        }
                    }
                    if (var18_8 == null) return;
                    ** try [egrp 22[TRYBLOCK] [49 : 3228->3239)] { 
lbl149:
                    // 1 sources

                    var18_8.disconnect();
                    return;
lbl151:
                    // 1 sources

                    catch (Exception var32_64) {
                        this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_64);
                        this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                        System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                        var32_64.printStackTrace();
                    }
                    return;
                }
                catch (MQException var22_19) {
                    block120: {
                        var21_13 = var20_12 + "host:" + this.host + " , Port:" + this.port + " Message Agent is null!  :";
                        this.printOutStackTrace(var21_13, (Exception)var22_19);
                        var21_13 = null;
                        var31_54 = null;
                        this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                        System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                        if (var2_2 != null) {
                            ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl167:
                            // 1 sources

                            var2_2.disconnect();
                            var2_2 = null;
                            break block120;
lbl170:
                            // 1 sources

                            catch (Exception var32_65) {
                                var32_65.printStackTrace();
                            }
                        }
                    }
                    if (var18_8 == null) return;
                    ** try [egrp 22[TRYBLOCK] [49 : 3228->3239)] { 
lbl175:
                    // 1 sources

                    var18_8.disconnect();
                    return;
lbl177:
                    // 1 sources

                    catch (Exception var32_65) {
                        this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_65);
                        this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                        System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                        var32_65.printStackTrace();
                    }
                    return;
                }
                catch (Exception var22_20) {
                    block121: {
                        var21_13 = var20_12 + "host:" + this.host + " , Port:" + this.port + " General exception caused :";
                        this.printOutStackTrace(var21_13, var22_20);
                        var21_13 = null;
                        var31_55 = null;
                        this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                        System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                        if (var2_2 != null) {
                            ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl193:
                            // 1 sources

                            var2_2.disconnect();
                            var2_2 = null;
                            break block121;
lbl196:
                            // 1 sources

                            catch (Exception var32_66) {
                                var32_66.printStackTrace();
                            }
                        }
                    }
                    if (var18_8 == null) return;
                    ** try [egrp 22[TRYBLOCK] [49 : 3228->3239)] { 
lbl201:
                    // 1 sources

                    var18_8.disconnect();
                    return;
lbl203:
                    // 1 sources

                    catch (Exception var32_66) {
                        this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_66);
                        this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                        System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                        var32_66.printStackTrace();
                    }
                    return;
                }
                if (var2_2 != null) break block130;
                this.printOut(var20_12 + "host:" + this.host + " , Port:" + this.port + " pcfmessageagent is null, so returning with null data");
                if (var18_8 != null) {
                    try {
                        var18_8.disconnect();
                        var18_8 = null;
                    }
                    catch (Exception var22_21) {
                        this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var22_21);
                        this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                        System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                        var22_21.printStackTrace();
                    }
                }
                ** GOTO lbl523
            }
            try {
                var4_71 = var2_2.send(var3_9);
                for (var22_22 = 0; var22_22 < var4_71.length; ++var22_22) {
                    try {
                        var7_5 = var4_71[var22_22].getStringParameterValue(3501);
                        var7_5 = var7_5.trim();
                    }
                    catch (Exception var23_28) {
                        System.out.println("host:" + this.host + " , Port:" + this.port + " channel name is null");
                        continue;
                    }
                    if (var7_5 == null || var7_5.trim().length() == 0 || this.channelstats.containsKey(var7_5)) continue;
                    var23_27 /* !! */  = (PCFMessage)new double[9];
                    for (var24_35 = 0; var24_35 < ((PCFMessage)var23_27 /* !! */ ).length; ++var24_35) {
                        var23_27 /* !! */ [var24_35] = (PCFMessage)0.0;
                    }
                    try {
                        var8_6 = var4_71[var22_22].getStringParameterValue(3506);
                    }
                    catch (Exception var24_36) {
                        // empty catch block
                    }
                    try {
                        var5_3 = var4_71[var22_22].getStringParameterValue(3525);
                        var6_4 = var4_71[var22_22].getStringParameterValue(3524);
                    }
                    catch (Exception var24_37) {
                        var24_37.printStackTrace();
                    }
                    try {
                        var9_72 = var4_71[var22_22].getIntParameterValue(1539);
                    }
                    catch (Exception var24_38) {
                        var9_72 = -5;
                    }
                    var23_27 /* !! */ [0] = (PCFMessage)((double)var9_72);
                    try {
                        var10_73 = var4_71[var22_22].getIntParameterValue(1538);
                    }
                    catch (Exception var24_39) {
                        var10_73 = -5;
                    }
                    var23_27 /* !! */ [1] = (PCFMessage)((double)var10_73);
                    try {
                        var11_74 = var4_71[var22_22].getIntParameterValue(1536);
                    }
                    catch (Exception var24_40) {
                        var11_74 = -5;
                    }
                    var23_27 /* !! */ [2] = (PCFMessage)((double)var11_74);
                    try {
                        var12_75 = var4_71[var22_22].getIntParameterValue(1535);
                    }
                    catch (Exception var24_41) {
                        var12_75 = -5;
                    }
                    var23_27 /* !! */ [3] = (PCFMessage)((double)var12_75);
                    try {
                        var13_76 = var4_71[var22_22].getIntParameterValue(1527);
                    }
                    catch (Exception var24_42) {
                        var13_76 = -5;
                    }
                    var23_27 /* !! */ [4] = (PCFMessage)((double)var13_76);
                    var23_27 /* !! */ [8] = (PCFMessage)((double)var13_76);
                    try {
                        var14_77 = var4_71[var22_22].getIntParameterValue(1531);
                    }
                    catch (Exception var24_43) {
                        var14_77 = -5;
                    }
                    var23_27 /* !! */ [5] = (PCFMessage)((double)var14_77);
                    try {
                        var15_78 = var4_71[var22_22].getIntParameterValue(1534);
                    }
                    catch (Exception var24_44) {
                        var15_78 = -5;
                    }
                    var23_27 /* !! */ [6] = (PCFMessage)((double)var15_78);
                    if (this.isValidDateTime(var5_3, var6_4)) {
                        var24_45 = var5_3 + " " + var6_4;
                        var25_79 = (String)this.lastChannelTime.get(var7_5);
                        if (var25_79 != null && !var24_45.equals(var25_79)) {
                            this.lastChannelSend.put(var7_5, new Long(System.currentTimeMillis()));
                            this.lastChannelTime.put(var7_5, var24_45);
                            var16_7 = 0.0;
                        } else {
                            var26_83 = (Long)this.lastChannelSend.get(var7_5);
                            if (var26_83 == null) {
                                this.lastChannelSend.put(var7_5, new Long(System.currentTimeMillis()));
                                var16_7 = -1.0;
                            } else {
                                var16_7 = System.currentTimeMillis() - var26_83;
                                var16_7 = var16_7 < 0.0 ? -1.0 : var16_7 / 1000.0;
                            }
                            this.lastChannelTime.put(var7_5, var24_45);
                        }
                    } else {
                        var16_7 = -1.0;
                        this.lastChannelTime.remove(var7_5);
                        this.lastChannelSend.remove(var7_5);
                    }
                    var23_27 /* !! */ [7] = (PCFMessage)var16_7;
                    this.channelstats.put(var7_5, var23_27 /* !! */ );
                }
                var22_23 = null;
                try {
                    var23_27 /* !! */  = new PCFMessage(20);
                    var23_27 /* !! */ .addParameter(3501, "*");
                    var23_27 /* !! */ .addParameter(1511, 5);
                    var24_46 = var2_2.send(var23_27 /* !! */ );
                    var22_23 = (String[])var24_46[0].getParameterValue(3512);
                }
                catch (PCFException var23_29) {
                    this.printOutStackTrace("ERROR v6ChannelNames host:" + this.host + " , Port:" + this.port + " Unable to get channel names  ", (Exception)var23_29);
                    this.logToErrorFile("ERROR", "v6ChannelNames", "host:" + this.host + " , Port:" + this.port + " Unable to get channel names  " + var23_29.toString());
                    var24_47 = (PCFMessage[])var23_29.exceptionSource;
                    for (var25_80 = 0; var25_80 < var24_47.length; ++var25_80) {
                        System.out.println(var24_47[var25_80].toString());
                    }
                }
                catch (MQException var23_30) {
                    this.printOutStackTrace("ERROR v6ChannelNames host:" + this.host + " , Port:" + this.port + " Unable to get channel names  ", (Exception)var23_30);
                    this.logToErrorFile("ERROR", "v6ChannelNames", "host:" + this.host + " , Port:" + this.port + " Unable to get channel names  " + var23_30.toString());
                    var23_30.printStackTrace();
                }
                catch (IOException var23_31) {
                    this.printOutStackTrace("ERROR v6ChannelNames host:" + this.host + " , Port:" + this.port + " Unable to get channel names  ", var23_31);
                    this.logToErrorFile("ERROR", "v6ChannelNames", "host:" + this.host + " , Port:" + this.port + " Unable to get channel names  " + var23_31.toString());
                    var23_31.printStackTrace();
                }
                catch (Exception var23_32) {
                    this.printOutStackTrace("ERROR v6ChannelNames host:" + this.host + " , Port:" + this.port + " Unable to get channel names  ", var23_32);
                    this.logToErrorFile("ERROR", "v6ChannelNames", "host:" + this.host + " , Port:" + this.port + " Unable to get channel names  " + var23_32.toString());
                    var23_32.printStackTrace();
                }
                if (var22_23 != null && var22_23.length > 0) {
                    var23_27 /* !! */  = (PCFMessage)new double[9];
                    for (var24_48 = 0; var24_48 < ((PCFMessage)var23_27 /* !! */ ).length; ++var24_48) {
                        var23_27 /* !! */ [var24_48] = (PCFMessage)-5.0;
                    }
                    var23_27 /* !! */ [4] = (PCFMessage)0.0;
                    var23_27 /* !! */ [8] = (PCFMessage)0.0;
                    for (var24_48 = 0; var24_48 < var22_23.length; ++var24_48) {
                        var25_81 = var22_23[var24_48].trim();
                        var26_84 = false;
                        if (!this.channelstats.containsKey(var25_81)) {
                            System.out.println("host:" + this.host + " , Port:" + this.port + " v6ChannelName  :" + var25_81);
                            this.printOut("host:" + this.host + " , Port:" + this.port + " v6ChannelName  :" + var25_81);
                            if (this.includeChannelToList(var25_81)) {
                                var26_84 = true;
                            } else if (!this.excludeChannelToList(var25_81) && this.showInactiveChannels && !this.ignoreSystemChannelToList(var25_81)) {
                                var26_84 = true;
                            }
                        }
                        if (!var26_84) continue;
                        this.channelstats.put(var25_81, var23_27 /* !! */ );
                    }
                    for (var24_48 = 0; var24_48 < var22_23.length; ++var24_48) {
                        var25_82 = var22_23[var24_48].trim();
                        if (!this.excludeChannelToList(var25_82) || this.includeChannelToList(var25_82)) continue;
                        this.channelstats.remove(var25_82);
                    }
                }
                var28_85 = null;
                if (var2_2 == null) ** GOTO lbl444
                ** GOTO lbl438
            }
            catch (PCFException var22_24) {
                this.printOutStackTrace("PCF Exception ^^&&& handled in ChannelStatus ", (Exception)var22_24);
                switch (var22_24.reasonCode) {
                    case 3065: {
                        var22_24.printStackTrace();
                        break;
                    }
                    default: {
                        System.out.println("host:" + this.host + " , Port:" + this.port + " PCF Exception NOT!! handled in ChannelStatus");
                        var22_24.printStackTrace();
                    }
                }
                var28_86 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.disconnect();
                        var2_2 = null;
                    }
                    catch (Exception var29_89) {
                        var29_89.printStackTrace();
                    }
                }
                if (var18_8 != null) {
                    try {
                        var18_8.disconnect();
                        var18_8 = null;
                    }
                    catch (Exception var29_89) {
                        this.printOutStackTrace("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager", var29_89);
                        this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                        System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                        var29_89.printStackTrace();
                    }
                }
                ** GOTO lbl544
            }
            {
                block131: {
                    catch (Throwable var27_91) {
                        block124: {
                            var28_87 = null;
                            if (var2_2 != null) {
                                ** try [egrp 19[TRYBLOCK] [26 : 2839->2848)] { 
lbl421:
                                // 1 sources

                                var2_2.disconnect();
                                var2_2 = null;
                                break block124;
lbl424:
                                // 1 sources

                                catch (Exception var29_90) {
                                    var29_90.printStackTrace();
                                }
                            }
                        }
                        if (var18_8 == null) throw var27_91;
                        ** try [egrp 20[TRYBLOCK] [27 : 2860->2871)] { 
lbl429:
                        // 1 sources

                        var18_8.disconnect();
                        var18_8 = null;
                        throw var27_91;
lbl432:
                        // 1 sources

                        catch (Exception var29_90) {
                            this.printOutStackTrace("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager", var29_90);
                            this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                            System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                            var29_90.printStackTrace();
                        }
                        throw var27_91;
                    }
lbl438:
                    // 1 sources

                    ** try [egrp 19[TRYBLOCK] [26 : 2839->2848)] { 
lbl439:
                    // 1 sources

                    var2_2.disconnect();
                    var2_2 = null;
                    break block131;
lbl442:
                    // 1 sources

                    catch (Exception var29_88) {
                        var29_88.printStackTrace();
                    }
                }
                if (var18_8 != null) {
                    try {}
                    catch (Exception var29_88) {}
                    this.printOutStackTrace("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager", var29_88);
                    this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                    System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                    var29_88.printStackTrace();
                }
                ** GOTO lbl544
                {
                    var18_8.disconnect();
                    var18_8 = null;
                }
            }
        }
        catch (Exception var19_11) {
            block125: {
                this.printOutStackTrace("EgMq.getChannelStatusV6()  Error before finally block ", var19_11);
                System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()  Error before finally block " + var19_11.getMessage());
                var19_11.printStackTrace();
                var31_58 = null;
                this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                if (var2_2 != null) {
                    ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl466:
                    // 1 sources

                    var2_2.disconnect();
                    var2_2 = null;
                    break block125;
lbl469:
                    // 1 sources

                    catch (Exception var32_69) {
                        var32_69.printStackTrace();
                    }
                }
            }
            if (var18_8 == null) return;
            try {}
            catch (Exception var32_69) {
                this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_69);
                this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                var32_69.printStackTrace();
                return;
            }
            var18_8.disconnect();
            return;
        }
        {
            block128: {
                block127: {
                    block132: {
                        catch (Throwable var30_92) {
                            block126: {
                                var31_59 = null;
                                this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                                System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                                if (var2_2 != null) {
                                    ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl489:
                                    // 1 sources

                                    var2_2.disconnect();
                                    var2_2 = null;
                                    break block126;
lbl492:
                                    // 1 sources

                                    catch (Exception var32_70) {
                                        var32_70.printStackTrace();
                                    }
                                }
                            }
                            if (var18_8 == null) throw var30_92;
                            ** try [egrp 22[TRYBLOCK] [49 : 3228->3239)] { 
lbl497:
                            // 1 sources

                            var18_8.disconnect();
                            var18_8 = null;
                            throw var30_92;
lbl500:
                            // 1 sources

                            catch (Exception var32_70) {
                                this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_70);
                                this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                                System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                                var32_70.printStackTrace();
                            }
                            throw var30_92;
                        }
lbl506:
                        // 1 sources

                        ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl507:
                        // 1 sources

                        var2_2.disconnect();
                        var2_2 = null;
                        break block132;
lbl510:
                        // 1 sources

                        catch (Exception var32_63) {
                            var32_63.printStackTrace();
                        }
                    }
                    if (var18_8 == null) return;
                    ** try [egrp 22[TRYBLOCK] [49 : 3228->3239)] { 
lbl515:
                    // 1 sources

                    var18_8.disconnect();
                    return;
lbl517:
                    // 1 sources

                    catch (Exception var32_63) {
                        this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_63);
                        this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                        System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                        var32_63.printStackTrace();
                    }
                    return;
lbl523:
                    // 2 sources

                    var31_56 = null;
                    this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                    System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                    if (var2_2 != null) {
                        ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl528:
                        // 1 sources

                        var2_2.disconnect();
                        var2_2 = null;
                        break block127;
lbl531:
                        // 1 sources

                        catch (Exception var32_67) {
                            var32_67.printStackTrace();
                        }
                    }
                }
                if (var18_8 == null) return;
                ** try [egrp 22[TRYBLOCK] [49 : 3228->3239)] { 
lbl536:
                // 1 sources

                var18_8.disconnect();
                return;
lbl538:
                // 1 sources

                catch (Exception var32_67) {
                    this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_67);
                    this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
                    System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
                    var32_67.printStackTrace();
                }
                return;
lbl544:
                // 4 sources

                var31_57 = null;
                this.printOut("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                System.out.println("host:" + this.host + " , Port:" + this.port + "  EgMq.getChannelStatusV6()In finally block");
                if (var2_2 != null) {
                    ** try [egrp 21[TRYBLOCK] [48 : 3207->3216)] { 
lbl549:
                    // 1 sources

                    var2_2.disconnect();
                    var2_2 = null;
                    break block128;
lbl552:
                    // 1 sources

                    catch (Exception var32_68) {
                        var32_68.printStackTrace();
                    }
                }
            }
            if (var18_8 == null) return;
            try {}
            catch (Exception var32_68) {}
            this.printOutStackTrace("ERROR EgMq.getChannelStatusV6() host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ", var32_68);
            this.logToErrorFile("ERROR", "EgMq.getChannelStatusV6()", "host:" + this.host + " , Port:" + this.port + " Unable to DisConnect Queue Manager ");
            System.out.println("host:" + this.host + " , Port:" + this.port + " ERROR   EgMq.getChannelStatusV6()   Unable to DisConnect Queue Manager ");
            var32_68.printStackTrace();
            return;
            var18_8.disconnect();
            return;
        }
    }

    public synchronized void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        if (this.dateInfo == null) {
            this.dateInfo = new EgDateInfo();
        }
        String string4 = this.dateInfo.egetDate();
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        try {
            printWriter = new PrintWriter(new FileWriter(EgConfigInfo.egAgentErrorFile, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + ": " + string3);
        printWriter.println(string5);
        printWriter.close();
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> Host:" + this.host + " , Port:" + this.port + " >>" + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            EgMq.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] :  >> Host:" + this.host + " , Port:" + this.port + " >>" + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >>Host:" + this.host + " , Port:" + this.port + " >> " + string);
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            EgMq.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> Host:" + this.host + " , Port:" + this.port + " >>" + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >>Host:" + this.host + " , Port:" + this.port + " >>" + string);
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            EgMq.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> Host:" + this.host + " , Port:" + this.port + " >>" + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >>Host:" + this.host + " , Port:" + this.port + " >>" + string);
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            EgMq.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> Host:" + this.host + " , Port:" + this.port + " >>" + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_ABSOLUTE_PATH;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            EgMq.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }
}

