/*
 * Decompiled with CFR 0.152.
 */
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class ESThreadPoolTest
extends ElasticSearchBase {
    private static final String discriptorTableName = "THREAD_POOLING_DISCRIPTORS";

    public ESThreadPoolTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        try {
            logger.info(this.logPrefix + " Initializing ElasticSearchThreadPoolTest ...");
            this.setMeasureCount(this.measureCount);
            logger.info(this.logPrefix + " ElasticSearchThreadPoolTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing ElasticSearchThreadPoolTest", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block13: {
            try {
                logger.debug(this.logPrefix + " ElasticSearchThreadPoolTest - Test cycle START ");
                String string = this.getElasticSearchRestURLForTest(this.entity);
                logger.debug(this.logPrefix + " [computeMeasures] the URL is :" + string);
                String string2 = this.getElasticsearchJSONData(string);
                logger.debug(this.logPrefix + " [computeMeasures] the JSON Data is :" + string2);
                Configuration configuration = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
                if (string2 != null && string2.length() > 4) {
                    ArrayList arrayList = null;
                    try {
                        arrayList = (ArrayList)JsonPath.using((Configuration)configuration).parse(string2).read("$['nodes'].* ", new Predicate[0]);
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        logger.debug(this.logPrefix + " [computeMeasures] No nodes found");
                        logger.debug(this.logPrefix + " ElasticSearchThreadPoolTest - Test cycle END ");
                        return;
                    }
                    catch (Exception exception) {
                        logger.warn(this.logPrefix + " [computeMeasures] Unable to get JSON paths from JSON Data " + exception.getMessage() + exception.getCause());
                        logger.debug(this.logPrefix + " ElasticSearchThreadPoolTest - Test cycle END ");
                        return;
                    }
                    Hashtable hashtable2 = this.jsonBuilder(string2, this.entity.toUpperCase() + "_JSONPATH", arrayList);
                    Hashtable hashtable3 = this.getElasticSearchIndexMappingTable(this.entity.toUpperCase() + "_INDEX");
                    Hashtable hashtable4 = this.getElasticSearchNamesMappingTable(discriptorTableName);
                    Iterator iterator = (Iterator)((Object)hashtable4.keys());
                    double d = 0.0;
                    double d2 = 0.0;
                    while (iterator.hasNext()) {
                        String string3 = (String)hashtable4.get(iterator.next());
                        Hashtable hashtable5 = this.jsonBuilderSecondDiscriptor(hashtable2, string3, string2);
                        if (hashtable5 == null || hashtable5.size() <= 0) continue;
                        Iterator iterator2 = (Iterator)((Object)hashtable5.keys());
                        ArrayList arrayList2 = this.finalMeasures(this.measureCount);
                        String string4 = "";
                        while (iterator2.hasNext()) {
                            String string5 = (String)iterator2.next();
                            string4 = string5.substring(0, string5.indexOf("#"));
                            String string6 = string5.substring(string5.indexOf("#") + 1);
                            String string7 = (String)hashtable5.get(string5);
                            if (!hashtable3.containsKey(string6)) continue;
                            int n = Integer.parseInt(hashtable3.get(string6).toString());
                            arrayList2.set(n, new Double(string7));
                            d = string6.equals("ThreadPool_Active") ? (double)Integer.parseInt(string7) : d;
                            d2 = string6.equals("ThreadPool_Threads") ? (double)Integer.parseInt(string7) : d2;
                        }
                        double d3 = d2 > 0.0 ? d / d2 * 100.0 : 0.0;
                        arrayList2.set(0, new Double(d3));
                        logger.info(this.logPrefix + "  [computeMeasures]  " + string4 + " activeThreads: " + d + ", totalThreads: " + d2 + ", threadUtil: " + d3);
                        logger.info(this.logPrefix + "  [computeMeasures]  " + string4 + " - measure contains " + arrayList2);
                        this.addNewMeasure(string4, arrayList2);
                    }
                    break block13;
                }
                logger.warn(this.logPrefix + " [computeMeasures] JSON data is NULL or Empty.  jsonData : " + string2);
                return;
                {
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                logger.debug(this.logPrefix + " ElasticSearchThreadPoolTest - Test cycle END ");
            }
        }
    }

    public Hashtable jsonBuilderSecondDiscriptor(Hashtable hashtable, String string, String string2) {
        if (string2 == null) {
            return null;
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Iterator iterator = (Iterator)((Object)hashtable.keys());
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Hashtable hashtable3 = (Hashtable)hashtable.get(string3);
            Iterator iterator2 = (Iterator)((Object)hashtable3.keys());
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                String string5 = (String)hashtable3.get(string4);
                string5 = string5.replace("#", string);
                try {
                    String string6 = JsonPath.read((String)string2, (String)string5, (Predicate[])new Predicate[0]).toString();
                    if (string6 == null) continue;
                    hashtable2.put(string + "#" + string4, string6);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    logger.warn(this.logPrefix + " [getValueForKeyFromJSON_NonInfoBased] Path {} not found in JsonData {}", (Object)string5, (Object)string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return hashtable2;
    }

    public static void main(String[] stringArray) {
        ESThreadPoolTest eSThreadPoolTest = new ESThreadPoolTest(stringArray);
        eSThreadPoolTest.computeMeasures(new Hashtable());
    }
}

