/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;

public class Db2DbMgrSetting_cf
extends IBMDb2ConfigBase {
    private double db2Version = 10.0;
    private boolean checkDB2Version = true;

    public Db2DbMgrSetting_cf(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(23);
        this.setConfigInfoTestFlag(false);
    }

    public void computeMeasures(Hashtable hashtable) {
        if (this.checkDB2Version) {
            this.db2Version = this.db2SSL.equalsIgnoreCase("true") ? Db2DbMgrSetting_cf.getDb2Version(this.db2DbHost, this.db2DbPort, this.db2UserName, this.db2Password, this.db2DbName, this.index, this.db2SSL) : Db2DbMgrSetting_cf.getDb2Version(this.db2DbHost, this.db2DbPort, this.db2UserName, this.db2Password, this.db2DbName, this.index);
            this.checkDB2Version = false;
        }
        if (this.db2Version < 10.5) {
            this.logToErrorFile("INFO", this.entity + " run from DB2 version 10.5 onwards", this.reportingName);
            return;
        }
        ArrayList<String> arrayList = null;
        if (!this.computeValues()) {
            this.configError = true;
            return;
        }
        if (!this.datacoll.isEmpty()) {
            arrayList = new ArrayList<String>();
            String string = (String)this.datacoll.get("numdb");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("tm_database");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("tp_mon_name");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("spm_name");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("svcename");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("dir_cache");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("discover_inst");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("discover");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("conn_elapse");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("resync_interval");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("max_time_diff");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("start_stop_time");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("indexrec");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("rqrioblk");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("max_querydegree");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("cpuspeed");
            string = this.checkNull(string, null);
            if (!string.equalsIgnoreCase("-")) {
                string = this.removeExpAndRound(string);
            }
            arrayList.add(string);
            string = (String)this.datacoll.get("notifylevel");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("dftdbpath");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("jdk_path");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("trust_allclnts");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("comm_exit_list");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("group_plugin");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("srv_plugin_mode");
            string = this.checkNull(string, null);
            arrayList.add(string);
            this.addNewMeasure(arrayList);
        }
    }

    private String removeExpAndRound(String string) {
        String string2 = "0.0";
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            double d = bigDecimal.doubleValue();
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(20);
            string2 = decimalFormat.format(d).toString();
        }
        catch (Exception exception) {
            string2 = "0.0";
            return string2;
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        Hashtable hashtable = new Hashtable();
        Db2DbMgrSetting_cf db2DbMgrSetting_cf = new Db2DbMgrSetting_cf(stringArray);
        db2DbMgrSetting_cf.computeMeasures(hashtable);
    }
}

