/*
 * Decompiled with CFR 0.152.
 */
import com.citrix.netscaler.nitro.exception.nitro_exception;
import com.citrix.netscaler.nitro.resource.base.EmptyHostnameVerifier;
import com.citrix.netscaler.nitro.resource.base.EmptyTrustManager;
import com.citrix.netscaler.nitro.service.nitro_service;
import com.eg.EgSSL;
import java.net.ConnectException;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CtxNsValidator
extends EgServerValidator {
    private String host = "";
    private String netScaler_userName = "";
    private String netScaler_password = "";
    private String ssl = "";
    private String message = "";
    private ArrayList validationMsgs = new ArrayList();

    public CtxNsValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-NetScaler_username")) {
                    this.netScaler_userName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-NetScaler_password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.netScaler_password = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-ssl")) continue;
                this.ssl = string3;
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
    }

    public void validate() {
        try {
            if (!this.getConnection(this.host, this.netScaler_userName, this.netScaler_password)) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Citrix NetScaler Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                } else {
                    this.validationMsgs.add("Citrix NetScaler Connectivity$#$Failed - " + this.message);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                }
                return;
            }
            this.validationMsgs.add("Citrix NetScaler Connectivity$#$OK");
            this.validationMsgs.add("Host IP/Name$#$OK");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getConnection(String string, String string2, String string3) {
        boolean bl = false;
        nitro_service nitro_service2 = null;
        String string4 = "http";
        if (this.ssl != null && this.ssl.equalsIgnoreCase("true")) {
            string4 = "https";
            this.installSSL();
        }
        try {
            nitro_service2 = new nitro_service(string, string4);
            nitro_service2.set_certvalidation(new Boolean(false));
            nitro_service2.set_hostnameverification(new Boolean(false));
            if (nitro_service2 != null) {
                nitro_service2.login(string2, string3, new Long(120L));
                bl = nitro_service2.isLogin();
                this.message = "Connected";
                nitro_service2.logout();
            }
        }
        catch (ConnectException connectException) {
            this.message = "Invalid ip address or hostname";
        }
        catch (SocketException socketException) {
            this.message = "Invalid protocol(HTTP/HTTPS)";
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            this.message = "SSL handshake exception";
        }
        catch (nitro_exception nitro_exception2) {
            this.message = "Invalid username or password";
        }
        catch (Exception exception) {
            this.message = this.getStackTraceAsString(exception);
        }
        return bl;
    }

    public void installSSL() {
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var3_4 = null;
            EmptyTrustManager emptyTrustManager = new EmptyTrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{emptyTrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new EmptyHostnameVerifier());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        CtxNsValidator ctxNsValidator = new CtxNsValidator(stringArray, new Boolean(true));
        ctxNsValidator.getValidationMsgs();
    }
}

