/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import com.eg.EgSSL;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import com.xensource.xenapi.APIVersion;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Session;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.VMGuestMetrics;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CitrixXenServerPoolDiscovery {
    private String ipAddress = null;
    private int portNo = 80;
    private boolean isSSL = false;
    private String username = null;
    private String password = null;
    private Connection connObj = null;
    private String connectionString = "";
    public String sync = new String("ssl_sync");
    public boolean xenServerConn = true;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostIsSlave;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$SessionAuthenticationFailed;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$SessionInvalid;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostDisabled;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostNameInvalid;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostDisabledUntilReboot;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostNotEnoughFreeMemory;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostNotLive;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostOffline;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostInEmergencyMode;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostHasNoManagementIp;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostUnknownToMaster;

    public CitrixXenServerPoolDiscovery(String string, int n, boolean bl, String string2, String string3) {
        this.ipAddress = string;
        this.portNo = n;
        this.isSSL = bl;
        this.username = string2;
        this.password = EgCrypt.decrypt(string3);
    }

    public Hashtable getXenPoolServers() {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        this.xenServerConn = true;
        Connection connection = this.getConnection();
        if (connection == null) {
            this.xenServerConn = false;
            System.out.println("[CitrixXenServerPoolDiscovery] Connection object is NULL!");
            return hashtable;
        }
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
        try {
            Map map = Host.getAllRecords((Connection)connection);
            if (map == null) {
                return hashtable;
            }
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2;
                Host.Record record = (Host.Record)iterator.next();
                if (record == null || (string2 = record.hostname) == null || string2.length() == 0 || (string = record.address) == null || string.length() == 0) continue;
                Set set = record.residentVMs;
                if (set == null || set.size() == 0) {
                    hashtable4.put(string2, string);
                    continue;
                }
                boolean bl = false;
                int n = 0;
                int n2 = 0;
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    String string3;
                    VMGuestMetrics vMGuestMetrics;
                    VM vM = (VM)iterator2.next();
                    if (vM == null || (vMGuestMetrics = vM.getGuestMetrics(connection)) == null) continue;
                    Map map2 = null;
                    try {
                        map2 = vMGuestMetrics.getOsVersion(connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (map2 == null || map2.size() == 0 || (string3 = (String)map2.get("name")) == null || string3.length() == 0) continue;
                    if ((string3 = string3.toLowerCase()) != null && (string3.indexOf("2008") > 0 || string3.indexOf("2012") > 0 || string3.indexOf("2016") > 0 || string3.indexOf("2019") > 0 || string3.indexOf("2022") > 0 || string3.indexOf("linux") >= 0 || string3.indexOf("centos") >= 0 || string3.indexOf("server") > 0 || string3.indexOf("other") >= 0 || string3.indexOf("freebsd") >= 0)) {
                        ++n;
                        continue;
                    }
                    ++n2;
                }
                bl = n >= n2;
                if (bl) {
                    hashtable4.put(string2, string);
                    continue;
                }
                hashtable5.put(string2, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.logout(connection);
        hashtable.put("Xen_virtual_server", hashtable4);
        hashtable.put("Xen_desktop_server", hashtable5);
        System.out.println("[CitrixXenServerPoolDiscovery] allServersHash is ==>" + hashtable);
        return hashtable;
    }

    private Connection getConnection() {
        try {
            this.connectionString = "http://" + this.ipAddress + ":" + this.portNo + "";
            if (this.isSSL) {
                this.installSSL();
                this.connectionString = "https://" + this.ipAddress + ":" + this.portNo + "";
            }
            this.connObj = new Connection(new URL(this.connectionString));
            Session.loginWithPassword((Connection)this.connObj, (String)this.username, (String)this.password, (String)APIVersion.latest().toString());
            System.out.println("[CitrixXenServerPoolDiscovery] generated sessionid is ==>" + this.connObj.getSessionReference());
        }
        catch (Exception exception) {
            try {
                if ((class$com$xensource$xenapi$Types$HostIsSlave == null ? (class$com$xensource$xenapi$Types$HostIsSlave = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostIsSlave")) : class$com$xensource$xenapi$Types$HostIsSlave).getName().equals(exception.getClass().getName())) {
                    Types.HostIsSlave hostIsSlave = (Types.HostIsSlave)exception;
                    String string = hostIsSlave.masterIPAddress.trim();
                    Connection connection = this.getConnection(string);
                } else if ((class$com$xensource$xenapi$Types$SessionAuthenticationFailed == null ? (class$com$xensource$xenapi$Types$SessionAuthenticationFailed = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$SessionAuthenticationFailed")) : class$com$xensource$xenapi$Types$SessionAuthenticationFailed).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Invalid credentials  " + exception);
                } else if ((class$com$xensource$xenapi$Types$SessionInvalid == null ? (class$com$xensource$xenapi$Types$SessionInvalid = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$SessionInvalid")) : class$com$xensource$xenapi$Types$SessionInvalid).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Invalid session " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostDisabled == null ? (class$com$xensource$xenapi$Types$HostDisabled = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostDisabled")) : class$com$xensource$xenapi$Types$HostDisabled).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Hostname is disabled " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostNameInvalid == null ? (class$com$xensource$xenapi$Types$HostNameInvalid = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostNameInvalid")) : class$com$xensource$xenapi$Types$HostNameInvalid).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Hostname is invalid " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostDisabledUntilReboot == null ? (class$com$xensource$xenapi$Types$HostDisabledUntilReboot = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostDisabledUntilReboot")) : class$com$xensource$xenapi$Types$HostDisabledUntilReboot).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Host is disabled until restart " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostNotEnoughFreeMemory == null ? (class$com$xensource$xenapi$Types$HostNotEnoughFreeMemory = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostNotEnoughFreeMemory")) : class$com$xensource$xenapi$Types$HostNotEnoughFreeMemory).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Host is not enough memory " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostNotLive == null ? (class$com$xensource$xenapi$Types$HostNotLive = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostNotLive")) : class$com$xensource$xenapi$Types$HostNotLive).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Host is not live " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostOffline == null ? (class$com$xensource$xenapi$Types$HostOffline = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostOffline")) : class$com$xensource$xenapi$Types$HostOffline).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Host is Offline " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostInEmergencyMode == null ? (class$com$xensource$xenapi$Types$HostInEmergencyMode = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostInEmergencyMode")) : class$com$xensource$xenapi$Types$HostInEmergencyMode).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Host is in emergency mode " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostHasNoManagementIp == null ? (class$com$xensource$xenapi$Types$HostHasNoManagementIp = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostHasNoManagementIp")) : class$com$xensource$xenapi$Types$HostHasNoManagementIp).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] Host has no management ip " + exception);
                } else if ((class$com$xensource$xenapi$Types$HostUnknownToMaster == null ? (class$com$xensource$xenapi$Types$HostUnknownToMaster = CitrixXenServerPoolDiscovery.class$("com.xensource.xenapi.Types$HostUnknownToMaster")) : class$com$xensource$xenapi$Types$HostUnknownToMaster).getName().equals(exception.getClass().getName())) {
                    System.out.println("[CitrixXenServerPoolDiscovery] The master says the host is not known to it " + exception);
                } else {
                    System.err.println("[CitrixXenServerPoolDiscovery] failed for URL " + this.connectionString + " with user " + this.username + " Reason: " + exception);
                    exception.printStackTrace();
                }
            }
            catch (Exception exception2) {
                System.err.println("[CitrixXenServerPoolDiscovery] XenConnection failed for URL " + this.connectionString + " with user " + this.username + " Reason: " + exception2);
                exception2.printStackTrace();
                System.out.println("[CitrixXenServerPoolDiscovery] connection failed " + exception2);
            }
        }
        return this.connObj;
    }

    public Connection getConnection(String string) {
        try {
            this.connectionString = "http://" + string + ":" + this.portNo + "";
            if (this.isSSL) {
                this.connectionString = "https://" + string + ":" + this.portNo + "";
            }
            this.connObj = new Connection(new URL(this.connectionString));
            Session.loginWithPassword((Connection)this.connObj, (String)this.username, (String)this.password, (String)APIVersion.latest().toString());
            System.out.println("[CitrixXenServerPoolDiscovery] generated sessionid from pool master ip is ==>" + string + " " + this.connObj.getSessionReference());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("[CitrixXenServerPoolDiscovery] connection failed in Xen Pool Master Server : " + exception);
        }
        return this.connObj;
    }

    private void logout(Connection connection) {
        try {
            if (connection != null) {
                Session.logout((Connection)connection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installSSL() {
        String string = this.sync;
        synchronized (string) {
            try {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var4_5 = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isConnected() {
        return this.xenServerConn;
    }

    public static void main(String[] stringArray) {
        int n;
        boolean bl;
        String string;
        String string2;
        String string3;
        block4: {
            if (stringArray.length < 5) {
                System.out.println("============================================================================");
                System.out.println("Please provide the required parameters !!!");
                System.out.println("Syntax : java CitrixXenServerPoolDiscovery <ipaddress> <port> <ssl> <user> <password> ");
                System.out.println("Example : java CitrixXenServerPoolDiscovery 192.168.10.156 80 false root C13120CB9E5D4B1423419897808BAE65");
                System.out.println("=============================================================================");
                return;
            }
            string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            string2 = stringArray[3];
            string = stringArray[4];
            string = EgCrypt.decrypt(string);
            bl = false;
            if (string5 != null && (string5.trim().equalsIgnoreCase("true") || string5.trim().equalsIgnoreCase("yes"))) {
                bl = true;
            }
            n = 80;
            try {
                n = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                n = 80;
                if (!bl) break block4;
                n = 443;
            }
        }
        CitrixXenServerPoolDiscovery citrixXenServerPoolDiscovery = new CitrixXenServerPoolDiscovery(string3, n, bl, string2, string);
        Hashtable hashtable = citrixXenServerPoolDiscovery.getXenPoolServers();
        System.out.println("Final output is " + hashtable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

