/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class CisNexusSensorBase
extends EgSnmpGenericTest {
    private static Hashtable lastTimeHash = new Hashtable();
    private static String gSync = new String("gSync");
    private static Hashtable syncHash = new Hashtable();
    private String sync = new String("ciscoNexus");
    private long lastTime = 0L;
    protected static Hashtable totalHash = new Hashtable();
    private double YOCTO = -1.59383552E9;
    private double ZEPTO = -5.59939584E8;
    private double ATTO = -1.486618624E9;
    private double FEMTO = -1.530494976E9;
    private double PICO = -7.27379968E8;
    private double NANO = 1.0E9;
    private double MICRO = 1000000.0;
    private double MILLI = 1000.0;
    private double UNITS = 1.0;
    private double KILO = 1000.0;
    private double MEGA = 1000000.0;
    private double GIGA = 1.0E9;
    private double TERA = -7.27379968E8;
    private double EXA = -1.530494976E9;
    private double PETA = -1.486618624E9;
    private double ZETTA = -5.59939584E8;
    private double YOTTA = -1.59383552E9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CisNexusSensorBase(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
        String string = gSync;
        synchronized (string) {
            String string2 = (String)syncHash.get(this.reportingName);
            if (string2 == null) {
                string2 = new String(this.reportingName);
                syncHash.put(this.reportingName, string2);
                this.setLastExectionTime();
            }
            this.sync = (String)syncHash.get(this.reportingName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectMetrics() {
        this.getLastExectionTime();
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTime;
        long l3 = (long)(0.9 * (double)this.measurePeriod);
        boolean bl = false;
        if (l2 >= l3) {
            String string = this.sync;
            synchronized (string) {
                this.getLastExectionTime();
                l = System.currentTimeMillis();
                l2 = l - this.lastTime;
                l3 = (long)(0.9 * (double)this.measurePeriod);
                bl = false;
                if (l2 >= l3) {
                    bl = true;
                    this.lastTime = l;
                    this.setLastExectionTime();
                } else {
                    bl = false;
                }
                if (bl) {
                    this.setMeasures();
                    this.lastTime = System.currentTimeMillis();
                    this.setLastExectionTime();
                }
            }
        }
    }

    private void setMeasures() {
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String string = null;
            Hashtable<String, ArrayList<Double>> hashtable = new Hashtable<String, ArrayList<Double>>();
            Hashtable<String, ArrayList<Double>> hashtable2 = new Hashtable<String, ArrayList<Double>>();
            Hashtable<String, ArrayList<Double>> hashtable3 = new Hashtable<String, ArrayList<Double>>();
            Hashtable<String, ArrayList<Double>> hashtable4 = new Hashtable<String, ArrayList<Double>>();
            ArrayList<Hashtable<String, ArrayList<Double>>> arrayList2 = new ArrayList<Hashtable<String, ArrayList<Double>>>();
            Hashtable hashtable5 = this.getMeasure(".1.3.6.1.2.1.47.1.1.1.1.7");
            Hashtable hashtable6 = this.getMeasure(".1.3.6.1.4.1.9.9.91.1.1.1.1.1");
            Hashtable hashtable7 = this.getMeasure(".1.3.6.1.4.1.9.9.91.1.1.1.1.5");
            Hashtable hashtable8 = this.getMeasure(".1.3.6.1.4.1.9.9.91.1.1.1.1.4");
            Hashtable hashtable9 = this.getMeasure(".1.3.6.1.4.1.9.9.91.1.1.1.1.2");
            if (hashtable6 != null && hashtable6.size() > 0) {
                Enumeration enumeration = hashtable6.keys();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    String string3 = (String)enumeration.nextElement();
                    if (string3 == null || (string = (String)hashtable5.get(string3)) == null || (string2 = (String)hashtable6.get(string3)) == null || string2.trim().length() == 0) continue;
                    String string4 = (String)hashtable7.get(string3);
                    String string5 = (String)hashtable8.get(string3);
                    String string6 = (String)hashtable9.get(string3);
                    if (string4 == null || string4.trim().length() == 0) {
                        string4 = "-5";
                    }
                    double d = -5.0;
                    d = string5 == null || string5.trim().length() == 0 ? -5.0 : this.getSensorReading(string5, string6);
                    arrayList = new ArrayList();
                    arrayList.add(new Double(string4));
                    arrayList.add(new Double(d));
                    if (string2.trim().equalsIgnoreCase("3") || string2.trim().equalsIgnoreCase("4")) {
                        hashtable.put(string, arrayList);
                        continue;
                    }
                    if (string2.trim().equalsIgnoreCase("6")) {
                        hashtable2.put(string, arrayList);
                        continue;
                    }
                    if (string2.trim().equalsIgnoreCase("8")) {
                        hashtable3.put(string, arrayList);
                        continue;
                    }
                    if (!string2.trim().equalsIgnoreCase("10")) continue;
                    hashtable4.put(string, arrayList);
                }
            }
            arrayList2.add(hashtable);
            arrayList2.add(hashtable2);
            arrayList2.add(hashtable3);
            arrayList2.add(hashtable4);
            if (arrayList2 != null && arrayList2.size() > 0) {
                totalHash.put(this.reportingName, arrayList2);
            }
            System.out.println("CisNexusSensorBase targetHost :" + this.targetHost + " reportingName: " + this.reportingName + " Current TIme ::" + new Date().toString() + "totalHash: " + totalHash);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setLastExectionTime() {
        lastTimeHash.put(this.reportingName, new Long(this.lastTime));
    }

    private void getLastExectionTime() {
        Long l = (Long)lastTimeHash.get(this.reportingName);
        this.lastTime = l;
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "CisNexusSensorBase error occured in getMeasure", exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            System.out.println("Exception in getDoubleValueMethod:" + exception);
            exception.printStackTrace();
        }
        return d;
    }

    private double getSensorReading(String string, String string2) {
        double d = -5.0;
        try {
            int n = Integer.parseInt(string2);
            double d2 = Double.parseDouble(string);
            switch (n) {
                case 1: {
                    d = d2 / this.YOCTO;
                    break;
                }
                case 2: {
                    d = d2 / this.ZEPTO;
                    break;
                }
                case 3: {
                    d = d2 / this.ATTO;
                    break;
                }
                case 4: {
                    d = d2 / this.FEMTO;
                    break;
                }
                case 5: {
                    d = d2 / this.PICO;
                    break;
                }
                case 6: {
                    d = d2 / this.NANO;
                    break;
                }
                case 7: {
                    d = d2 / this.MICRO;
                    break;
                }
                case 8: {
                    d = d2 / this.MILLI;
                    break;
                }
                case 9: {
                    d = d2 / this.UNITS;
                    break;
                }
                case 10: {
                    d = d2 * this.KILO;
                    break;
                }
                case 11: {
                    d = d2 * this.MEGA;
                    break;
                }
                case 12: {
                    d = d2 * this.GIGA;
                    break;
                }
                case 13: {
                    d = d2 * this.TERA;
                    break;
                }
                case 14: {
                    d = d2 * this.EXA;
                    break;
                }
                case 15: {
                    d = d2 * this.PETA;
                    break;
                }
                case 16: {
                    d = d2 * this.ZETTA;
                    break;
                }
                case 17: {
                    d = d2 * this.YOTTA;
                    break;
                }
                default: {
                    d = d2;
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in getDoubleValueMethod:" + exception);
            exception.printStackTrace();
        }
        return d;
    }
}

