/*
 * Decompiled with CFR 0.152.
 */
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class AsSysWorkJco2Test
extends AsAbapJco2Base {
    private static DecimalFormat dformat = new DecimalFormat("#");
    private static String fieldSep = new String("");
    private ArrayList instanceHostList = new ArrayList();
    private String myPool = null;
    private static final int MAX_CONNECTIONS = 2;
    private Properties poolProperties = new Properties();
    private Hashtable poolsTable = new Hashtable();
    private Hashtable connTracker = new Hashtable();
    private IRepository[] repository;
    private String sync0 = new String("x");
    private String sync1 = new String("CON_POOL");
    private String client = null;
    private String sapuser = null;
    private String password = null;
    private String sysnr = null;
    private String appSrvr = null;
    Hashtable extMemDDTbl = new Hashtable();
    Hashtable privMemDDTbl = new Hashtable();
    protected static int CREATE_COUNT = 0;
    protected static int RUN_COUNT = 1;
    protected static int WAIT_COUNT = 2;
    protected static int HOLD_COUNT = 3;
    protected static int OTHER_COUNT = 4;
    protected static int PRIV_COUNT = 5;
    protected static int RUN_PCT = 6;
    protected static int WAIT_PCT = 7;
    protected static int HOLD_PCT = 8;
    protected static int PRIV_PCT = 9;
    protected static int EXT_MEM = 10;
    protected static int PRIV_MEM = 11;
    private static final String max_concurrent1 = "2";
    private static final String max_idle_conns1 = "1";
    protected Hashtable jco2MeasureHashtable = new Hashtable();
    ArrayList defaultList = new ArrayList();
    private static int MEAS_CNT = 12;
    public static final Hashtable WPTypExpansionTbl = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsSysWorkJco2Test(String[] stringArray) {
        super(stringArray);
        this.client = this.getValueForParam("clientname");
        this.sapuser = this.getValueForParam("sapuser");
        this.password = this.getValueForParam("password");
        this.sysnr = this.getValueForParam("sysnr");
        this.appSrvr = this.getValueForParam("Application_server");
        if (fieldSep.length() == 0) {
            String string = this.sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        this.instanceHostList = this.getInstancesList();
        for (int i = 0; i < MEAS_CNT; ++i) {
            this.defaultList.add(new Double(0.0));
        }
        if (this.instanceHostList == null || this.instanceHostList.size() == 0) {
            this.printOut("ERROR : " + this.entity + " Cannot get Instance names from the sap system");
            this.logToErrorFile("ERROR : ", this.entity, " Cannot get Instance names from the sap system");
            return;
        }
        this.repository = new IRepository[this.instanceHostList.size()];
        this.printOut("DEBUG : In synchronization block. Creating connection pool");
        this.createPool();
    }

    private void getWPInfo() {
        this.printOut("About to get WP info :");
        ArrayList arrayList = new ArrayList();
        Hashtable hashtable = new Hashtable();
        this.jco2MeasureHashtable.put("Background", new ArrayList(this.defaultList));
        this.jco2MeasureHashtable.put("Dialog", new ArrayList(this.defaultList));
        this.jco2MeasureHashtable.put("Enqueue", new ArrayList(this.defaultList));
        this.jco2MeasureHashtable.put("Spool", new ArrayList(this.defaultList));
        this.jco2MeasureHashtable.put("Update 2", new ArrayList(this.defaultList));
        this.jco2MeasureHashtable.put("Update", new ArrayList(this.defaultList));
        String string = "";
        String string2 = "";
        String string3 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        ArrayList arrayList2 = null;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        String string16 = "";
        String string17 = "";
        String string18 = "";
        String string19 = "";
        String string20 = "";
        String string21 = "";
        String string22 = "";
        for (int i = 0; i < this.instanceHostList.size(); ++i) {
            String string23 = this.instanceHostList.get(i).toString();
            String string24 = string23.substring(0, string23.indexOf("_"));
            String string25 = string23.substring(string23.indexOf("_") + 1, string23.length());
            String string26 = string24;
            this.printOut("Processing instance " + string25 + " with number " + string24);
            String string27 = string24;
            String string28 = this.poolsTable.get(string23).toString();
            JCO.Client client = null;
            try {
                client = this.getPooledConnection(string28);
            }
            catch (Exception exception) {
                this.printOut("ERROR : Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
                this.releaseClient(client, string28);
                break;
            }
            this.printOut("DEBUG : " + this.entity + " Creating function with repository = " + this.repository[i].getName());
            JCO.Function function = this.createFunction("STUM_WP_SERVER_ACTIVITY", this.repository[i]);
            if (function == null) {
                this.releaseClient(client);
                return;
            }
            long l = System.currentTimeMillis();
            try {
                this.executeFunction(function, client, false);
            }
            catch (Exception exception) {
                this.printOut("Error : Exception while executing STUM_WP_SERVER_ACTIVITY : " + exception.toString());
                this.releaseClient(client, string28);
                this.logToErrorFile("ERROR", this.entity, "Exception while executing STUM_WP_SERVER_ACTIVITY : " + exception.toString());
                return;
            }
            ArrayList arrayList3 = this.getSystemTimestamp();
            if (arrayList3 == null) {
                this.printOut("ERROR: Unable to get system time stamp. Will not be able to determine active users");
                this.releaseClient(client, string28);
                return;
            }
            JCO.Table table = null;
            try {
                table = function.getTableParameterList().getTable("WP_INFO");
            }
            catch (Exception exception) {
                this.printOut("Exception while trying to get WP_INFO table. : " + exception.toString());
                return;
            }
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            Double d17 = null;
            Double d18 = null;
            StringBuffer stringBuffer = null;
            String string29 = null;
            for (int j = 0; j < table.getNumRows(); ++j) {
                ArrayList arrayList4;
                arrayList2 = new ArrayList();
                table.setRow(j);
                d10 = 0.0;
                stringBuffer = new StringBuffer();
                string = table.getString("WP_TYP");
                if (string == null || string.trim().length() == 0) {
                    this.printOut("Error : work process type is null or empty!");
                    this.logToErrorFile("Error", this.entity, "work process type is null or empty!");
                    continue;
                }
                string3 = (String)WPTypExpansionTbl.get(string);
                if (string3 == null) {
                    this.printOut("Warning : could not find mapping for work process type abbreviation : " + string);
                    string3 = string;
                    arrayList2 = (ArrayList)this.jco2MeasureHashtable.get(string3);
                    if (arrayList2 == null) {
                        this.jco2MeasureHashtable.put(string3, new ArrayList(this.defaultList));
                    }
                }
                this.printOut("Mapped info is " + string3);
                arrayList2 = (ArrayList)this.jco2MeasureHashtable.get(string3);
                if (arrayList2 == null || arrayList2.size() != this.measureCount) {
                    this.printOut("Error :  Measure List for info " + string3 + " is null or its size is less than the measures count: " + arrayList2);
                    continue;
                }
                string4 = table.getString("WP_NO");
                string29 = string3 + "_" + string4;
                string5 = table.getString("WP_PID").trim();
                if (string5 == null || string5.trim().length() == 0) {
                    string5 = "Not Available";
                }
                if ((string6 = table.getString("WP_DUMPS")) == null || string6.trim().length() == 0) {
                    string6 = "0";
                }
                if ((string7 = table.getString("WP_BNAME").trim()) == null || string7.trim().length() == 0) {
                    string7 = "Not Available";
                }
                if ((string8 = table.getString("WP_MANDT").trim()) == null || string8.trim().length() == 0) {
                    string8 = "Not Available";
                }
                if ((string9 = table.getString("WP_REPORT")) == null || string9.trim().length() == 0) {
                    string9 = "Not Available";
                }
                if ((string11 = table.getString("WP_TABLE").trim()) == null || string11.trim().length() == 0) {
                    string11 = "Not Available";
                }
                if ((string12 = table.getString("WP_ELTIME").trim()) == null || string12.length() == 0) {
                    string12 = "Not Available";
                    d15 = 0.0;
                } else {
                    try {
                        d15 = Double.parseDouble(string12);
                        d15 /= 60.0;
                    }
                    catch (Exception exception) {
                        this.printOut("Error while parsing elapsed time " + string12 + " for work process " + string3 + " : " + exception.toString());
                        this.logToErrorFile("ERROR", this.entity, "Error while parsing elapsed time " + string12 + " for work process " + string29 + " : " + exception.toString());
                        d15 = 0.0;
                        string12 = "Not Available";
                    }
                }
                this.printOut("DEEP_DEBUG: Got elapsed time " + d15 + " minutes ( " + d15 * 60.0 + " seconds) for info " + string29);
                string10 = table.getString("WP_ACTION").trim();
                string13 = table.getString("WP_STATUS").trim();
                if (string13 == null) {
                    string13 = "UNKNOWN";
                }
                string13 = string13.trim().toUpperCase();
                string14 = table.getString("WP_ISTATUS").trim();
                if (string14 == null) {
                    string14 = "UNKNOWN CODE";
                }
                if ((string15 = table.getString("WP_WAITING").trim()) == null || string15.length() == 0) {
                    string15 = "Not Available";
                }
                d16 = Double.parseDouble(arrayList2.get(CREATE_COUNT).toString());
                arrayList2.set(CREATE_COUNT, new Double(d16 += 1.0));
                if (string13.equalsIgnoreCase("STARTIN") || string13.equalsIgnoreCase("STARTING") || string14.equals("128")) {
                    d16 = Double.parseDouble(arrayList2.get(RUN_COUNT).toString());
                    arrayList2.set(RUN_COUNT, new Double(d16 += 1.0));
                    this.printOut("WARNING : Found 'starting' work process. Clubbing it with running measure ");
                } else if (string13.equalsIgnoreCase("RUNNING") || string14.equals("4")) {
                    d16 = Double.parseDouble(arrayList2.get(RUN_COUNT).toString());
                    arrayList2.set(RUN_COUNT, new Double(d16 += 1.0));
                } else if (string13.equalsIgnoreCase("WAITING") || string14.equals(max_concurrent1)) {
                    d16 = 0.0;
                    d16 = Double.parseDouble(arrayList2.get(WAIT_COUNT).toString());
                    arrayList2.set(WAIT_COUNT, new Double(d16 += 1.0));
                } else if (string13.equalsIgnoreCase("ON HOLD") || string14.equals("8")) {
                    d16 = 0.0;
                    d16 = Double.parseDouble(arrayList2.get(HOLD_COUNT).toString());
                    arrayList2.set(HOLD_COUNT, new Double(d16 += 1.0));
                    if (string15 != null && string15.trim().equalsIgnoreCase("PRIV")) {
                        d16 = 0.0;
                        d16 = Double.parseDouble(arrayList2.get(PRIV_COUNT).toString());
                        arrayList2.set(PRIV_COUNT, new Double(d16 += 1.0));
                    }
                }
                double d19 = (Double)arrayList2.get(RUN_COUNT);
                double d20 = (Double)arrayList2.get(CREATE_COUNT);
                double d21 = (Double)arrayList2.get(WAIT_COUNT);
                double d22 = (Double)arrayList2.get(HOLD_COUNT);
                double d23 = d20 - d19 - d21 - d22;
                arrayList2.set(OTHER_COUNT, new Double(d23));
                double d24 = (Double)arrayList2.get(PRIV_COUNT);
                double d25 = d19 / d20 * 100.0;
                double d26 = d21 / d20 * 100.0;
                double d27 = d22 / d20 * 100.0;
                double d28 = d24 / d20 * 100.0;
                arrayList2.set(RUN_PCT, new Double(d25));
                arrayList2.set(WAIT_PCT, new Double(d26));
                arrayList2.set(HOLD_PCT, new Double(d27));
                arrayList2.set(PRIV_PCT, new Double(d28));
                if (string10 == null || string10.trim().length() == 0) {
                    string10 = "Not Available";
                }
                string19 = table.getString("TCODE");
                string21 = table.getString("MEMSUM");
                try {
                    d13 = Double.parseDouble(string21);
                    d13 /= 1000000.0;
                }
                catch (Exception exception) {
                    this.printOut("Got exception while parsing MEMSUM value '" + string21 + "' : " + exception.toString());
                    d13 = 0.0;
                }
                double d29 = (Double)arrayList2.get(EXT_MEM);
                arrayList2.set(EXT_MEM, new Double(d29 += d13));
                string22 = table.getString("PRIVSUM");
                try {
                    d14 = Double.parseDouble(string22);
                    d14 /= 1000000.0;
                }
                catch (Exception exception) {
                    this.printOut("Got exception while parsing MEMSUM value '" + string22 + "' : " + exception.toString());
                    d14 = 0.0;
                }
                d17 = new Double(d13);
                d18 = new Double(d14);
                double d30 = (Double)arrayList2.get(PRIV_MEM);
                arrayList2.set(PRIV_MEM, new Double(d30 += d14));
                string16 = table.getString("STARTDATE");
                string17 = table.getString("STARTTIME");
                string18 = table.getString("WP_SERVER");
                ArrayList<Object> arrayList5 = new ArrayList<Object>();
                arrayList5.add(string18);
                arrayList5.add(string25);
                arrayList5.add(string);
                arrayList5.add(string13);
                arrayList5.add(string6);
                arrayList5.add(new Double(d13));
                arrayList5.add(new Double(d14));
                arrayList5.add(string16 + " " + string17);
                arrayList5.add(new Double(d15));
                arrayList5.add(string8);
                arrayList5.add(string7);
                arrayList5.add(string9);
                arrayList5.add(string10);
                arrayList5.add(string19);
                arrayList5.add(string20);
                ArrayList arrayList6 = (ArrayList)this.extMemDDTbl.get(string3);
                if (arrayList6 == null) {
                    arrayList6 = new ArrayList();
                    this.extMemDDTbl.put(string3, arrayList6);
                }
                if ((arrayList4 = (ArrayList)this.privMemDDTbl.get(string3)) == null) {
                    arrayList4 = new ArrayList();
                    this.privMemDDTbl.put(string3, arrayList4);
                }
                if (d13 > 0.0) {
                    this.addToSortedList(arrayList6, 5, arrayList5, 5);
                }
                if (!(d14 > 0.0)) continue;
                this.addToSortedList(arrayList4, 6, arrayList5, 5);
            }
            this.releaseClient(client, string28);
        }
        this.printOut("DEBUG : jco2MeasureHashtable  = " + this.jco2MeasureHashtable);
        this.printOut("DEBUG : extMemDDTbl  = " + this.extMemDDTbl);
        this.printOut("DEBUG : privMemDDTbl  = " + this.privMemDDTbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseClient(JCO.Client client, String string) {
        if (client != null) {
            try {
                JCO.releaseClient((JCO.Client)client);
                this.printOut("Released the client connection. Timestamp = " + System.currentTimeMillis());
            }
            catch (Exception exception) {
                this.printOut("Exception while disconnecting client " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Error disconnecting client : " + exception.toString());
            }
            String string2 = string;
            synchronized (string2) {
                Integer n = null;
                n = (Integer)this.connTracker.get(this.entity);
                if (n == null) {
                    this.printOut("Error :  Should not occur. While releasing conn, # conn null for entity " + this.entity);
                } else {
                    n = new Integer(n - 1);
                }
                this.connTracker.put(this.entity, n);
                this.printOut("DEBUG : RELEASE : debug conn tracker is " + this.connTracker.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCO.Client getPooledConnection(String string) {
        JCO.Client client = JCO.getClient((String)string);
        if (client == null) {
            this.printOut("Error : Could not get client");
            this.logToErrorFile("ERROR", this.entity, "Could not get client");
            return null;
        }
        if (!client.isAlive() || !client.isValid()) {
            this.printOut("ERROR : Connection obtained from pool has issues. isAlive? " + client.isAlive() + " isValid? " + client.isValid());
            this.logToErrorFile("ERROR", this.entity, "Connection obtained from pool has issues. isAlive? " + client.isAlive() + " isValid? " + client.isValid());
            return null;
        }
        String string2 = string;
        synchronized (string2) {
            Integer n = null;
            n = (Integer)this.connTracker.get(this.entity);
            n = n == null ? new Integer(1) : new Integer(n + 1);
            this.connTracker.put(this.entity, n);
            this.printOut("DEBUG : OBTAIN : debug conn tracker is " + this.connTracker.toString());
        }
        string2 = JCO.getClientPoolManager().getPool(this.myPool);
        if (string2 != null) {
            this.printOut("Pool stats : Num Used : " + string2.getNumUsed() + ", Num waiting threads : " + string2.getNumWaitingThreads() + ", Max used : " + string2.getMaxUsed());
        }
        return client;
    }

    public void createPool() {
        JCO.PoolManager poolManager = null;
        JCO.Pool pool = null;
        for (int i = 0; i < this.instanceHostList.size(); ++i) {
            this.poolProperties = new Properties();
            this.poolProperties.setProperty("jco.client.client", this.client);
            this.poolProperties.setProperty("jco.client.user", this.sapuser);
            this.poolProperties.setProperty("jco.client.passwd", this.password);
            this.poolProperties.setProperty("jco.client.lang", "en");
            String string = this.instanceHostList.get(i).toString();
            String string2 = string.substring(0, string.indexOf("_"));
            String string3 = string.substring(string.indexOf("_") + 1, string.length());
            this.printOut("DEBUG : " + this.entity + " System details >>> Host " + string3 + ", instance no " + string2);
            this.poolProperties.setProperty("jco.client.sysnr", string2);
            this.poolProperties.setProperty("jco.client.ashost", string3);
            this.myPool = this.hostName + ":" + this.portNo + "_" + string + "_" + System.currentTimeMillis();
            this.printOut("INFO : Getting pool details for " + this.myPool);
            try {
                poolManager = JCO.getClientPoolManager();
            }
            catch (Exception exception) {
                this.printOut("Exception while getting pool manager : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "Exception while getting pool manager : " + exception.toString());
                exception.printStackTrace();
            }
            pool = poolManager.getPool(this.myPool);
            if (pool == null) {
                this.printOut("DEBUG : No conn pool found for " + this.myPool + ", so creating pool");
                JCO.addClientPool((String)this.myPool, (int)2, (Properties)this.poolProperties);
                pool = JCO.getClientPoolManager().getPool(this.myPool);
                pool.setConnectionTimeout(5000L);
                pool.setMaxConnections(2);
                pool.setMaxWaitTime(500L);
                pool.setTimeoutCheckPeriod(5000L);
                pool.setMaxPoolSize(10);
                this.repository[i] = JCO.createRepository((String)this.myPool, (String)this.myPool);
                this.printOut("DEBUG : Connection pool is created");
            } else {
                this.printOut("DEBUG : conn pool found for " + this.myPool);
            }
            this.poolsTable.put(this.instanceHostList.get(i), this.myPool);
        }
        this.printOut("DEBUG : Total no of connection pools  created are = " + Arrays.asList(poolManager.getPoolNames()));
    }

    private ArrayList getInstancesList() {
        JCO.Client client = null;
        try {
            client = this.getConnection();
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
            this.releaseClient(client);
            return null;
        }
        JCO.Function function = null;
        function = this.createFunction("TH_SERVER_LIST");
        if (function == null) {
            this.releaseClient(client);
            return null;
        }
        long l = System.currentTimeMillis();
        try {
            this.executeFunction(function, client, false);
        }
        catch (Exception exception) {
            this.printOut("Error : " + this.entity + "Exception while executing TH_SERVER_LIST : " + exception.toString());
            this.logToErrorFile("ERROR : ", this.entity, "Exception while executing TH_SERVER_LIST : " + exception.toString());
            this.releaseClient(client);
            return null;
        }
        this.printOut("DEBUG : " + this.entity + "TH_SERVER_LIST successfully executed in " + (System.currentTimeMillis() - l) + " ms.");
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        JCO.Table table = null;
        try {
            table = function.getTableParameterList().getTable("LIST");
        }
        catch (Exception exception) {
            this.printOut("ERROR : " + this.entity + "Exception while trying to get LIST table. : " + exception.toString() + ". Trying LIST_IPV6 table instead");
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to get LIST table. : " + exception.toString() + ". Trying LIST_IPV6 table instead");
            bl = true;
        }
        if (table != null && table.getNumRows() == 0) {
            this.printOut("ERROR : main LIST table entity while trying to get instance list. Trying LIST_IPV6 table instead");
            this.logToErrorFile("ERROR", this.entity, "main LIST table entity while trying to get instance list. Trying LIST_IPV6 table instead");
            bl = true;
        }
        if (bl) {
            this.printOut("ERROR : " + this.entity + "Trying LIST_IPV6 table instead");
            try {
                table = function.getTableParameterList().getTable("LIST_IPV6");
                bl = true;
            }
            catch (Exception exception) {
                this.printOut("ERROR : " + this.entity + "Exception while trying to get LIST_IPV6 table too. : " + exception.toString() + ". Could not find instances");
                this.logToErrorFile("ERROR", this.entity, "Exception while trying to get LIST_IPV6 table too. : " + exception.toString() + ". Could not find instances");
                this.releaseClient(client);
                return null;
            }
        }
        if (table.getNumRows() == 0) {
            this.printOut("ERROR: list table is still empty. Could not discover instances");
            this.logToErrorFile("ERROR", this.entity, "list table is still empty. Could not discover instances");
            this.releaseClient(client);
        }
        for (int i = 0; i < table.getNumRows(); ++i) {
            table.setRow(i);
            String string = table.getString("SERVNO");
            int n = Integer.parseInt(string, 16);
            string = String.valueOf(n);
            String string2 = null;
            string2 = bl ? table.getString("HOSTADDR_V4_STR") : table.getString("HOST");
            string = string.substring(string.length() - 2, string.length());
            string = string + "_" + string2;
            if (string == null || string.trim().length() == 0) {
                this.printOut("ERROR : " + this.entity + " Instance no is null or empty ");
                this.logToErrorFile("ERROR : ", this.entity, "Instance no is null or empty");
            }
            arrayList.add(string);
        }
        this.releaseClient(client);
        if (arrayList.size() == 0) {
            this.printOut("Could not find rest of the instances, if any. Using only the instance configured for the test");
            arrayList.add(this.sysnr + "_" + this.appSrvr);
        }
        this.printOut("Final discovered instances list is : " + arrayList);
        return arrayList;
    }

    private ArrayList ddLineToArrayList(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, fieldSep);
        String string2 = stringTokenizer.nextToken();
        arrayList.add(string2);
        double d = Double.parseDouble(stringTokenizer.nextToken());
        arrayList.add(new Double(d));
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        arrayList.add(new Double(d2));
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            arrayList.add(string3);
        }
        return arrayList;
    }

    public String getStatMapping(String string) {
        if (string.equals(max_concurrent1)) {
            return "connected";
        }
        return "pooled";
    }

    public void computeMeasures(Hashtable hashtable) {
        this.freeTest();
        this.getWPInfo();
    }

    public void freeTest() {
        this.jco2MeasureHashtable = new Hashtable();
    }

    public Hashtable getMeasureHashtable() {
        if (this.jco2MeasureHashtable != null && this.jco2MeasureHashtable.size() > 0) {
            return this.jco2MeasureHashtable;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        AsSysWorkJco2Test asSysWorkJco2Test = new AsSysWorkJco2Test(stringArray);
        asSysWorkJco2Test.computeMeasures(null);
    }

    static {
        WPTypExpansionTbl.put("BGD", "Background");
        WPTypExpansionTbl.put("BTC", "Background");
        WPTypExpansionTbl.put("DIA", "Dialog");
        WPTypExpansionTbl.put("ENQ", "Enqueue");
        WPTypExpansionTbl.put("NOWP", "Dispatcher");
        WPTypExpansionTbl.put("SPO", "Spool");
        WPTypExpansionTbl.put("UP2", "Update 2");
        WPTypExpansionTbl.put("UPD", "Update");
    }
}

