/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ApacheVirtualHostTest_cf
extends GenericTest {
    String configFile = "";
    ApacheParser ap = null;

    public ApacheVirtualHostTest_cf(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.configFile = this.getValueForParam("ApacheConfig_File");
        this.ap = new ApacheParser(this.configFile);
        this.setConfigInfoTestFlag(true);
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        ArrayList arrayList = new ArrayList();
        if (!this.meAgentless) {
            this.ap.parseConfig();
            hashtable2 = this.ap.getAllVirtualHostInfo();
        } else if (this.isPerfmon) {
            this.ap = new ApacheParser(this.configFile, "perfmon", this.targetHost);
            this.ap.parseConfig();
            hashtable2 = this.ap.getAllVirtualHostInfo();
        } else if (this.isSSH || this.isRexec) {
            if (this.aluser.equalsIgnoreCase("NONE") || this.alpassword.equalsIgnoreCase("none")) {
                this.errorMsg = "Apache Server info is configured in Agentless and os/aluser can't be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.configError = true;
                return;
            }
            Object object = "";
            if (this.isSSH) {
                object = "ssh";
            } else if (this.isRexec) {
                object = "rexec";
            }
            this.ap = new ApacheParser(this.configFile, (String)object, this.targetHost, this.sshPort, this.aluser, this.alpassword);
            this.ap.parseConfig();
            hashtable2 = this.ap.getAllVirtualHostInfo();
        }
        if (hashtable2 == null && hashtable2.isEmpty()) {
            this.configError = true;
            return;
        }
        for (String string : hashtable2.keySet()) {
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string);
            Iterator iterator = hashtable3.keySet().iterator();
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                while (iterator.hasNext()) {
                    String string3 = ((String)iterator.next()).trim();
                    if (string3.startsWith("<")) continue;
                    String string4 = string2.trim() + "~M~" + string3;
                    arrayList = (ArrayList)hashtable3.get(string3);
                    this.addNewMeasure(string4, arrayList);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        ApacheVirtualHostTest_cf apacheVirtualHostTest_cf = new ApacheVirtualHostTest_cf(stringArray);
        apacheVirtualHostTest_cf.computeMeasures(new Hashtable());
    }
}

