/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class AWSMSKValidator
extends EgServerValidator {
    protected String aws_cluster_name = "";
    protected String aws_access_key_id = null;
    protected String aws_secret_access_key = null;
    protected String aws_default_region = null;
    protected final String aws_default_output = "json";
    protected String reportingName = null;
    protected static final String HYPHEN = "-";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final String COLONS = ":";
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String BASIC = "Basic" + SPACE;
    protected static long collectionTimeout = 120L;
    String logMessage = "";
    String strLogSizeLimitInMB = null;
    protected static final String TEST_NAME = "AWSMSKBaseV";
    protected static final String LOG_FILE_NAME = "AWSMSKBaseVLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "AWSMSKBaseVLogSizeLimitInMB";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "AWSMSKBaseVLog";
    protected static final String AMAZON_MSK_BASE_CLI_EXECUTOR_CLASS = SPACE + "AWSMSKValidatorCLIExecuter" + SPACE;
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 5.0;
    protected double debugLogSizeLimitInMB = 5242880.0;
    private static final String COMMAND_SEPARATOR = " && ";
    protected int cmd_time_out = 60;
    boolean isWindowsOS = false;
    boolean isLinuxOS = false;
    protected static String AWS_MSK_CREDENTIALS = "";
    protected static final String TO_REMOVE_AWS_MSK_PORTAL_COMMAND = "aws configure set aws_access_key_id " + null + " && " + "aws configure set aws_secret_access_key " + null + " && " + "aws configure set default.region " + null + " && " + "aws configure set default.output " + null;
    protected static final String AWS_KAFKA_COMMAND = "aws kafka ";
    protected static final String LIST_CLUSTERS_COMMAND = "aws kafka list-clusters";
    String protoType = "";
    boolean deep_debug = false;
    String port = null;
    String tmp_timeout = null;
    String entity = this.getClass().getName();
    EgUtilities egutil = EgUtilities.createInstance();
    String javaOptions = "java";
    String heapDumpPath = null;
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public boolean isFromManager = false;
    String className = this.getClass().getName();

    public AWSMSKValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.substring(0, string2.indexOf(COLONS));
                String string4 = string2.substring(string2.indexOf(COLONS) + 1);
                if ((string3 = string3.trim()) != null && string3.equalsIgnoreCase("-host")) {
                    this.aws_cluster_name = string4.trim();
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-aws_access_key_id")) {
                    this.aws_access_key_id = string4.trim();
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-aws_secret_access_key")) {
                    if ((string4 = EgCrypt.decrypt(string4)).indexOf("~EG~") != -1) {
                        string4 = string4.substring(0, string4.indexOf("~EG~"));
                    }
                    this.aws_secret_access_key = string4;
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-aws_default_region")) {
                    this.aws_default_region = string4.trim();
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string4.trim();
                    continue;
                }
                if (string3 == null || !string3.equalsIgnoreCase("-timeout")) continue;
                String string5 = string4.trim();
                if (string5 != null && !string5.equals("120")) {
                    try {
                        collectionTimeout = Integer.parseInt(string5);
                        collectionTimeout *= 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printOut(string + "Could not parse specified timeout " + string5 + ". Using 120 seconds");
                        collectionTimeout = 120000L;
                    }
                    continue;
                }
                collectionTimeout = 120000L;
            }
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
            this.strLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
            if (this.strLogSizeLimitInMB != null && this.strLogSizeLimitInMB.length() > 0) {
                this.strLogSizeLimitInMB = this.strLogSizeLimitInMB.trim();
                try {
                    this.debugLogSizeLimitInMB = Double.parseDouble(this.strLogSizeLimitInMB);
                    this.debugLogSizeLimitInMB *= 1048576.0;
                    this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                }
                catch (Exception exception) {
                    this.debugLogSizeLimitInMB = 5242880.0;
                }
            } else {
                this.debugLogSizeLimitInMB = 5242880.0;
            }
            AWS_MSK_CREDENTIALS = "aws configure set aws_access_key_id " + this.aws_access_key_id + COMMAND_SEPARATOR + "aws configure set aws_secret_access_key " + this.aws_secret_access_key + COMMAND_SEPARATOR + "aws configure set default.region " + this.aws_default_region + COMMAND_SEPARATOR + "aws configure set default.output " + "json";
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
        this.entity = this.className;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "*******************************************************************************");
        this.printOut(string + "Amazon MSK Cluster name :" + this.aws_cluster_name);
        this.printOut(string + "Amazon MSK access ID    :" + this.aws_access_key_id);
        this.printOut(string + "Amazon MSK access key   :**********");
        this.printOut(string + "Amazon MSK region       :" + this.aws_default_region);
        this.printOut(string + "Amazon MSK output type  :" + "json");
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        if (this.isStringNull(this.aws_access_key_id) || this.isStringNull(this.aws_secret_access_key) || this.isStringNull(this.aws_cluster_name)) {
            this.validationMsgs.add("Amazon MSK Credential$#$Access denied. Please provide valid credentials");
            this.validationMsgs.add("Amazon MSK Connectivity$#$NA");
            this.validationMsgs.add("Amazon MSK Cluster$#$NA");
        } else {
            int n = this.collectDataFromAWSCLIConnect();
            this.printOut(string + "Connectivity status" + n);
            if (n == 2) {
                this.validationMsgs.add("Amazon MSK Credential$#$OK");
                this.validationMsgs.add("Amazon MSK Connectivity$#$OK");
                this.validationMsgs.add("Amazon MSK Cluster$#$OK");
            } else if (n == 1) {
                this.validationMsgs.add("Amazon MSK Credential$#$OK");
                this.validationMsgs.add("Amazon MSK Connectivity$#$OK");
                this.validationMsgs.add("Amazon MSK Cluster$#$Please provide valid cluster name.");
            } else {
                this.validationMsgs.add("Amazon MSK Credential$#$Access denied. Please provide valid credentials");
                this.validationMsgs.add("Amazon MSK Connectivity$#$NA");
                this.validationMsgs.add("Amazon MSK Cluster$#$NA");
            }
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    public int collectDataFromAWSCLIConnect() {
        String string;
        String string2;
        String string3;
        Object object;
        String string4 = "collectDataFromAWSCLIConnect";
        string4 = this.methodNameTemplate(string4);
        int n = 0;
        this.heapDumpPath = null;
        this.javaOptions = "java";
        try {
            object = System.getProperty("os.name");
            string3 = System.getProperty("java.version");
            string2 = System.getProperty("os.arch");
            if (string3.compareTo("10.0") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                }
                this.printOut(string4 + "JavaVersion 10.0 HeapDumpPath :" + this.heapDumpPath);
            } else if (string3.compareTo("1.7") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                }
                this.printOut(string4 + "JavaVersion 1.7  HeapDumpPath :" + this.heapDumpPath);
            } else if (string3.compareTo("1.6") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL";
                }
                this.printOut(string4 + "JavaVersion 1.6 HeapDumpPath :" + this.heapDumpPath);
            }
            if (this.heapDumpPath != null) {
                this.printOut(string4 + "HeapDumpPath :" + this.heapDumpPath);
                this.javaOptions = this.javaOptions + " " + this.heapDumpPath;
                this.printOut(string4 + "HeapDumpPath :" + this.heapDumpPath + " java options : " + this.javaOptions);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string4 + "Error while set the heapDumpPath to call rexec process  :", exception);
        }
        this.printOut(string4 + "JavaOptions " + this.javaOptions);
        object = new ArrayList();
        string3 = " -aws_cluster_name " + this.aws_cluster_name + " -port " + this.port + " -aws_access_key_id " + this.aws_access_key_id + " -aws_secret_access_key " + this.aws_secret_access_key + " -aws_default_region " + this.aws_default_region + " -aws_default_output " + "json" + " -timeout " + collectionTimeout + " -reportingName " + this.reportingName + " -entity " + this.entity + " -log_size " + this.debugLogSizeLimitInMB;
        string2 = "";
        String string5 = "";
        boolean bl = false;
        String string6 = "";
        try {
            boolean bl2;
            string = System.getProperty("os.name").toLowerCase();
            boolean bl3 = bl2 = System.getProperty("java.version").compareTo("1.5") > 0;
            if (string.indexOf("win") >= 0) {
                bl = true;
            }
            if (bl) {
                string5 = EgInstallInfo.getInstallDir() + "\\jre\\bin\\";
                string6 = EgInstallInfo.getInstallDir() + "\\lib\\eg_agent.jar;" + EgInstallInfo.getInstallDir() + "\\lib\\eg_util.jar";
                string2 = bl2 ? "cmd.exe /c " + string5 + this.javaOptions + " -client -cp \"" + string6 + "\"" + AMAZON_MSK_BASE_CLI_EXECUTOR_CLASS + string3 : "cmd.exe /c " + string5 + this.javaOptions + " -cp \"" + string6 + "\"" + AMAZON_MSK_BASE_CLI_EXECUTOR_CLASS + string3;
            } else if (string.indexOf("aix") >= 0) {
                string6 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar";
                string2 = "/opt/egurkha/jre/bin/" + this.javaOptions + " -cp " + string6 + AMAZON_MSK_BASE_CLI_EXECUTOR_CLASS + string3;
            } else if (bl2) {
                string6 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar";
                string2 = "/opt/egurkha/jre/bin/" + this.javaOptions + " -client -cp " + string6 + AMAZON_MSK_BASE_CLI_EXECUTOR_CLASS + string3;
            } else {
                string6 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar";
                string2 = "/opt/egurkha/jre/bin/" + this.javaOptions + " -cp " + string6 + AMAZON_MSK_BASE_CLI_EXECUTOR_CLASS + string3;
            }
            this.printOut(string4 + "Inside execute program " + string2);
            this.printOut(string4 + "Going to call getExecOutputLines to execute" + AMAZON_MSK_BASE_CLI_EXECUTOR_CLASS);
            ArrayList arrayList = this.egutil.getExecOutputLines(string2);
            this.printOut(string4 + "Completed  getExecOutputLines method call for" + AMAZON_MSK_BASE_CLI_EXECUTOR_CLASS);
            if (arrayList == null || arrayList.size() < 2) {
                this.logMessage = string4 + "Rexec process returned null or some exception " + arrayList;
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
            }
            object = (ArrayList)arrayList.get(0);
            if (arrayList != null && !arrayList.isEmpty() && arrayList.size() > 0) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2 = (ArrayList)arrayList.get(1);
                if (arrayList2 != null && !arrayList2.isEmpty() && arrayList2.size() > 0) {
                    this.logMessage = string4 + "Rexec process some exception : errArrayList  " + arrayList2;
                    this.printOut(this.logMessage);
                    this.putWarningMessageToLogfile(this.logMessage);
                    this.logMessage = "";
                }
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string4 + "Error while rexec process :", exception);
        }
        this.printOut(string4 + "Output ArrayList  :" + object);
        if (object != null && !((ArrayList)object).isEmpty() && ((ArrayList)object).size() > 0) {
            try {
                string = ((ArrayList)object).get(0).toString();
                this.printOut(string4 + "Data :" + string);
                n = string.equalsIgnoreCase("2") ? 2 : (string.equalsIgnoreCase("1") ? 1 : (string.equalsIgnoreCase("0") ? 0 : 0));
            }
            catch (Exception exception) {
                this.printOutStackTrace(string4 + "", exception);
                n = 0;
            }
        }
        this.printOut(string4 + "Connectivity is :" + n);
        return n;
    }

    protected boolean isStringNull(String string) {
        return string == "" || string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE);
    }

    protected boolean isArrayListNull(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty() || arrayList.size() == 0;
    }

    protected boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() == 0;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            AWSMSKValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AWSMSKValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AWSMSKValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AWSMSKValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            AWSMSKValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        AWSMSKValidator aWSMSKValidator = new AWSMSKValidator(stringArray, new Boolean(false));
        aWSMSKValidator.getValidationMsgs();
    }
}

