/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectList;
import com.ibm.as400.access.Subsystem;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AS400SubSystemTest
extends GenericTest {
    private String userID = null;
    private String password = null;
    private String system = null;
    private String activeStr = "*ACTIVE";
    private String inActiveStr = "*INACTIVE";
    public boolean isActiveDD = false;
    public ArrayList ddActiveList = null;
    public ArrayList ddInActiveList = null;

    public AS400SubSystemTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        String string = this.getValueForParam("Show_active_DD");
        this.isActiveDD = string != null && !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
        this.isNewDynamicInfoTest = true;
        this.setMeasureCount(this.measureCount);
    }

    public void freeTest() {
        this.ddActiveList = new ArrayList();
        this.ddInActiveList = new ArrayList();
    }

    public static void main(String[] stringArray) {
        AS400SubSystemTest aS400SubSystemTest = new AS400SubSystemTest(stringArray);
        aS400SubSystemTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        block16: {
            String string = "";
            double d = 0.0;
            ArrayList<String> arrayList = new ArrayList<String>();
            AS400 aS400 = null;
            try {
                Object object;
                int n;
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                if (aS400 == null) {
                    return;
                }
                Subsystem[] subsystemArray = this.listAllSubsystems(aS400);
                int n2 = subsystemArray.length;
                if (n2 < 0) {
                    aS400.disconnectService(2);
                    return;
                }
                this.ddActiveList = new ArrayList();
                this.ddInActiveList = new ArrayList();
                for (n = 0; n < n2; ++n) {
                    double d2;
                    String string2;
                    Subsystem subsystem = subsystemArray[n];
                    if (subsystem == null) continue;
                    object = subsystem.getName();
                    object = ((String)object).trim();
                    if (debug) {
                        System.out.println("[" + this.entity + "] name-->" + (String)object);
                    }
                    if (!subsystem.exists()) {
                        System.out.println("[" + this.entity + "] No such subsystem: " + subsystem.getPath());
                        continue;
                    }
                    subsystem.refresh();
                    String string3 = subsystem.getName();
                    if (string3 == null) {
                        System.out.println("[" + this.entity + "] subsystem name does not exists !");
                        continue;
                    }
                    String string4 = subsystem.getStatus();
                    subsystem.getMonitorJob();
                    if (string4 == null) {
                        System.out.println("[" + this.entity + "] subsystem status does not exists for subsystem name =>" + string3);
                        continue;
                    }
                    if (string4.equalsIgnoreCase(this.activeStr)) {
                        d = subsystem.getCurrentActiveJobs();
                        arrayList = new ArrayList();
                        arrayList.add(string3);
                        arrayList.add("" + (long)d);
                        string2 = subsystem.getLibrary();
                        arrayList.add(string2);
                        d2 = subsystem.getMaximumActiveJobs();
                        if (d2 == -1.0) {
                            arrayList.add(new String("Infinity"));
                        } else {
                            arrayList.add(new Double(d2).toString());
                        }
                        arrayList.add(string4);
                        this.ddActiveList.add(arrayList);
                    }
                    if (!string4.equalsIgnoreCase(this.inActiveStr)) continue;
                    arrayList = new ArrayList();
                    arrayList.add(string3);
                    d = subsystem.getCurrentActiveJobs();
                    arrayList.add("" + d);
                    string2 = subsystem.getLibrary();
                    arrayList.add(string2);
                    d2 = subsystem.getMaximumActiveJobs();
                    if (d2 == -1.0) {
                        arrayList.add(new String("Infinity"));
                    } else {
                        arrayList.add(new Double(d2).toString());
                    }
                    arrayList.add(string4);
                    this.ddInActiveList.add(arrayList);
                }
                if (debug) {
                    System.out.println("AS400SubSystemTest ddActiveList =" + this.ddActiveList);
                    System.out.println("AS400SubSystemTest ddInActiveList =" + this.ddInActiveList);
                }
                n = this.ddActiveList.size();
                int n3 = this.ddInActiveList.size();
                object = new ArrayList();
                ((ArrayList)object).add(new Double(n));
                ((ArrayList)object).add(new Double(n3));
                if (debug) {
                    System.out.println("AS400SubSystemTest MeasureList =" + object);
                }
                this.addNewMeasure((ArrayList)object);
                aS400.disconnectAllServices();
                aS400 = null;
            }
            catch (Exception exception) {
                String string5 = EgInstallInfo.getStackTraceAsString(exception);
                this.logToErrorFile("ERROR", this.entity, string5);
                if (aS400 == null) break block16;
                aS400.disconnectAllServices();
                aS400 = null;
            }
        }
    }

    public Subsystem[] listAllSubsystems(AS400 aS400) throws Exception {
        Vector<Subsystem> vector = new Vector<Subsystem>(20);
        ObjectList objectList = new ObjectList(aS400, "*ALL", "*ALL", "*SBSD");
        objectList.clearObjectAttributesToRetrieve();
        int[] nArray = new int[]{10000, 10001, 10002, 701, 304};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            objectList.addObjectAttributeToRetrieve(n);
        }
        System.out.println(objectList.getLength());
        Enumeration enumeration = objectList.getObjects();
        while (enumeration.hasMoreElements()) {
            ObjectDescription objectDescription = (ObjectDescription)enumeration.nextElement();
            byte by = objectDescription.getStatus();
            if (debug) {
                System.out.println("subsystem-->" + objectDescription.getName());
                System.out.println("b1-->" + by);
            }
            if (by == -63) {
                System.err.println("[" + this.entity + "]STATUS_NO_AUTHORITY -- > " + objectDescription.getName() + " --> " + objectDescription.getLibrary() + " --> " + objectDescription.getType() + " --> " + objectDescription.getPath());
                continue;
            }
            if (by == -60) {
                System.err.println("[" + this.entity + "]STATUS_DAMAGED -- > " + objectDescription.getName() + " --> " + objectDescription.getLibrary() + " --> " + objectDescription.getType() + " --> " + objectDescription.getPath());
                continue;
            }
            if (by == -45) {
                System.err.println("[" + this.entity + "]STATUS_LOCKED -- > " + objectDescription.getName() + " --> " + objectDescription.getLibrary() + " --> " + objectDescription.getType() + " --> " + objectDescription.getPath());
                continue;
            }
            if (by == -41) {
                System.err.println("[" + this.entity + "]STATUS_PARTIALLY_DAMAGED -- > " + objectDescription.getName() + " --> " + objectDescription.getLibrary() + " --> " + objectDescription.getType() + " --> " + objectDescription.getPath());
                continue;
            }
            System.out.println(objectDescription.getName() + " --> " + objectDescription.getLibrary() + " --> " + objectDescription.getType() + " --> " + objectDescription.getPath());
            Subsystem subsystem = new Subsystem(aS400, objectDescription.getPath());
            vector.addElement(subsystem);
        }
        Subsystem[] subsystemArray = new Subsystem[vector.size()];
        vector.toArray(subsystemArray);
        return subsystemArray;
    }
}

