/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.database.jdbc.Column;
import java.sql.SQLException;

public class JDBCColumnMetaData {
    public static int getPrecision(Column column) {
        int n = 0;
        switch (0xFFFE & column.getType()) {
            case 396: 
            case 448: 
            case 452: 
            case 456: 
            case 464: 
            case 468: 
            case 472: 
            case 908: 
            case 912: {
                n = column.getScale();
                break;
            }
            case 480: {
                if (column.getLength() == 4) {
                    return 24;
                }
                return 53;
            }
            case 404: 
            case 408: {
                n = column.getLength() - 4;
                break;
            }
            case 412: {
                n = (column.getLength() - 4) / 2;
                break;
            }
            case 496: {
                n = 10;
                break;
            }
            case 500: {
                n = 5;
                break;
            }
            case 384: {
                n = 10;
                break;
            }
            case 388: {
                n = 8;
                break;
            }
            case 392: {
                n = 26;
                break;
            }
            case 960: 
            case 964: 
            case 968: {
                n = column.getLobMaxSize();
                break;
            }
            case 988: 
            case 2452: {
                n = Integer.MAX_VALUE;
                break;
            }
            default: {
                n = column.getPrecision();
            }
        }
        return n;
    }

    public static int getScale(Column column) throws SQLException {
        switch (column.getSQLType()) {
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 91: 
            case 92: 
            case 464: 
            case 468: 
            case 472: {
                return 0;
            }
            case 93: {
                return 6;
            }
        }
        return column.getScale();
    }
}

