/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.StringUtil;

class MOFFormatter
implements Serializable {
    static final long serialVersionUID = 200L;
    private static final String INDENT = "    ";
    private static final char DELIMITER = ',';
    private static final char SINGLEQUOTE = '\'';
    private static final char QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char COLON = ':';
    private static final char NEWLINE = '\n';
    private static final String ANY = "any";
    private static final String AS = "as";
    private static final String ASSOCIATION = "association";
    private static final String CLASS = "class";
    private static final String DISABLEOVERRIDE = "disableoverride";
    private static final String DT_BOOL = "boolean";
    private static final String DT_CHAR16 = "char16";
    private static final String DT_DATETIME = "datetime";
    private static final String DT_REAL32 = "real32";
    private static final String DT_REAL64 = "real64";
    private static final String DT_SINT16 = "sint16";
    private static final String DT_SINT32 = "sint32";
    private static final String DT_SINT64 = "sint64";
    private static final String DT_SINT8 = "sint8";
    private static final String DT_STR = "string";
    private static final String DT_UINT16 = "uint16";
    private static final String DT_UINT32 = "uint32";
    private static final String DT_UINT64 = "uint64";
    private static final String DT_UINT8 = "uint8";
    private static final String ENABLEOVERRIDE = "enableoverride";
    private static final String FLAVOR = "Flavor";
    private static final String INDICATION = "indication";
    private static final String INSTANCE = "instance";
    private static final String METHOD = "method";
    private static final String NULL = "null";
    private static final String OF = "of";
    private static final String PARAMETER = "parameter";
    private static final String PROPERTY = "property";
    private static final String QUALIFIER = "Qualifier";
    private static final String REF = "REF";
    private static final String REFERENCE = "reference";
    private static final String RESTRICTED = "restricted";
    private static final String SCHEMA = "schema";
    private static final String SCOPE = "Scope";
    private static final String TOSUBCLASS = "tosubclass";
    private static final String TRANSLATABLE = "translatable";
    private boolean cimclass = true;

    public String toString(Object o) {
        String mof = o instanceof CIMInstance ? this.cimInstance((CIMInstance)o) : (o instanceof CIMClass ? this.cimClass((CIMClass)o) : (o instanceof CIMValue ? this.cimValue((CIMValue)o) : (o instanceof CIMQualifierType ? this.cimQualifierType((CIMQualifierType)o) : (o instanceof CIMQualifier ? this.cimQualifier((CIMQualifier)o) : (o instanceof CIMDateTime ? this.cimDateTime((CIMDateTime)o) : (o instanceof CIMArgument ? this.cimArgument((CIMArgument)o) : (o instanceof CIMProperty ? this.cimProperty((CIMProperty)o) : (o instanceof CIMScope ? this.cimScope((CIMScope)o) : (o instanceof CIMFlavor ? this.cimFlavor((CIMFlavor)o) : (o instanceof CIMDataType ? this.cimDataType((CIMDataType)o) : (o instanceof CIMMethod ? this.cimMethod((CIMMethod)o) : (o instanceof CIMParameter ? this.cimParameter((CIMParameter)o) : String.valueOf(o)))))))))))));
        return mof;
    }

    public String arrayToMOFString(Object[] objArray, boolean b) {
        return this.arrayToMOFString(objArray, INDENT, b, false, true);
    }

    public String arrayToMOFString(Object[] objArray, String indent, boolean bracketed, boolean delimited, boolean lf) {
        StringBuffer str = new StringBuffer();
        if (objArray != null && objArray.length > 0) {
            if (bracketed) {
                str.append(indent);
                str.append('[');
            }
            for (int i = 0; i < objArray.length; ++i) {
                Object obj;
                if (i > 0) {
                    if (delimited) {
                        str.append(',');
                    }
                    if (lf) {
                        str.append('\n');
                        str.append(indent);
                    }
                    str.append(' ');
                }
                if ((obj = objArray[i]) instanceof String || obj instanceof CIMObjectPath) {
                    str.append('\"');
                    str.append(StringUtil.escape(obj.toString()));
                    str.append('\"');
                    continue;
                }
                if (obj instanceof Character) {
                    str.append('\'');
                    str.append(StringUtil.escape(obj.toString()));
                    str.append('\'');
                    continue;
                }
                str.append(this.toString(obj));
            }
            if (bracketed) {
                if (lf) {
                    str.append('\n');
                    str.append(indent);
                }
                str.append("]");
                if (lf) {
                    str.append('\n');
                }
            }
        }
        return str.toString();
    }

    public String vectorToMOFString(Vector v) {
        return this.vectorToMOFString(v, INDENT, false, false, true);
    }

    public String vectorToMOFString(Vector vector, boolean bracketed, boolean delimited) {
        return this.vectorToMOFString(vector, INDENT, bracketed, delimited, true);
    }

    public String vectorToMOFString(Vector v, String indent, boolean bracketed, boolean delimited, boolean lf) {
        return this.arrayToMOFString(v.toArray(), indent, bracketed, delimited, lf);
    }

    public String wrapText(String textString, int numColumns) {
        StringTokenizer stringTokenizer = new StringTokenizer(textString, " \t\n", true);
        StringBuffer buff = new StringBuffer();
        int lineLength = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String word = stringTokenizer.nextToken();
            int length = word.length();
            if (length == 1 && word.charAt(0) == '\n') {
                lineLength = 0;
                continue;
            }
            if (lineLength + length > numColumns) {
                buff.append('\n');
                lineLength = 0;
                continue;
            }
            if (length == 1 && word.charAt(0) == ' ' && buff.charAt(buff.length() - 1) == '\n') continue;
            buff.append(word);
            lineLength += word.length();
        }
        return buff.toString();
    }

    private Vector sortQ(Vector in) {
        Vector<CIMQualifier> out = new Vector<CIMQualifier>();
        Enumeration e = in.elements();
        while (e.hasMoreElements()) {
            CIMQualifier cqt = (CIMQualifier)e.nextElement();
            if (cqt.getName().equalsIgnoreCase("Association")) {
                out.insertElementAt(cqt, 0);
                continue;
            }
            if (cqt.getName().equalsIgnoreCase("Indication")) {
                out.insertElementAt(cqt, 0);
                continue;
            }
            out.add(cqt);
        }
        return out;
    }

    public String cimClass(CIMClass cc) {
        Vector methods;
        StringBuffer buffer = new StringBuffer();
        Vector qualifiers = this.sortQ(cc.getQualifiers());
        buffer.append(this.vectorToMOFString(qualifiers, true, true));
        buffer.append(CLASS);
        buffer.append(' ');
        buffer.append(cc.getName());
        buffer.append(' ');
        if (cc.getSuperClass().length() > 0) {
            buffer.append(':');
            buffer.append(' ');
            buffer.append(cc.getSuperClass());
            buffer.append(' ');
        }
        buffer.append("{");
        buffer.append('\n');
        Vector properties = cc.getProperties();
        if (properties.size() > 0) {
            buffer.append(this.vectorToMOFString(properties, "", false, false, true));
            buffer.append('\n');
        }
        if ((methods = cc.getMethods()).size() > 0) {
            buffer.append(this.vectorToMOFString(methods, "", false, false, true));
            buffer.append('\n');
        }
        buffer.append("};");
        return buffer.toString();
    }

    public String cimValue(CIMValue cv) {
        StringBuffer buffer = new StringBuffer();
        Object o = cv.getValue();
        if (o != null) {
            if (cv.getType() != null && cv.getType().isArrayType()) {
                buffer.append(this.vectorToMOFString((Vector)o, "", false, true, false));
            } else if (o instanceof String || o instanceof CIMObjectPath) {
                buffer.append('\"');
                buffer.append(StringUtil.escape(o.toString()));
                buffer.append('\"');
            } else if (o instanceof Character) {
                buffer.append('\'');
                buffer.append(StringUtil.escape(o.toString()));
                buffer.append('\'');
            } else {
                buffer.append(o);
            }
        } else {
            buffer.append(NULL);
        }
        return buffer.toString();
    }

    public String cimQualifierType(CIMQualifierType cqt) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(QUALIFIER);
        buffer.append(' ');
        buffer.append(cqt.getName());
        buffer.append(" : ");
        buffer.append(cqt.getType());
        if (cqt.getType() != null && cqt.getType().isArrayType()) {
            buffer.append("[]");
        } else {
            buffer.append(" = ");
            buffer.append(cqt.getDefaultValue());
        }
        buffer.append(',');
        buffer.append('\n');
        if (!cqt.getScope().isEmpty()) {
            buffer.append(INDENT);
            buffer.append(SCOPE);
            buffer.append('(');
            buffer.append(this.vectorToMOFString(cqt.getScope(), "", false, true, false));
            buffer.append(')');
        }
        if (!cqt.getFlavor().isEmpty()) {
            buffer.append(',');
            buffer.append('\n');
            buffer.append(INDENT);
            buffer.append(FLAVOR);
            buffer.append('(');
            buffer.append(this.vectorToMOFString(cqt.getFlavor(), "", false, true, false));
            buffer.append(')');
        }
        buffer.append(';');
        return buffer.toString();
    }

    public String cimQualifier(CIMQualifier cq) {
        StringBuffer buffer = new StringBuffer(cq.getName());
        CIMValue value = cq.getValue();
        if (value != null) {
            if (value.getType() != null && value.getType().isArrayType()) {
                buffer.append('{');
                buffer.append(value.toString());
                buffer.append('}');
            } else {
                buffer.append('(');
                buffer.append(value.toString());
                buffer.append(')');
            }
        }
        return buffer.toString();
    }

    public String cimDateTime(CIMDateTime cdt) {
        return "\"" + cdt.getDateTimeString() + "\"";
    }

    public String cimDataType(CIMDataType cdt) {
        switch (cdt.getType()) {
            case 0: {
                return DT_UINT8;
            }
            case 1: {
                return DT_SINT8;
            }
            case 2: {
                return DT_UINT16;
            }
            case 3: {
                return DT_SINT16;
            }
            case 4: {
                return DT_UINT32;
            }
            case 5: {
                return DT_SINT32;
            }
            case 6: {
                return DT_UINT64;
            }
            case 7: {
                return DT_SINT64;
            }
            case 10: {
                return DT_REAL32;
            }
            case 11: {
                return DT_REAL64;
            }
            case 8: {
                return DT_STR;
            }
            case 13: {
                return DT_CHAR16;
            }
            case 12: {
                return DT_DATETIME;
            }
            case 9: {
                return DT_BOOL;
            }
            case 14: {
                return DT_UINT8;
            }
            case 15: {
                return DT_SINT8;
            }
            case 16: {
                return DT_UINT16;
            }
            case 17: {
                return DT_SINT16;
            }
            case 18: {
                return DT_UINT32;
            }
            case 19: {
                return DT_SINT32;
            }
            case 20: {
                return DT_UINT64;
            }
            case 21: {
                return DT_SINT64;
            }
            case 24: {
                return DT_REAL32;
            }
            case 25: {
                return DT_REAL64;
            }
            case 22: {
                return DT_STR;
            }
            case 27: {
                return DT_CHAR16;
            }
            case 26: {
                return DT_DATETIME;
            }
            case 23: {
                return DT_BOOL;
            }
            case 30: {
                return NULL;
            }
            case 28: {
                return cdt.getRefClassName() + " " + REF;
            }
            case 42: {
                return cdt.getRefClassName() + " " + REF;
            }
        }
        return "";
    }

    public String cimFlavor(CIMFlavor cf) {
        switch (cf.getFlavor()) {
            case 0: {
                return ENABLEOVERRIDE;
            }
            case 1: {
                return DISABLEOVERRIDE;
            }
            case 2: {
                return RESTRICTED;
            }
            case 3: {
                return TOSUBCLASS;
            }
            case 4: {
                return TRANSLATABLE;
            }
        }
        return "UNKNOWN";
    }

    public String cimInstance(CIMInstance ci) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(INSTANCE);
        buffer.append(' ');
        buffer.append(OF);
        buffer.append(' ');
        buffer.append(ci.getClassName());
        buffer.append(' ');
        String alias = ci.getAlias();
        if (alias != null && alias.length() > 0) {
            buffer.append(AS);
            buffer.append(' ');
            buffer.append(alias);
            buffer.append(' ');
        }
        buffer.append('{');
        buffer.append('\n');
        Vector properties = ci.getProperties();
        if (properties.size() > 0) {
            this.cimclass = false;
            buffer.append(this.vectorToMOFString(properties, "", false, false, true));
            this.cimclass = true;
            buffer.append('\n');
        }
        buffer.append("};");
        return buffer.toString();
    }

    public String cimMethod(CIMMethod cm) {
        String name = cm.getName();
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.vectorToMOFString(cm.getQualifiers(), true, true));
        buffer.append(INDENT);
        buffer.append(cm.getType());
        buffer.append(' ');
        buffer.append(name);
        buffer.append('(');
        buffer.append(this.vectorToMOFString(cm.getParameters(), "", false, true, false));
        buffer.append(");");
        return buffer.toString();
    }

    public String cimParameter(CIMParameter cp) {
        StringBuffer buffer = new StringBuffer();
        Vector qualifiers = cp.getQualifiers();
        if (qualifiers.size() > 0) {
            buffer.append(this.vectorToMOFString(cp.getQualifiers(), "", true, true, false));
            buffer.append(' ');
        }
        buffer.append(cp.getType());
        buffer.append(' ');
        buffer.append(cp.getName());
        if (cp.getType() != null && cp.getType().isArrayType()) {
            buffer.append("[]");
        }
        return buffer.toString();
    }

    public String cimArgument(CIMArgument ca) {
        StringBuffer buffer = new StringBuffer(ca.getName());
        buffer.append("\n{\n");
        if (ca.getQualifiers() != null) {
            buffer.append(this.vectorToMOFString(ca.getQualifiers(), true, true));
        }
        buffer.append('\n');
        CIMValue value = ca.getValue();
        if (value != null) {
            buffer.append(value);
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    public String cimProperty(CIMProperty cp) {
        String name = cp.getName();
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        CIMDataType cdt = cp.getType();
        buffer.append(this.vectorToMOFString(cp.getQualifiers(), INDENT, true, true, true));
        buffer.append(INDENT);
        if (this.cimclass) {
            buffer.append(this.toString(cdt));
            buffer.append(' ');
        }
        buffer.append(name);
        if (this.cimclass && cdt != null && cdt.isArrayType()) {
            buffer.append("[]");
        }
        if (!this.cimclass || this.cimclass && cp.getValue() != null && !cdt.isReferenceType()) {
            buffer.append(" = ");
            CIMValue value = cp.getValue();
            if (value == null) {
                buffer.append(NULL);
            } else {
                if (value.getType() != null && value.getType().isArrayType()) {
                    buffer.append('{');
                }
                buffer.append(this.cimValue(value));
                if (value.getType() != null && value.getType().isArrayType()) {
                    buffer.append('}');
                }
            }
        }
        buffer.append(";");
        buffer.append('\n');
        return buffer.toString();
    }

    public String cimScope(CIMScope cs) {
        switch (cs.getScope()) {
            case 0: {
                return SCHEMA;
            }
            case 1: {
                return CLASS;
            }
            case 2: {
                return ASSOCIATION;
            }
            case 3: {
                return INDICATION;
            }
            case 4: {
                return PROPERTY;
            }
            case 5: {
                return REFERENCE;
            }
            case 6: {
                return METHOD;
            }
            case 7: {
                return PARAMETER;
            }
            case 8: {
                return ANY;
            }
        }
        return "UNKNOWN";
    }
}

