/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpException;
import com.ireasoning.protocol.snmp.SnmpInt;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpTimeTicks;
import com.ireasoning.protocol.snmp.SnmpUInt;
import com.ireasoning.protocol.snmp.SnmpV1Trap;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.cc;
import java.net.InetAddress;
import java.util.Hashtable;

public abstract class SnmpV2Notification
extends SnmpPdu {
    public static final SnmpOID SYS_UP_TIME_OID = new SnmpOID(".1.3.6.1.2.1.1.3.0");
    public static final SnmpOID SNMP_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.4.1.0");
    public static final SnmpOID SNMP_TRAP_ENTERPRISE_OID = new SnmpOID(".1.3.6.1.6.3.1.1.4.3.0");
    public static final SnmpOID COLD_START_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.1");
    public static final SnmpOID WARM_START_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.2");
    public static final SnmpOID LINK_DOWN_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.3");
    public static final SnmpOID LINK_UP_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.4");
    public static final SnmpOID AUTHENTICATION_FAILURE_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.5");
    public static final SnmpOID EGPNEIGHBOR_LOSS_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.6");
    static final Hashtable u = new Hashtable();
    static final SnmpOID v;

    SnmpV2Notification() {
    }

    public SnmpV2Notification(long l2, SnmpOID snmpOID, SnmpVarBind[] snmpVarBindArray) {
        this();
        this.removeAllVarBinds();
        SnmpTimeTicks snmpTimeTicks = new SnmpTimeTicks(l2);
        SnmpVarBind snmpVarBind = new SnmpVarBind(SYS_UP_TIME_OID, (SnmpDataType)snmpTimeTicks);
        this.addVarBind(snmpVarBind);
        snmpVarBind = new SnmpVarBind(SNMP_TRAP_OID, (SnmpDataType)snmpOID);
        this.addVarBind(snmpVarBind);
        this.addVarBinds(snmpVarBindArray);
    }

    public SnmpV2Notification(long l2, SnmpOID snmpOID) {
        this(l2, snmpOID, null);
    }

    public SnmpV2Notification(SnmpV2Notification snmpV2Notification) {
        super(snmpV2Notification);
    }

    public long getSysUpTime() {
        SnmpVarBind snmpVarBind = this.a.get(0);
        SnmpDataType snmpDataType = snmpVarBind.getValue();
        int n2 = snmpDataType.getType();
        if (n2 == 67 || n2 == 66) {
            SnmpUInt snmpUInt = (SnmpUInt)snmpDataType;
            return snmpUInt.getValue();
        }
        if (n2 == 2) {
            SnmpInt snmpInt = (SnmpInt)snmpDataType;
            return snmpInt.getValue();
        }
        String string = snmpDataType.toString();
        if (cc.isDigit(string)) {
            return Long.parseLong(string);
        }
        throw new SnmpException("Unknown sysUpTime object");
    }

    public void setSysUpTime(long l2) {
        SnmpVarBind snmpVarBind = this.a.get(0);
        snmpVarBind.setValue(new SnmpTimeTicks(l2));
    }

    public String getSysUpTimeString() {
        long l2 = this.getSysUpTime();
        return SnmpTimeTicks.getTimeString(l2);
    }

    public SnmpOID getSnmpTrapOID() {
        if (this.a.size() > 1) {
            SnmpVarBind snmpVarBind = this.a.get(1);
            SnmpDataType snmpDataType = snmpVarBind.getValue();
            if (snmpDataType.getType() == 6) {
                return (SnmpOID)snmpDataType;
            }
            String string = snmpDataType.toString();
            return new SnmpOID(string);
        }
        return null;
    }

    public SnmpVarBind[] getObjects() {
        int n2 = this.a.size() - 2;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            snmpVarBindArray[i2] = this.a.get(i2 + 2);
        }
        return snmpVarBindArray;
    }

    public String getIpAddress() {
        return this.g;
    }

    public void setIpAddress(String string) {
        this.g = string;
    }

    public void setIpAddress(InetAddress inetAddress) {
        this.g = inetAddress.getHostAddress();
    }

    public String toString() {
        String string = "";
        string = string + "Community:\t\t" + cc.convertNull(this.d) + "\r\n";
        string = string + "sysUpTime.0:\t\t" + this.getSysUpTimeString() + "\r\n";
        string = string + "snmpTrapOID.0:\t\t" + this.getSnmpTrapOID() + "\r\n";
        if (this.getVarBindCount() > 2) {
            SnmpVarBind[] snmpVarBindArray = this.getObjects();
            for (int i2 = 0; i2 < snmpVarBindArray.length; ++i2) {
                string = string + snmpVarBindArray[i2].toString() + "\r\n";
            }
        }
        return string;
    }

    public SnmpV1Trap toV1Trap() {
        return this.toV1Trap(this.getIpAddress());
    }

    public SnmpV1Trap toV1Trap(String string) {
        int n2;
        SnmpV1Trap snmpV1Trap = null;
        SnmpVarBind[] snmpVarBindArray = this.getObjects();
        boolean[] blArray = new boolean[snmpVarBindArray.length];
        SnmpOID snmpOID = (SnmpOID)this.a.get(1).getValue();
        Integer n3 = (Integer)u.get(snmpOID);
        int n4 = 0;
        if (n3 == null) {
            long l2 = snmpOID.get(snmpOID.getLength() - 2);
            snmpV1Trap = l2 == 0L ? new SnmpV1Trap(snmpOID.suboid(0, snmpOID.getLength() - 2)) : new SnmpV1Trap(snmpOID.suboid(0, snmpOID.getLength() - 1));
            n4 = snmpOID.get(snmpOID.getLength() - 1);
        }
        for (n2 = 0; n2 < snmpVarBindArray.length; ++n2) {
            if (snmpV1Trap == null && snmpVarBindArray[n2].getName().equals(SNMP_TRAP_ENTERPRISE_OID)) {
                snmpV1Trap = new SnmpV1Trap((SnmpOID)snmpVarBindArray[n2].getValue());
                blArray[n2] = true;
                continue;
            }
            if (snmpVarBindArray[n2].getValue().getType() != 70) continue;
            blArray[n2] = true;
        }
        if (snmpV1Trap == null) {
            snmpV1Trap = new SnmpV1Trap(v);
        }
        for (n2 = 0; n2 < snmpVarBindArray.length; ++n2) {
            if (blArray[n2]) continue;
            snmpV1Trap.addVarBind(snmpVarBindArray[n2]);
        }
        String string2 = this.a.get(0).getValue().toString();
        if (cc.isNumeric(string2)) {
            snmpV1Trap.setTimestamp(Long.parseLong(string2));
        }
        snmpV1Trap.setIpAddress(string);
        if (n3 == null) {
            snmpV1Trap.setSpecific(n4);
            snmpV1Trap.setGeneric(6);
        } else {
            snmpV1Trap.setGeneric(n3);
        }
        snmpV1Trap.setCommunity(this.getCommunity());
        return snmpV1Trap;
    }

    static {
        u.put(COLD_START_TRAP_OID, new Integer(0));
        u.put(WARM_START_TRAP_OID, new Integer(1));
        u.put(LINK_DOWN_TRAP_OID, new Integer(2));
        u.put(LINK_UP_TRAP_OID, new Integer(3));
        u.put(AUTHENTICATION_FAILURE_TRAP_OID, new Integer(4));
        u.put(EGPNEIGHBOR_LOSS_OID, new Integer(5));
        v = new SnmpOID(".1.3.6.1.6.3.1.1.5");
    }
}

