/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util.multipart;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;

public class LimitedServletInputStream
extends ServletInputStream {
    private ServletInputStream in;
    private int totalExpected;
    private int totalRead = 0;

    public LimitedServletInputStream(ServletInputStream servletInputStream, int n) {
        this.in = servletInputStream;
        this.totalExpected = n;
    }

    public boolean isFinished() {
        return this.in.isFinished();
    }

    public boolean isReady() {
        return this.in.isReady();
    }

    public void setReadListener(ReadListener readListener) {
        this.in.setReadListener(readListener);
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.totalExpected - this.totalRead;
        if (n3 <= 0) {
            return -1;
        }
        int n4 = this.in.readLine(byArray, n, Math.min(n3, n2));
        if (n4 > 0) {
            this.totalRead += n4;
        }
        return n4;
    }

    public int read() throws IOException {
        if (this.totalRead >= this.totalExpected) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            ++this.totalRead;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.totalExpected - this.totalRead;
        if (n3 <= 0) {
            return -1;
        }
        int n4 = this.in.read(byArray, n, Math.min(n3, n2));
        if (n4 > 0) {
            this.totalRead += n4;
        }
        return n4;
    }
}

