/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ModuleExports;
import com.sun.org.apache.bcel.internal.classfile.ModuleOpens;
import com.sun.org.apache.bcel.internal.classfile.ModuleProvides;
import com.sun.org.apache.bcel.internal.classfile.ModuleRequires;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Module
extends Attribute {
    private final int moduleNameIndex;
    private final int moduleFlags;
    private final int moduleVersionIndex;
    private ModuleRequires[] requiresTable;
    private ModuleExports[] exportsTable;
    private ModuleOpens[] opensTable;
    private final int usesCount;
    private final int[] usesIndex;
    private ModuleProvides[] providesTable;

    Module(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        super((byte)22, n, n2, constantPool);
        int n3;
        int n4;
        int n5;
        this.moduleNameIndex = dataInput.readUnsignedShort();
        this.moduleFlags = dataInput.readUnsignedShort();
        this.moduleVersionIndex = dataInput.readUnsignedShort();
        int n6 = dataInput.readUnsignedShort();
        this.requiresTable = new ModuleRequires[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            this.requiresTable[n5] = new ModuleRequires(dataInput);
        }
        n5 = dataInput.readUnsignedShort();
        this.exportsTable = new ModuleExports[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.exportsTable[n4] = new ModuleExports(dataInput);
        }
        n4 = dataInput.readUnsignedShort();
        this.opensTable = new ModuleOpens[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.opensTable[n3] = new ModuleOpens(dataInput);
        }
        this.usesCount = dataInput.readUnsignedShort();
        this.usesIndex = new int[this.usesCount];
        for (n3 = 0; n3 < this.usesCount; ++n3) {
            this.usesIndex[n3] = dataInput.readUnsignedShort();
        }
        n3 = dataInput.readUnsignedShort();
        this.providesTable = new ModuleProvides[n3];
        for (int i = 0; i < n3; ++i) {
            this.providesTable[i] = new ModuleProvides(dataInput);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModule(this);
    }

    public ModuleRequires[] getRequiresTable() {
        return this.requiresTable;
    }

    public ModuleExports[] getExportsTable() {
        return this.exportsTable;
    }

    public ModuleOpens[] getOpensTable() {
        return this.opensTable;
    }

    public ModuleProvides[] getProvidesTable() {
        return this.providesTable;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.moduleNameIndex);
        dataOutputStream.writeShort(this.moduleFlags);
        dataOutputStream.writeShort(this.moduleVersionIndex);
        dataOutputStream.writeShort(this.requiresTable.length);
        for (ModuleRequires moduleRequires : this.requiresTable) {
            moduleRequires.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.exportsTable.length);
        for (ModuleExports moduleExports : this.exportsTable) {
            moduleExports.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.opensTable.length);
        for (ModuleOpens moduleOpens : this.opensTable) {
            moduleOpens.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.usesIndex.length);
        for (int n : this.usesIndex) {
            dataOutputStream.writeShort(n);
        }
        dataOutputStream.writeShort(this.providesTable.length);
        for (ModuleProvides moduleProvides : this.providesTable) {
            moduleProvides.dump(dataOutputStream);
        }
    }

    @Override
    public String toString() {
        ConstantPool constantPool = super.getConstantPool();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Module:\n");
        stringBuilder.append("  name:    ").append(constantPool.getConstantString(this.moduleNameIndex, (byte)19).replace('/', '.')).append("\n");
        stringBuilder.append("  flags:   ").append(String.format("%04x", this.moduleFlags)).append("\n");
        String string = this.moduleVersionIndex == 0 ? "0" : constantPool.getConstantString(this.moduleVersionIndex, (byte)1);
        stringBuilder.append("  version: ").append(string).append("\n");
        stringBuilder.append("  requires(").append(this.requiresTable.length).append("):\n");
        for (ModuleRequires moduleRequires : this.requiresTable) {
            stringBuilder.append("    ").append(moduleRequires.toString(constantPool)).append("\n");
        }
        stringBuilder.append("  exports(").append(this.exportsTable.length).append("):\n");
        for (ModuleExports moduleExports : this.exportsTable) {
            stringBuilder.append("    ").append(moduleExports.toString(constantPool)).append("\n");
        }
        stringBuilder.append("  opens(").append(this.opensTable.length).append("):\n");
        for (ModuleOpens moduleOpens : this.opensTable) {
            stringBuilder.append("    ").append(moduleOpens.toString(constantPool)).append("\n");
        }
        stringBuilder.append("  uses(").append(this.usesIndex.length).append("):\n");
        for (int n : this.usesIndex) {
            String string2 = constantPool.getConstantString(n, (byte)7);
            stringBuilder.append("    ").append(Utility.compactClassName(string2, false)).append("\n");
        }
        stringBuilder.append("  provides(").append(this.providesTable.length).append("):\n");
        for (ModuleProvides moduleProvides : this.providesTable) {
            stringBuilder.append("    ").append(moduleProvides.toString(constantPool)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        int n;
        Module module = (Module)this.clone();
        module.requiresTable = new ModuleRequires[this.requiresTable.length];
        for (n = 0; n < this.requiresTable.length; ++n) {
            module.requiresTable[n] = this.requiresTable[n].copy();
        }
        module.exportsTable = new ModuleExports[this.exportsTable.length];
        for (n = 0; n < this.exportsTable.length; ++n) {
            module.exportsTable[n] = this.exportsTable[n].copy();
        }
        module.opensTable = new ModuleOpens[this.opensTable.length];
        for (n = 0; n < this.opensTable.length; ++n) {
            module.opensTable[n] = this.opensTable[n].copy();
        }
        module.providesTable = new ModuleProvides[this.providesTable.length];
        for (n = 0; n < this.providesTable.length; ++n) {
            module.providesTable[n] = this.providesTable[n].copy();
        }
        module.setConstantPool(constantPool);
        return module;
    }
}

