/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.UID;
import java.util.ArrayList;
import sun.misc.ObjectInputFilter;
import sun.rmi.transport.Connection;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.tcp.TCPConnection;

public final class DGCImpl_Stub
extends RemoteStub
implements DGC {
    private static final Operation[] operations = new Operation[]{new Operation("void clean(java.rmi.server.ObjID[], long, java.rmi.dgc.VMID, boolean)"), new Operation("java.rmi.dgc.Lease dirty(java.rmi.server.ObjID[], long, java.rmi.dgc.Lease)")};
    private static final long interfaceHash = -669196253586618813L;
    private static int DGCCLIENT_MAX_DEPTH = 6;
    private static int DGCCLIENT_MAX_ARRAY_SIZE = 10000;

    public DGCImpl_Stub() {
    }

    public DGCImpl_Stub(RemoteRef remoteRef) {
        super(remoteRef);
    }

    @Override
    public void clean(ObjID[] objIDArray, long l, VMID vMID, boolean bl) throws RemoteException {
        try {
            StreamRemoteCall streamRemoteCall = (StreamRemoteCall)this.ref.newCall(this, operations, 0, -669196253586618813L);
            streamRemoteCall.setObjectInputFilter(DGCImpl_Stub::leaseFilter);
            try {
                ObjectOutput objectOutput = streamRemoteCall.getOutputStream();
                objectOutput.writeObject(objIDArray);
                objectOutput.writeLong(l);
                objectOutput.writeObject(vMID);
                objectOutput.writeBoolean(bl);
            }
            catch (IOException iOException) {
                throw new MarshalException("error marshalling arguments", iOException);
            }
            this.ref.invoke(streamRemoteCall);
            this.ref.done(streamRemoteCall);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new UnexpectedException("undeclared checked exception", exception);
        }
    }

    @Override
    public Lease dirty(ObjID[] objIDArray, long l, Lease lease) throws RemoteException {
        try {
            Object object;
            StreamRemoteCall streamRemoteCall = (StreamRemoteCall)this.ref.newCall(this, operations, 1, -669196253586618813L);
            streamRemoteCall.setObjectInputFilter(DGCImpl_Stub::leaseFilter);
            try {
                object = streamRemoteCall.getOutputStream();
                object.writeObject(objIDArray);
                object.writeLong(l);
                object.writeObject(lease);
            }
            catch (IOException iOException) {
                throw new MarshalException("error marshalling arguments", iOException);
            }
            this.ref.invoke(streamRemoteCall);
            Connection connection = streamRemoteCall.getConnection();
            try {
                ObjectInput objectInput = streamRemoteCall.getInputStream();
                object = (Lease)objectInput.readObject();
            }
            catch (IOException | ClassCastException | ClassNotFoundException exception) {
                if (connection instanceof TCPConnection) {
                    ((TCPConnection)connection).getChannel().free(connection, false);
                }
                streamRemoteCall.discardPendingRefs();
                throw new UnmarshalException("error unmarshalling return", exception);
            }
            finally {
                this.ref.done(streamRemoteCall);
            }
            return object;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new UnexpectedException("undeclared checked exception", exception);
        }
    }

    private static ObjectInputFilter.Status leaseFilter(ObjectInputFilter.FilterInfo filterInfo) {
        if (filterInfo.depth() > (long)DGCCLIENT_MAX_DEPTH) {
            return ObjectInputFilter.Status.REJECTED;
        }
        Class<?> clazz = filterInfo.serialClass();
        if (clazz != null) {
            while (clazz.isArray()) {
                if (filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > (long)DGCCLIENT_MAX_ARRAY_SIZE) {
                    return ObjectInputFilter.Status.REJECTED;
                }
                clazz = clazz.getComponentType();
            }
            if (clazz.isPrimitive()) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            return clazz == UID.class || clazz == VMID.class || clazz == Lease.class || clazz.getPackage() != null && Throwable.class.isAssignableFrom(clazz) && ("java.lang".equals(clazz.getPackage().getName()) || "java.rmi".equals(clazz.getPackage().getName())) || clazz == StackTraceElement.class || clazz == ArrayList.class || clazz == Object.class || clazz.getName().equals("java.util.Collections$UnmodifiableList") || clazz.getName().equals("java.util.Collections$UnmodifiableCollection") || clazz.getName().equals("java.util.Collections$UnmodifiableRandomAccessList") || clazz.getName().equals("java.util.Collections$EmptyList") ? ObjectInputFilter.Status.ALLOWED : ObjectInputFilter.Status.REJECTED;
        }
        return ObjectInputFilter.Status.UNDECIDED;
    }
}

