/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleProvides
implements Cloneable,
Node {
    private final int providesIndex;
    private final int providesWithCount;
    private final int[] providesWithIndex;

    ModuleProvides(DataInput dataInput) throws IOException {
        this.providesIndex = dataInput.readUnsignedShort();
        this.providesWithCount = dataInput.readUnsignedShort();
        this.providesWithIndex = new int[this.providesWithCount];
        for (int i = 0; i < this.providesWithCount; ++i) {
            this.providesWithIndex[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleProvides(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.providesIndex);
        dataOutputStream.writeShort(this.providesWithCount);
        for (int n : this.providesWithIndex) {
            dataOutputStream.writeShort(n);
        }
    }

    public String toString() {
        return "provides(" + this.providesIndex + ", " + this.providesWithCount + ", ...)";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.providesIndex, (byte)7);
        stringBuilder.append(Utility.compactClassName(string, false));
        stringBuilder.append(", with(").append(this.providesWithCount).append("):\n");
        for (int n : this.providesWithIndex) {
            String string2 = constantPool.getConstantString(n, (byte)7);
            stringBuilder.append("      ").append(Utility.compactClassName(string2, false)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public ModuleProvides copy() {
        try {
            return (ModuleProvides)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

