/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xalan.internal.utils.SecuritySupport;
import com.sun.org.apache.xml.internal.serializer.EncodingInfo;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Encodings {
    private static final int m_defaultLastPrintable = 127;
    private static final String ENCODINGS_FILE = "com/sun/org/apache/xml/internal/serializer/Encodings.properties";
    private static final String ENCODINGS_PROP = "com.sun.org.apache.xalan.internal.serialize.encodings";
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final EncodingInfos _encodingInfos = new EncodingInfos();

    static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        EncodingInfo encodingInfo = _encodingInfos.findEncoding(Encodings.toUpperCaseFast(string));
        if (encodingInfo != null) {
            try {
                return new BufferedWriter(new OutputStreamWriter(outputStream, encodingInfo.javaName));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new BufferedWriter(new OutputStreamWriter(outputStream, string));
    }

    public static int getLastPrintable() {
        return 127;
    }

    static EncodingInfo getEncodingInfo(String string) {
        String string2 = Encodings.toUpperCaseFast(string);
        EncodingInfo encodingInfo = _encodingInfos.findEncoding(string2);
        if (encodingInfo == null) {
            try {
                Charset charset = Charset.forName(string);
                String string3 = charset.name();
                encodingInfo = new EncodingInfo(string3, string3);
                _encodingInfos.putEncoding(string2, encodingInfo);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                encodingInfo = new EncodingInfo(null, null);
            }
        }
        return encodingInfo;
    }

    public static boolean isRecognizedEncoding(String string) {
        String string2 = Encodings.toUpperCaseFast(string);
        EncodingInfo encodingInfo = _encodingInfos.findEncoding(string2);
        return encodingInfo != null;
    }

    private static String toUpperCaseFast(String string) {
        boolean bl = false;
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('a' <= c && c <= 'z') {
                c = (char)(c + -32);
                bl = true;
            }
            cArray[i] = c;
        }
        String string2 = bl ? String.valueOf(cArray) : string;
        return string2;
    }

    static String getMimeEncoding(String string) {
        block5: {
            if (null == string) {
                try {
                    string = SecuritySupport.getSystemProperty("file.encoding", "UTF8");
                    if (null != string) {
                        String string2 = string.equalsIgnoreCase("Cp1252") || string.equalsIgnoreCase("ISO8859_1") || string.equalsIgnoreCase("8859_1") || string.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(string);
                        string = null != string2 ? string2 : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    string = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException securityException) {
                    string = DEFAULT_MIME_ENCODING;
                }
            } else {
                string = Encodings.convertJava2MimeEncoding(string);
            }
        }
        return string;
    }

    private static String convertJava2MimeEncoding(String string) {
        EncodingInfo encodingInfo = _encodingInfos.getEncodingFromJavaKey(Encodings.toUpperCaseFast(string));
        if (null != encodingInfo) {
            return encodingInfo.name;
        }
        return string;
    }

    public static String convertMime2JavaEncoding(String string) {
        EncodingInfo encodingInfo = _encodingInfos.findEncoding(Encodings.toUpperCaseFast(string));
        return encodingInfo != null ? encodingInfo.javaName : string;
    }

    static boolean isHighUTF16Surrogate(char c) {
        return '\ud800' <= c && c <= '\udbff';
    }

    static boolean isLowUTF16Surrogate(char c) {
        return '\udc00' <= c && c <= '\udfff';
    }

    static int toCodePoint(char c, char c2) {
        int n = (c - 55296 << 10) + (c2 - 56320) + 65536;
        return n;
    }

    static int toCodePoint(char c) {
        char c2 = c;
        return c2;
    }

    private static final class EncodingInfos {
        private final Map<String, EncodingInfo> _encodingTableKeyJava = new HashMap<String, EncodingInfo>();
        private final Map<String, EncodingInfo> _encodingTableKeyMime = new HashMap<String, EncodingInfo>();
        private final Map<String, EncodingInfo> _encodingDynamicTable = Collections.synchronizedMap(new HashMap());

        private EncodingInfos() {
            this.loadEncodingInfo();
        }

        private InputStream openEncodingsFileStream() throws MalformedURLException, IOException {
            String string = null;
            InputStream inputStream = null;
            try {
                string = SecuritySupport.getSystemProperty(Encodings.ENCODINGS_PROP, "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            if (inputStream == null) {
                inputStream = SecuritySupport.getResourceAsStream(Encodings.ENCODINGS_FILE);
            }
            return inputStream;
        }

        private Properties loadProperties() throws MalformedURLException, IOException {
            Properties properties = new Properties();
            try (InputStream inputStream = this.openEncodingsFileStream();){
                if (inputStream != null) {
                    properties.load(inputStream);
                }
            }
            return properties;
        }

        private String[] parseMimeTypes(String string) {
            int n = string.indexOf(32);
            if (n < 0) {
                return new String[]{string};
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(0, n), ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            return stringArray;
        }

        private String findCharsetNameFor(String string) {
            try {
                return Charset.forName(string).name();
            }
            catch (Exception exception) {
                return null;
            }
        }

        private String findCharsetNameFor(String string, String[] stringArray) {
            String string2;
            String string3 = this.findCharsetNameFor(string);
            if (string3 != null) {
                return string;
            }
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n && (string3 = this.findCharsetNameFor(string2 = stringArray2[i])) == null; ++i) {
            }
            return string3;
        }

        private void loadEncodingInfo() {
            try {
                Properties properties = this.loadProperties();
                Enumeration enumeration = properties.keys();
                HashMap<String, EncodingInfo> hashMap = new HashMap<String, EncodingInfo>();
                while (enumeration.hasMoreElements()) {
                    String[] stringArray;
                    String string = (String)enumeration.nextElement();
                    String string2 = this.findCharsetNameFor(string, stringArray = this.parseMimeTypes(properties.getProperty(string)));
                    if (string2 == null) continue;
                    String string3 = Encodings.toUpperCaseFast(string);
                    String string4 = Encodings.toUpperCaseFast(string2);
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string5 = stringArray[i];
                        String string6 = Encodings.toUpperCaseFast(string5);
                        EncodingInfo encodingInfo = new EncodingInfo(string5, string2);
                        this._encodingTableKeyMime.put(string6, encodingInfo);
                        if (!hashMap.containsKey(string4)) {
                            hashMap.put(string4, encodingInfo);
                            this._encodingTableKeyJava.put(string4, encodingInfo);
                        }
                        this._encodingTableKeyJava.put(string3, encodingInfo);
                    }
                }
                for (Map.Entry entry : this._encodingTableKeyJava.entrySet()) {
                    entry.setValue(hashMap.get(Encodings.toUpperCaseFast(((EncodingInfo)entry.getValue()).javaName)));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new WrappedRuntimeException(malformedURLException);
            }
            catch (IOException iOException) {
                throw new WrappedRuntimeException(iOException);
            }
        }

        EncodingInfo findEncoding(String string) {
            EncodingInfo encodingInfo = this._encodingTableKeyJava.get(string);
            if (encodingInfo == null) {
                encodingInfo = this._encodingTableKeyMime.get(string);
            }
            if (encodingInfo == null) {
                encodingInfo = this._encodingDynamicTable.get(string);
            }
            return encodingInfo;
        }

        EncodingInfo getEncodingFromMimeKey(String string) {
            return this._encodingTableKeyMime.get(string);
        }

        EncodingInfo getEncodingFromJavaKey(String string) {
            return this._encodingTableKeyJava.get(string);
        }

        void putEncoding(String string, EncodingInfo encodingInfo) {
            this._encodingDynamicTable.put(string, encodingInfo);
        }
    }
}

