/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.util.locale.BaseLocale;
import sun.util.locale.Extension;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleSyntaxException;
import sun.util.locale.LocaleUtils;
import sun.util.locale.StringTokenIterator;
import sun.util.locale.UnicodeLocaleExtension;

public final class InternalLocaleBuilder {
    private static final CaseInsensitiveChar PRIVATEUSE_KEY = new CaseInsensitiveChar("x");
    private String language = "";
    private String script = "";
    private String region = "";
    private String variant = "";
    private Map<CaseInsensitiveChar, String> extensions;
    private Set<CaseInsensitiveString> uattributes;
    private Map<CaseInsensitiveString, String> ukeywords;

    public InternalLocaleBuilder setLanguage(String string) throws LocaleSyntaxException {
        if (LocaleUtils.isEmpty(string)) {
            this.language = "";
        } else {
            if (!LanguageTag.isLanguage(string)) {
                throw new LocaleSyntaxException("Ill-formed language: " + string, 0);
            }
            this.language = string;
        }
        return this;
    }

    public InternalLocaleBuilder setScript(String string) throws LocaleSyntaxException {
        if (LocaleUtils.isEmpty(string)) {
            this.script = "";
        } else {
            if (!LanguageTag.isScript(string)) {
                throw new LocaleSyntaxException("Ill-formed script: " + string, 0);
            }
            this.script = string;
        }
        return this;
    }

    public InternalLocaleBuilder setRegion(String string) throws LocaleSyntaxException {
        if (LocaleUtils.isEmpty(string)) {
            this.region = "";
        } else {
            if (!LanguageTag.isRegion(string)) {
                throw new LocaleSyntaxException("Ill-formed region: " + string, 0);
            }
            this.region = string;
        }
        return this;
    }

    public InternalLocaleBuilder setVariant(String string) throws LocaleSyntaxException {
        if (LocaleUtils.isEmpty(string)) {
            this.variant = "";
        } else {
            String string2 = string.replaceAll("-", "_");
            int n = this.checkVariants(string2, "_");
            if (n != -1) {
                throw new LocaleSyntaxException("Ill-formed variant: " + string, n);
            }
            this.variant = string2;
        }
        return this;
    }

    public InternalLocaleBuilder addUnicodeLocaleAttribute(String string) throws LocaleSyntaxException {
        if (!UnicodeLocaleExtension.isAttribute(string)) {
            throw new LocaleSyntaxException("Ill-formed Unicode locale attribute: " + string);
        }
        if (this.uattributes == null) {
            this.uattributes = new HashSet<CaseInsensitiveString>(4);
        }
        this.uattributes.add(new CaseInsensitiveString(string));
        return this;
    }

    public InternalLocaleBuilder removeUnicodeLocaleAttribute(String string) throws LocaleSyntaxException {
        if (string == null || !UnicodeLocaleExtension.isAttribute(string)) {
            throw new LocaleSyntaxException("Ill-formed Unicode locale attribute: " + string);
        }
        if (this.uattributes != null) {
            this.uattributes.remove(new CaseInsensitiveString(string));
        }
        return this;
    }

    public InternalLocaleBuilder setUnicodeLocaleKeyword(String string, String string2) throws LocaleSyntaxException {
        if (!UnicodeLocaleExtension.isKey(string)) {
            throw new LocaleSyntaxException("Ill-formed Unicode locale keyword key: " + string);
        }
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        if (string2 == null) {
            if (this.ukeywords != null) {
                this.ukeywords.remove(caseInsensitiveString);
            }
        } else {
            if (string2.length() != 0) {
                String string3 = string2.replaceAll("_", "-");
                StringTokenIterator stringTokenIterator = new StringTokenIterator(string3, "-");
                while (!stringTokenIterator.isDone()) {
                    String string4 = stringTokenIterator.current();
                    if (!UnicodeLocaleExtension.isTypeSubtag(string4)) {
                        throw new LocaleSyntaxException("Ill-formed Unicode locale keyword type: " + string2, stringTokenIterator.currentStart());
                    }
                    stringTokenIterator.next();
                }
            }
            if (this.ukeywords == null) {
                this.ukeywords = new HashMap<CaseInsensitiveString, String>(4);
            }
            this.ukeywords.put(caseInsensitiveString, string2);
        }
        return this;
    }

    public InternalLocaleBuilder setExtension(char c, String string) throws LocaleSyntaxException {
        boolean bl = LanguageTag.isPrivateusePrefixChar(c);
        if (!bl && !LanguageTag.isExtensionSingletonChar(c)) {
            throw new LocaleSyntaxException("Ill-formed extension key: " + c);
        }
        boolean bl2 = LocaleUtils.isEmpty(string);
        CaseInsensitiveChar caseInsensitiveChar = new CaseInsensitiveChar(c);
        if (bl2) {
            if (UnicodeLocaleExtension.isSingletonChar(caseInsensitiveChar.value())) {
                if (this.uattributes != null) {
                    this.uattributes.clear();
                }
                if (this.ukeywords != null) {
                    this.ukeywords.clear();
                }
            } else if (this.extensions != null && this.extensions.containsKey(caseInsensitiveChar)) {
                this.extensions.remove(caseInsensitiveChar);
            }
        } else {
            String string2 = string.replaceAll("_", "-");
            StringTokenIterator stringTokenIterator = new StringTokenIterator(string2, "-");
            while (!stringTokenIterator.isDone()) {
                String string3 = stringTokenIterator.current();
                boolean bl3 = bl ? LanguageTag.isPrivateuseSubtag(string3) : LanguageTag.isExtensionSubtag(string3);
                if (!bl3) {
                    throw new LocaleSyntaxException("Ill-formed extension value: " + string3, stringTokenIterator.currentStart());
                }
                stringTokenIterator.next();
            }
            if (UnicodeLocaleExtension.isSingletonChar(caseInsensitiveChar.value())) {
                this.setUnicodeLocaleExtension(string2);
            } else {
                if (this.extensions == null) {
                    this.extensions = new HashMap<CaseInsensitiveChar, String>(4);
                }
                this.extensions.put(caseInsensitiveChar, string2);
            }
        }
        return this;
    }

    public InternalLocaleBuilder setExtensions(String string) throws LocaleSyntaxException {
        CharSequence charSequence;
        int n;
        String string2;
        if (LocaleUtils.isEmpty(string)) {
            this.clearExtensions();
            return this;
        }
        string = string.replaceAll("_", "-");
        StringTokenIterator stringTokenIterator = new StringTokenIterator(string, "-");
        ArrayList<String> arrayList = null;
        String string3 = null;
        int n2 = 0;
        while (!stringTokenIterator.isDone() && LanguageTag.isExtensionSingleton(string2 = stringTokenIterator.current())) {
            n = stringTokenIterator.currentStart();
            charSequence = string2;
            StringBuilder stringBuilder = new StringBuilder((String)charSequence);
            stringTokenIterator.next();
            while (!stringTokenIterator.isDone() && LanguageTag.isExtensionSubtag(string2 = stringTokenIterator.current())) {
                stringBuilder.append("-").append(string2);
                n2 = stringTokenIterator.currentEnd();
                stringTokenIterator.next();
            }
            if (n2 < n) {
                throw new LocaleSyntaxException("Incomplete extension '" + (String)charSequence + "'", n);
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>(4);
            }
            arrayList.add(stringBuilder.toString());
        }
        if (!stringTokenIterator.isDone() && LanguageTag.isPrivateusePrefix(string2 = stringTokenIterator.current())) {
            n = stringTokenIterator.currentStart();
            charSequence = new StringBuilder(string2);
            stringTokenIterator.next();
            while (!stringTokenIterator.isDone() && LanguageTag.isPrivateuseSubtag(string2 = stringTokenIterator.current())) {
                ((StringBuilder)charSequence).append("-").append(string2);
                n2 = stringTokenIterator.currentEnd();
                stringTokenIterator.next();
            }
            if (n2 <= n) {
                throw new LocaleSyntaxException("Incomplete privateuse:" + string.substring(n), n);
            }
            string3 = ((StringBuilder)charSequence).toString();
        }
        if (!stringTokenIterator.isDone()) {
            throw new LocaleSyntaxException("Ill-formed extension subtags:" + string.substring(stringTokenIterator.currentStart()), stringTokenIterator.currentStart());
        }
        return this.setExtensions(arrayList, string3);
    }

    private InternalLocaleBuilder setExtensions(List<String> list, String string) {
        this.clearExtensions();
        if (!LocaleUtils.isEmpty(list)) {
            HashSet<CaseInsensitiveChar> hashSet = new HashSet<CaseInsensitiveChar>(list.size());
            for (String string2 : list) {
                CaseInsensitiveChar caseInsensitiveChar = new CaseInsensitiveChar(string2);
                if (!hashSet.contains(caseInsensitiveChar)) {
                    if (UnicodeLocaleExtension.isSingletonChar(caseInsensitiveChar.value())) {
                        this.setUnicodeLocaleExtension(string2.substring(2));
                    } else {
                        if (this.extensions == null) {
                            this.extensions = new HashMap<CaseInsensitiveChar, String>(4);
                        }
                        this.extensions.put(caseInsensitiveChar, string2.substring(2));
                    }
                }
                hashSet.add(caseInsensitiveChar);
            }
        }
        if (string != null && !string.isEmpty()) {
            if (this.extensions == null) {
                this.extensions = new HashMap<CaseInsensitiveChar, String>(1);
            }
            this.extensions.put(new CaseInsensitiveChar(string), string.substring(2));
        }
        return this;
    }

    public InternalLocaleBuilder setLanguageTag(LanguageTag languageTag) {
        Object object;
        this.clear();
        if (!languageTag.getExtlangs().isEmpty()) {
            this.language = languageTag.getExtlangs().get(0);
        } else {
            object = languageTag.getLanguage();
            if (!((String)object).equals("und")) {
                this.language = object;
            }
        }
        this.script = languageTag.getScript();
        this.region = languageTag.getRegion();
        object = languageTag.getVariants();
        if (!object.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder((String)object.get(0));
            int n = object.size();
            for (int i = 1; i < n; ++i) {
                stringBuilder.append("_").append((String)object.get(i));
            }
            this.variant = stringBuilder.toString();
        }
        this.setExtensions(languageTag.getExtensions(), languageTag.getPrivateuse());
        return this;
    }

    public InternalLocaleBuilder setLocale(BaseLocale baseLocale, LocaleExtensions localeExtensions) throws LocaleSyntaxException {
        Set<Character> set;
        int n;
        String string = baseLocale.getLanguage();
        String string2 = baseLocale.getScript();
        String string3 = baseLocale.getRegion();
        String string4 = baseLocale.getVariant();
        if (string.equals("ja") && string3.equals("JP") && string4.equals("JP")) {
            assert ("japanese".equals(localeExtensions.getUnicodeLocaleType("ca")));
            string4 = "";
        } else if (string.equals("th") && string3.equals("TH") && string4.equals("TH")) {
            assert ("thai".equals(localeExtensions.getUnicodeLocaleType("nu")));
            string4 = "";
        } else if (string.equals("no") && string3.equals("NO") && string4.equals("NY")) {
            string = "nn";
            string4 = "";
        }
        if (!string.isEmpty() && !LanguageTag.isLanguage(string)) {
            throw new LocaleSyntaxException("Ill-formed language: " + string);
        }
        if (!string2.isEmpty() && !LanguageTag.isScript(string2)) {
            throw new LocaleSyntaxException("Ill-formed script: " + string2);
        }
        if (!string3.isEmpty() && !LanguageTag.isRegion(string3)) {
            throw new LocaleSyntaxException("Ill-formed region: " + string3);
        }
        if (!string4.isEmpty() && (n = this.checkVariants(string4, "_")) != -1) {
            throw new LocaleSyntaxException("Ill-formed variant: " + string4, n);
        }
        this.language = string;
        this.script = string2;
        this.region = string3;
        this.variant = string4;
        this.clearExtensions();
        Set<Character> set2 = set = localeExtensions == null ? null : localeExtensions.getKeys();
        if (set != null) {
            for (Character c : set) {
                Extension extension = localeExtensions.getExtension(c);
                if (extension instanceof UnicodeLocaleExtension) {
                    UnicodeLocaleExtension unicodeLocaleExtension = (UnicodeLocaleExtension)extension;
                    for (String string5 : unicodeLocaleExtension.getUnicodeLocaleAttributes()) {
                        if (this.uattributes == null) {
                            this.uattributes = new HashSet<CaseInsensitiveString>(4);
                        }
                        this.uattributes.add(new CaseInsensitiveString(string5));
                    }
                    for (String string5 : unicodeLocaleExtension.getUnicodeLocaleKeys()) {
                        if (this.ukeywords == null) {
                            this.ukeywords = new HashMap<CaseInsensitiveString, String>(4);
                        }
                        this.ukeywords.put(new CaseInsensitiveString(string5), unicodeLocaleExtension.getUnicodeLocaleType(string5));
                    }
                    continue;
                }
                if (this.extensions == null) {
                    this.extensions = new HashMap<CaseInsensitiveChar, String>(4);
                }
                this.extensions.put(new CaseInsensitiveChar(c.charValue()), extension.getValue());
            }
        }
        return this;
    }

    public InternalLocaleBuilder clear() {
        this.language = "";
        this.script = "";
        this.region = "";
        this.variant = "";
        this.clearExtensions();
        return this;
    }

    public InternalLocaleBuilder clearExtensions() {
        if (this.extensions != null) {
            this.extensions.clear();
        }
        if (this.uattributes != null) {
            this.uattributes.clear();
        }
        if (this.ukeywords != null) {
            this.ukeywords.clear();
        }
        return this;
    }

    public BaseLocale getBaseLocale() {
        String string;
        String string2 = this.language;
        String string3 = this.script;
        String string4 = this.region;
        String string5 = this.variant;
        if (this.extensions != null && (string = this.extensions.get(PRIVATEUSE_KEY)) != null) {
            StringTokenIterator stringTokenIterator = new StringTokenIterator(string, "-");
            boolean bl = false;
            int n = -1;
            while (!stringTokenIterator.isDone()) {
                if (bl) {
                    n = stringTokenIterator.currentStart();
                    break;
                }
                if (LocaleUtils.caseIgnoreMatch(stringTokenIterator.current(), "lvariant")) {
                    bl = true;
                }
                stringTokenIterator.next();
            }
            if (n != -1) {
                StringBuilder stringBuilder = new StringBuilder(string5);
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("_");
                }
                stringBuilder.append(string.substring(n).replaceAll("-", "_"));
                string5 = stringBuilder.toString();
            }
        }
        return BaseLocale.getInstance(string2, string3, string4, string5);
    }

    public LocaleExtensions getLocaleExtensions() {
        if (LocaleUtils.isEmpty(this.extensions) && LocaleUtils.isEmpty(this.uattributes) && LocaleUtils.isEmpty(this.ukeywords)) {
            return null;
        }
        LocaleExtensions localeExtensions = new LocaleExtensions(this.extensions, this.uattributes, this.ukeywords);
        return localeExtensions.isEmpty() ? null : localeExtensions;
    }

    static String removePrivateuseVariant(String string) {
        StringTokenIterator stringTokenIterator = new StringTokenIterator(string, "-");
        int n = -1;
        boolean bl = false;
        while (!stringTokenIterator.isDone()) {
            if (n != -1) {
                bl = true;
                break;
            }
            if (LocaleUtils.caseIgnoreMatch(stringTokenIterator.current(), "lvariant")) {
                n = stringTokenIterator.currentStart();
            }
            stringTokenIterator.next();
        }
        if (!bl) {
            return string;
        }
        assert (n == 0 || n > 1);
        return n == 0 ? null : string.substring(0, n - 1);
    }

    private int checkVariants(String string, String string2) {
        StringTokenIterator stringTokenIterator = new StringTokenIterator(string, string2);
        while (!stringTokenIterator.isDone()) {
            String string3 = stringTokenIterator.current();
            if (!LanguageTag.isVariant(string3)) {
                return stringTokenIterator.currentStart();
            }
            stringTokenIterator.next();
        }
        return -1;
    }

    private void setUnicodeLocaleExtension(String string) {
        if (this.uattributes != null) {
            this.uattributes.clear();
        }
        if (this.ukeywords != null) {
            this.ukeywords.clear();
        }
        StringTokenIterator stringTokenIterator = new StringTokenIterator(string, "-");
        while (!stringTokenIterator.isDone() && UnicodeLocaleExtension.isAttribute(stringTokenIterator.current())) {
            if (this.uattributes == null) {
                this.uattributes = new HashSet<CaseInsensitiveString>(4);
            }
            this.uattributes.add(new CaseInsensitiveString(stringTokenIterator.current()));
            stringTokenIterator.next();
        }
        CaseInsensitiveString caseInsensitiveString = null;
        int n = -1;
        int n2 = -1;
        while (!stringTokenIterator.isDone()) {
            String string2;
            if (caseInsensitiveString != null) {
                if (UnicodeLocaleExtension.isKey(stringTokenIterator.current())) {
                    assert (n == -1 || n2 != -1);
                    String string3 = string2 = n == -1 ? "" : string.substring(n, n2);
                    if (this.ukeywords == null) {
                        this.ukeywords = new HashMap<CaseInsensitiveString, String>(4);
                    }
                    this.ukeywords.put(caseInsensitiveString, string2);
                    CaseInsensitiveString caseInsensitiveString2 = new CaseInsensitiveString(stringTokenIterator.current());
                    caseInsensitiveString = this.ukeywords.containsKey(caseInsensitiveString2) ? null : caseInsensitiveString2;
                    n2 = -1;
                    n = -1;
                } else {
                    if (n == -1) {
                        n = stringTokenIterator.currentStart();
                    }
                    n2 = stringTokenIterator.currentEnd();
                }
            } else if (UnicodeLocaleExtension.isKey(stringTokenIterator.current())) {
                caseInsensitiveString = new CaseInsensitiveString(stringTokenIterator.current());
                if (this.ukeywords != null && this.ukeywords.containsKey(caseInsensitiveString)) {
                    caseInsensitiveString = null;
                }
            }
            if (!stringTokenIterator.hasNext()) {
                if (caseInsensitiveString == null) break;
                assert (n == -1 || n2 != -1);
                String string4 = string2 = n == -1 ? "" : string.substring(n, n2);
                if (this.ukeywords == null) {
                    this.ukeywords = new HashMap<CaseInsensitiveString, String>(4);
                }
                this.ukeywords.put(caseInsensitiveString, string2);
                break;
            }
            stringTokenIterator.next();
        }
    }

    static final class CaseInsensitiveChar {
        private final char ch;
        private final char lowerCh;

        private CaseInsensitiveChar(String string) {
            this(string.charAt(0));
        }

        CaseInsensitiveChar(char c) {
            this.ch = c;
            this.lowerCh = LocaleUtils.toLower(this.ch);
        }

        public char value() {
            return this.ch;
        }

        public int hashCode() {
            return this.lowerCh;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CaseInsensitiveChar)) {
                return false;
            }
            return this.lowerCh == ((CaseInsensitiveChar)object).lowerCh;
        }
    }

    static final class CaseInsensitiveString {
        private final String str;
        private final String lowerStr;

        CaseInsensitiveString(String string) {
            this.str = string;
            this.lowerStr = LocaleUtils.toLowerString(string);
        }

        public String value() {
            return this.str;
        }

        public int hashCode() {
            return this.lowerStr.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CaseInsensitiveString)) {
                return false;
            }
            return this.lowerStr.equals(((CaseInsensitiveString)object).lowerStr);
        }
    }
}

