/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.soap.SOAPException;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String string, ClassLoader classLoader) throws SOAPException {
        try {
            Class clazz = FactoryFinder.safeLoadClass(string, classLoader);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SOAPException("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new SOAPException("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string) throws SOAPException {
        return FactoryFinder.find(string, null, false);
    }

    static Object find(String string, String string2) throws SOAPException {
        return FactoryFinder.find(string, string2, true);
    }

    static Object find(String string, String string2, boolean bl) throws SOAPException {
        Object object;
        Object object2;
        String string3;
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new SOAPException(exception.toString(), exception);
        }
        try {
            string3 = System.getProperty(string);
            if (string3 != null) {
                return FactoryFinder.newInstance(string3, classLoader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            string3 = System.getProperty("java.home");
            object2 = string3 + File.separator + "lib" + File.separator + "jaxm.properties";
            object = new File((String)object2);
            if (((File)object).exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream((File)object));
                String string4 = properties.getProperty(string);
                return FactoryFinder.newInstance(string4, classLoader);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string3 = "META-INF/services/" + string;
        try {
            object2 = null;
            object2 = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
            if (object2 != null) {
                object = new BufferedReader(new InputStreamReader((InputStream)object2, "UTF-8"));
                String string5 = ((BufferedReader)object).readLine();
                ((BufferedReader)object).close();
                if (string5 != null && !"".equals(string5)) {
                    return FactoryFinder.newInstance(string5, classLoader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            return null;
        }
        if (string2 == null) {
            throw new SOAPException("Provider for " + string + " cannot be found", null);
        }
        return FactoryFinder.newInstance(string2, classLoader);
    }

    private static Class safeLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            if (classLoader == null) {
                return Class.forName(string);
            }
            return classLoader.loadClass(string);
        }
        catch (SecurityException securityException) {
            if (FactoryFinder.isDefaultImplementation(string)) {
                return Class.forName(string);
            }
            throw securityException;
        }
    }

    private static boolean isDefaultImplementation(String string) {
        return "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl".equals(string) || "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl".equals(string) || "com.sun.xml.internal.messaging.saaj.client.p2p.HttpSOAPConnectionFactory".equals(string) || "com.sun.xml.internal.messaging.saaj.soap.SAAJMetaFactoryImpl".equals(string);
    }
}

