/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Spliterator;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.PipelineHelper;

abstract class AbstractTask<P_IN, P_OUT, R, K extends AbstractTask<P_IN, P_OUT, R, K>>
extends CountedCompleter<R> {
    static final int LEAF_TARGET = ForkJoinPool.getCommonPoolParallelism() << 2;
    protected final PipelineHelper<P_OUT> helper;
    protected Spliterator<P_IN> spliterator;
    protected long targetSize;
    protected K leftChild;
    protected K rightChild;
    private R localResult;

    protected AbstractTask(PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator) {
        super(null);
        this.helper = pipelineHelper;
        this.spliterator = spliterator;
        this.targetSize = 0L;
    }

    protected AbstractTask(K k, Spliterator<P_IN> spliterator) {
        super((CountedCompleter<?>)k);
        this.spliterator = spliterator;
        this.helper = ((AbstractTask)k).helper;
        this.targetSize = ((AbstractTask)k).targetSize;
    }

    protected abstract K makeChild(Spliterator<P_IN> var1);

    protected abstract R doLeaf();

    public static long suggestTargetSize(long l) {
        long l2 = l / (long)LEAF_TARGET;
        return l2 > 0L ? l2 : 1L;
    }

    protected final long getTargetSize(long l) {
        long l2 = this.targetSize;
        return l2 != 0L ? l2 : (this.targetSize = AbstractTask.suggestTargetSize(l));
    }

    @Override
    public R getRawResult() {
        return this.localResult;
    }

    @Override
    protected void setRawResult(R r) {
        if (r != null) {
            throw new IllegalStateException();
        }
    }

    protected R getLocalResult() {
        return this.localResult;
    }

    protected void setLocalResult(R r) {
        this.localResult = r;
    }

    protected boolean isLeaf() {
        return this.leftChild == null;
    }

    protected boolean isRoot() {
        return this.getParent() == null;
    }

    protected K getParent() {
        return (K)((AbstractTask)this.getCompleter());
    }

    @Override
    public void compute() {
        Spliterator<P_IN> spliterator;
        Spliterator<P_IN> spliterator2 = this.spliterator;
        long l = spliterator2.estimateSize();
        long l2 = this.getTargetSize(l);
        boolean bl = false;
        AbstractTask<P_IN, P_OUT, R, K> abstractTask = this;
        while (l > l2 && (spliterator = spliterator2.trySplit()) != null) {
            K k;
            K k2 = abstractTask.makeChild(spliterator);
            abstractTask.leftChild = k2;
            K k3 = abstractTask.makeChild(spliterator2);
            abstractTask.rightChild = k3;
            abstractTask.setPendingCount(1);
            if (bl) {
                bl = false;
                spliterator2 = spliterator;
                abstractTask = k2;
                k = k3;
            } else {
                bl = true;
                abstractTask = k3;
                k = k2;
            }
            ((ForkJoinTask)k).fork();
            l = spliterator2.estimateSize();
        }
        abstractTask.setLocalResult(abstractTask.doLeaf());
        abstractTask.tryComplete();
    }

    @Override
    public void onCompletion(CountedCompleter<?> countedCompleter) {
        this.spliterator = null;
        this.rightChild = null;
        this.leftChild = null;
    }

    protected boolean isLeftmostNode() {
        AbstractTask<P_IN, P_OUT, R, K> abstractTask = this;
        while (abstractTask != null) {
            K k = abstractTask.getParent();
            if (k != null && ((AbstractTask)k).leftChild != abstractTask) {
                return false;
            }
            abstractTask = k;
        }
        return true;
    }
}

