/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xpath.internal.jaxp.XPathImpl;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import jdk.xml.internal.JdkXmlFeatures;
import jdk.xml.internal.XMLSecurityManager;

public class XPathFactoryImpl
extends XPathFactory {
    private static final String CLASS_NAME = "XPathFactoryImpl";
    private XPathFunctionResolver xPathFunctionResolver = null;
    private XPathVariableResolver xPathVariableResolver = null;
    private boolean _isNotSecureProcessing = true;
    private boolean _isSecureMode = false;
    private final JdkXmlFeatures _featureManager;
    private XMLSecurityManager _xmlSecMgr;

    public XPathFactoryImpl() {
        if (System.getSecurityManager() != null) {
            this._isSecureMode = true;
            this._isNotSecureProcessing = false;
        }
        this._featureManager = new JdkXmlFeatures(!this._isNotSecureProcessing);
        this._xmlSecMgr = new XMLSecurityManager(true);
    }

    @Override
    public boolean isObjectModelSupported(String string) {
        if (string == null) {
            String string2 = XSLMessages.createXPATHMessage("ER_OBJECT_MODEL_NULL", new Object[]{this.getClass().getName()});
            throw new NullPointerException(string2);
        }
        if (string.length() == 0) {
            String string3 = XSLMessages.createXPATHMessage("ER_OBJECT_MODEL_EMPTY", new Object[]{this.getClass().getName()});
            throw new IllegalArgumentException(string3);
        }
        return string.equals("http://java.sun.com/jaxp/xpath/dom");
    }

    @Override
    public XPath newXPath() {
        return new XPathImpl(this.xPathVariableResolver, this.xPathFunctionResolver, !this._isNotSecureProcessing, this._featureManager, this._xmlSecMgr);
    }

    @Override
    public void setFeature(String string, boolean bl) throws XPathFactoryConfigurationException {
        if (string == null) {
            String string2 = XSLMessages.createXPATHMessage("ER_FEATURE_NAME_NULL", new Object[]{CLASS_NAME, bl});
            throw new NullPointerException(string2);
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            if (this._isSecureMode && !bl) {
                String string3 = XSLMessages.createXPATHMessage("ER_SECUREPROCESSING_FEATURE", new Object[]{string, CLASS_NAME, bl});
                throw new XPathFactoryConfigurationException(string3);
            }
            boolean bl2 = this._isNotSecureProcessing = !bl;
            if (bl && this._featureManager != null) {
                this._featureManager.setFeature(JdkXmlFeatures.XmlFeature.ENABLE_EXTENSION_FUNCTION, JdkXmlFeatures.State.FSP, false);
            }
            return;
        }
        if (string.equals("http://www.oracle.com/feature/use-service-mechanism") && this._isSecureMode) {
            return;
        }
        if (this._featureManager != null && this._featureManager.setFeature(string, JdkXmlFeatures.State.APIPROPERTY, (Object)bl)) {
            return;
        }
        String string4 = XSLMessages.createXPATHMessage("ER_FEATURE_UNKNOWN", new Object[]{string, CLASS_NAME, bl});
        throw new XPathFactoryConfigurationException(string4);
    }

    @Override
    public boolean getFeature(String string) throws XPathFactoryConfigurationException {
        if (string == null) {
            String string2 = XSLMessages.createXPATHMessage("ER_GETTING_NULL_FEATURE", new Object[]{CLASS_NAME});
            throw new NullPointerException(string2);
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return !this._isNotSecureProcessing;
        }
        int n = this._featureManager.getIndex(string);
        if (n > -1) {
            return this._featureManager.getFeature(n);
        }
        String string3 = XSLMessages.createXPATHMessage("ER_GETTING_UNKNOWN_FEATURE", new Object[]{string, CLASS_NAME});
        throw new XPathFactoryConfigurationException(string3);
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (xPathFunctionResolver == null) {
            String string = XSLMessages.createXPATHMessage("ER_NULL_XPATH_FUNCTION_RESOLVER", new Object[]{CLASS_NAME});
            throw new NullPointerException(string);
        }
        this.xPathFunctionResolver = xPathFunctionResolver;
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        if (xPathVariableResolver == null) {
            String string = XSLMessages.createXPATHMessage("ER_NULL_XPATH_VARIABLE_RESOLVER", new Object[]{CLASS_NAME});
            throw new NullPointerException(string);
        }
        this.xPathVariableResolver = xPathVariableResolver;
    }
}

