/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModularRuntimeImage
implements Closeable {
    static final String MODULES_PATH = File.separator + "modules";
    static final String PACKAGES_PATH = File.separator + "packages";
    private final URLClassLoader classLoader;
    private final FileSystem fileSystem;

    public ModularRuntimeImage() throws IOException {
        this(null, FileSystems.getFileSystem(URI.create("jrt:/")));
    }

    public ModularRuntimeImage(String string) throws IOException {
        Map map = Collections.emptyMap();
        Path path = Paths.get(string, new String[0]);
        Path path2 = path.resolve("lib").resolve("jrt-fs.jar");
        this.classLoader = new URLClassLoader(new URL[]{path2.toUri().toURL()});
        this.fileSystem = FileSystems.newFileSystem(URI.create("jrt:/"), map, this.classLoader);
    }

    private ModularRuntimeImage(URLClassLoader uRLClassLoader, FileSystem fileSystem) {
        this.classLoader = uRLClassLoader;
        this.fileSystem = fileSystem;
    }

    @Override
    public void close() throws IOException {
        if (this.classLoader != null) {
            this.classLoader.close();
        }
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
    }

    public List<Path> list(Path path) throws IOException {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            Iterator<Path> iterator = directoryStream.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public List<Path> list(String string) throws IOException {
        return this.list(this.fileSystem.getPath(string, new String[0]));
    }

    public List<Path> modules() throws IOException {
        return this.list(MODULES_PATH);
    }

    public List<Path> packages() throws IOException {
        return this.list(PACKAGES_PATH);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }
}

