/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class BootstrapMethod
implements Cloneable {
    private int bootstrapMethodRef;
    private int[] bootstrapArguments;

    public BootstrapMethod(BootstrapMethod bootstrapMethod) {
        this(bootstrapMethod.getBootstrapMethodRef(), bootstrapMethod.getBootstrapArguments());
    }

    BootstrapMethod(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
        for (int i = 0; i < this.bootstrapArguments.length; ++i) {
            this.bootstrapArguments[i] = dataInput.readUnsignedShort();
        }
    }

    private BootstrapMethod(int n, int n2) {
        this(n, new int[n2]);
    }

    public BootstrapMethod(int n, int[] nArray) {
        this.bootstrapMethodRef = n;
        this.bootstrapArguments = nArray;
    }

    public int getBootstrapMethodRef() {
        return this.bootstrapMethodRef;
    }

    public void setBootstrapMethodRef(int n) {
        this.bootstrapMethodRef = n;
    }

    public int[] getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    public int getNumBootstrapArguments() {
        return this.bootstrapArguments.length;
    }

    public void setBootstrapArguments(int[] nArray) {
        this.bootstrapArguments = nArray;
    }

    public final String toString() {
        return "BootstrapMethod(" + this.bootstrapMethodRef + ", " + this.bootstrapArguments.length + ", " + Arrays.toString(this.bootstrapArguments) + ")";
    }

    public final String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.bootstrapMethodRef, (byte)15);
        stringBuilder.append(Utility.compactClassName(string, false));
        int n = this.bootstrapArguments.length;
        if (n > 0) {
            stringBuilder.append("\nMethod Arguments:");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("\n  ").append(i).append(": ");
                stringBuilder.append(constantPool.constantToString(constantPool.getConstant(this.bootstrapArguments[i])));
            }
        }
        return stringBuilder.toString();
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.bootstrapMethodRef);
        dataOutputStream.writeShort(this.bootstrapArguments.length);
        for (int n : this.bootstrapArguments) {
            dataOutputStream.writeShort(n);
        }
    }

    public BootstrapMethod copy() {
        try {
            return (BootstrapMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

