/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class SecuritySupport {
    public static final String NEWLINE = SecuritySupport.getSystemProperty("line.separator", "\n");
    static final Properties cacheProps = new Properties();
    static volatile boolean firstTime = true;

    private SecuritySupport() {
    }

    public static String getSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    public static String getSystemProperty(String string, String string2) {
        String string3 = SecuritySupport.getSystemProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static <T> T getSystemProperty(Class<T> clazz, String string, String string2) {
        String string3 = SecuritySupport.getSystemProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return clazz.cast(Integer.parseInt(string3));
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return clazz.cast(Boolean.parseBoolean(string3));
        }
        return clazz.cast(string3);
    }

    public static <T> T getJAXPSystemProperty(Class<T> clazz, String string, String string2) {
        String string3 = SecuritySupport.getJAXPSystemProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return clazz.cast(Integer.parseInt(string3));
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return clazz.cast(Boolean.parseBoolean(string3));
        }
        return clazz.cast(string3);
    }

    public static String getJAXPSystemProperty(String string) {
        String string2 = SecuritySupport.getSystemProperty(string);
        if (string2 == null) {
            string2 = SecuritySupport.readJAXPProperty(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readJAXPProperty(String string) {
        String string2 = null;
        InputStream inputStream = null;
        try {
            if (firstTime) {
                Properties properties = cacheProps;
                synchronized (properties) {
                    if (firstTime) {
                        String string3 = SecuritySupport.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                        File file = new File(string3);
                        if (SecuritySupport.isFileExists(file)) {
                            inputStream = SecuritySupport.getFileInputStream(file);
                            cacheProps.load(inputStream);
                        }
                        firstTime = false;
                    }
                }
            }
            string2 = cacheProps.getProperty(string);
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    public static boolean isDirectory(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public static boolean isFileExists(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws Exception {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    public static String[] getFileList(final File file, final FilenameFilter filenameFilter) {
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.list(filenameFilter);
            }
        });
    }

    public static ResourceBundle getResourceBundle(String string) {
        return SecuritySupport.getResourceBundle(string, Locale.getDefault());
    }

    public static ListResourceBundle getResourceBundle(final String string, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ListResourceBundle>(){

            @Override
            public ListResourceBundle run() {
                try {
                    return (ListResourceBundle)ResourceBundle.getBundle(string, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    try {
                        return (ListResourceBundle)ResourceBundle.getBundle(string, new Locale("en", "US"));
                    }
                    catch (MissingResourceException missingResourceException2) {
                        throw new MissingResourceException("Could not load any resource bundle by " + string, string, "");
                    }
                }
            }
        });
    }
}

