/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.generic.AnnotationEntryGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.NamedAndTyped;
import com.sun.org.apache.bcel.internal.generic.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class FieldGenOrMethodGen
extends AccessFlags
implements NamedAndTyped,
Cloneable {
    private String name;
    private Type type;
    private ConstantPoolGen cp;
    private final List<Attribute> attributeList = new ArrayList<Attribute>();
    private final List<AnnotationEntryGen> annotationList = new ArrayList<AnnotationEntryGen>();

    protected FieldGenOrMethodGen() {
    }

    protected FieldGenOrMethodGen(int access_flags) {
        super(access_flags);
    }

    @Override
    public void setType(Type type) {
        if (type.getType() == 16) {
            throw new IllegalArgumentException("Type can not be " + type);
        }
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen cp) {
        this.cp = cp;
    }

    public void addAttribute(Attribute a) {
        this.attributeList.add(a);
    }

    public void addAnnotationEntry(AnnotationEntryGen ag) {
        this.annotationList.add(ag);
    }

    public void removeAttribute(Attribute a) {
        this.attributeList.remove(a);
    }

    public void removeAnnotationEntry(AnnotationEntryGen ag) {
        this.annotationList.remove(ag);
    }

    public void removeAttributes() {
        this.attributeList.clear();
    }

    public void removeAnnotationEntries() {
        this.annotationList.clear();
    }

    public Attribute[] getAttributes() {
        return this.attributeList.toArray(new Attribute[0]);
    }

    public AnnotationEntryGen[] getAnnotationEntries() {
        return this.annotationList.toArray(new AnnotationEntryGen[0]);
    }

    public abstract String getSignature();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }
}

