/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SourceFile
extends Attribute {
    private int sourceFileIndex;

    public SourceFile(SourceFile c) {
        this(c.getNameIndex(), c.getLength(), c.getSourceFileIndex(), c.getConstantPool());
    }

    SourceFile(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, input.readUnsignedShort(), constant_pool);
    }

    public SourceFile(int name_index, int length, int sourceFileIndex, ConstantPool constantPool) {
        super((byte)0, name_index, length, constantPool);
        this.sourceFileIndex = sourceFileIndex;
    }

    @Override
    public void accept(Visitor v) {
        v.visitSourceFile(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.sourceFileIndex);
    }

    public int getSourceFileIndex() {
        return this.sourceFileIndex;
    }

    public void setSourceFileIndex(int sourceFileIndex) {
        this.sourceFileIndex = sourceFileIndex;
    }

    public String getSourceFileName() {
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(this.sourceFileIndex, (byte)1);
        return c.getBytes();
    }

    @Override
    public String toString() {
        return "SourceFile: " + this.getSourceFileName();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        return (Attribute)this.clone();
    }
}

