/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.NativeCipher;
import com.oracle.security.ucrypto.NativeKey;
import com.oracle.security.ucrypto.NativeRSAKeyFactory;
import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoMech;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.util.KeyUtil;

public class NativeRSACipher
extends CipherSpi {
    private final UcryptoMech mech;
    private final int padLen;
    private final NativeRSAKeyFactory keyFactory;
    private AlgorithmParameterSpec spec;
    private SecureRandom random;
    private static final Map<Key, NativeKey> keyList = Collections.synchronizedMap(new WeakHashMap());
    private NativeKey key = null;
    private int outputSize = 0;
    private boolean encrypt = true;
    private byte[] buffer;
    private int bufOfs = 0;

    NativeRSACipher(UcryptoMech ucryptoMech, int n) throws NoSuchAlgorithmException {
        this.mech = ucryptoMech;
        this.padLen = n;
        this.keyFactory = new NativeRSAKeyFactory();
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unsupported mode " + string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Unsupported padding " + string);
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected synchronized int engineGetOutputSize(int n) {
        return this.outputSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAKey)) {
            throw new InvalidKeyException("RSAKey required. Got: " + key.getClass().getName());
        }
        int n = ((RSAKey)((Object)key)).getModulus().bitLength();
        int n2 = n + 7 >> 3;
        return n2 * 8;
    }

    @Override
    protected synchronized void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("init() failed", invalidAlgorithmParameterException);
        }
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        boolean bl;
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidAlgorithmParameterException("Unsupported mode: " + n);
        }
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof TlsRsaPremasterSecretParameterSpec)) {
                throw new InvalidAlgorithmParameterException("No Parameters can be specified");
            }
            this.spec = algorithmParameterSpec;
            if (secureRandom == null) {
                secureRandom = JCAUtil.getSecureRandom();
            }
            this.random = secureRandom;
        }
        boolean bl2 = bl = n == 1 || n == 3;
        if (bl && !(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("RSAPublicKey required for encryption. Received: " + key.getClass().getName());
        }
        if (!bl && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("RSAPrivateKey required for decryption. Received: " + key.getClass().getName());
        }
        NativeKey nativeKey = null;
        nativeKey = keyList.get(key);
        if (nativeKey == null) {
            block15: {
                if (bl) {
                    RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                    try {
                        nativeKey = (NativeKey)((Object)this.keyFactory.engineGeneratePublic(new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent())));
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        throw new InvalidKeyException(invalidKeySpecException);
                    }
                }
                try {
                    if (key instanceof RSAPrivateCrtKey) {
                        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                        nativeKey = (NativeKey)((Object)this.keyFactory.engineGeneratePrivate(new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient())));
                        break block15;
                    }
                    if (key instanceof RSAPrivateKey) {
                        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                        nativeKey = (NativeKey)((Object)this.keyFactory.engineGeneratePrivate(new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent())));
                        break block15;
                    }
                    throw new InvalidKeyException("Unsupported type of RSAPrivateKey. Received: " + key.getClass().getName());
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    throw new InvalidKeyException(invalidKeySpecException);
                }
            }
            keyList.put(key, nativeKey);
        }
        this.init(bl, nativeKey);
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("No Parameters can be specified");
        }
        this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    @Override
    protected synchronized byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            this.update(byArray, n, n2);
        }
        return null;
    }

    @Override
    protected synchronized int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (byArray2.length - n3 < this.outputSize) {
            throw new ShortBufferException("Output buffer too small. outputSize: " + this.outputSize + ". out.length: " + byArray2.length + ". outOfs: " + n3);
        }
        if (n2 > 0) {
            this.update(byArray, n, n2);
        }
        return 0;
    }

    @Override
    protected synchronized byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = new byte[this.outputSize];
        try {
            int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            if (n3 != this.outputSize) {
                return Arrays.copyOf(byArray2, n3);
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new UcryptoException("Internal Error", shortBufferException);
        }
    }

    @Override
    protected synchronized int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (n2 != 0) {
            this.update(byArray, n, n2);
        }
        return this.doFinal(byArray2, n3, byArray2.length - n3);
    }

    @Override
    protected synchronized byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        try {
            byte[] byArray = key.getEncoded();
            if (byArray == null || byArray.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            if (byArray.length > this.buffer.length) {
                throw new InvalidKeyException("Key is too long for wrapping. encodedKey.length: " + byArray.length + ". buffer.length: " + this.buffer.length);
            }
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new UcryptoException("Internal Error", badPaddingException);
        }
    }

    @Override
    protected synchronized Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (byArray.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping. wrappedKey.length: " + byArray.length + ". buffer.length: " + this.buffer.length);
        }
        boolean bl = string.equals("TlsRsaPremasterSecret");
        BadPaddingException badPaddingException = null;
        byte[] byArray2 = null;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException2) {
            if (bl) {
                badPaddingException = badPaddingException2;
            }
            throw new InvalidKeyException("Unwrapping failed", badPaddingException2);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Unwrapping failed", exception);
        }
        if (bl) {
            if (!(this.spec instanceof TlsRsaPremasterSecretParameterSpec)) {
                throw new IllegalStateException("No TlsRsaPremasterSecretParameterSpec specified");
            }
            byArray2 = KeyUtil.checkTlsPreMasterSecretKey(((TlsRsaPremasterSecretParameterSpec)this.spec).getClientVersion(), ((TlsRsaPremasterSecretParameterSpec)this.spec).getServerVersion(), this.random, byArray2, badPaddingException != null);
        }
        return NativeCipher.constructKey(n, byArray2, string);
    }

    private static native int nativeAtomic(int var0, boolean var1, long var2, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9);

    private void init(boolean bl, NativeKey nativeKey) {
        this.encrypt = bl;
        this.key = nativeKey;
        try {
            this.outputSize = this.engineGetKeySize(nativeKey) / 8;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new UcryptoException("Internal Error", invalidKeyException);
        }
        this.buffer = new byte[this.outputSize];
        this.bufOfs = 0;
    }

    private void update(byte[] byArray, int n, int n2) {
        if (n2 <= 0 || byArray == null) {
            return;
        }
        if (this.bufOfs + n2 + (this.encrypt ? this.padLen : 0) > this.buffer.length) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufOfs, n2);
        this.bufOfs += n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doFinal(byte[] byArray, int n, int n2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.bufOfs > this.buffer.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + (this.buffer.length - (this.encrypt ? this.padLen : 0)) + " bytes");
        }
        if (n2 < this.outputSize) {
            throw new ShortBufferException();
        }
        try {
            long l = this.key.value();
            int n3 = NativeRSACipher.nativeAtomic(this.mech.value(), this.encrypt, l, this.key.length(), this.buffer, this.bufOfs, byArray, n, n2);
            if (n3 < 0) {
                if (n3 == -16 || n3 == -64) {
                    UcryptoException ucryptoException = new UcryptoException(16);
                    BadPaddingException badPaddingException = new BadPaddingException("Invalid encryption data");
                    badPaddingException.initCause(ucryptoException);
                    throw badPaddingException;
                }
                throw new UcryptoException(-n3);
            }
            int n4 = n3;
            return n4;
        }
        finally {
            this.bufOfs = 0;
        }
    }

    public static final class PKCS1Padding
    extends NativeRSACipher {
        public PKCS1Padding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_RSA_PKCS, 11);
        }
    }

    public static final class NoPadding
    extends NativeRSACipher {
        public NoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_RSA_X_509, 0);
        }
    }
}

