/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public final class ExtKeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.ExtKeyUsage";
    public static final String NAME = "ExtKeyUsage";
    public static final String EXT_KEY_USAGE = "extkeyusage";
    private Vector<ObjectIdentifier> keyPurposes = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.ExtKeyUsageExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.keyPurposes == null || this.keyPurposes.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.keyPurposes.size(); ++i) {
            ObjectIdentifier oid = this.keyPurposes.elementAt(i);
            tmp.putOID(oid);
        }
        os.write((byte)48, tmp);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    private boolean validExtKeyPurposeOID(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "validExtKeyPurposeOID", oid);
        }
        if (oid.equals(PKIXExtensions.ServerAuth_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_1", true);
            }
            return true;
        }
        if (oid.equals(PKIXExtensions.ClientAuth_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_2", true);
            }
            return true;
        }
        if (oid.equals(PKIXExtensions.CodeSigning_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_3", true);
            }
            return true;
        }
        if (oid.equals(PKIXExtensions.EmailProtection_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_4", true);
            }
            return true;
        }
        if (oid.equals(PKIXExtensions.IPSecEndSystem_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_5", true);
            }
            return true;
        }
        if (oid.equals(PKIXExtensions.IPSecTunnel_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_6", true);
            }
            return true;
        }
        if (oid.equals(PKIXExtensions.IPSecUser_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_7", true);
            }
            return true;
        }
        if (oid.equals(PKIXExtensions.TimeStamping_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_8", true);
            }
            return true;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_9", false);
        }
        return false;
    }

    public ExtKeyUsageExtension(Vector<ObjectIdentifier> keyPurpose) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ExtKeyUsageExtension", keyPurpose);
        }
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = false;
        if (keyPurpose == null || keyPurpose.size() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "ExtKeyUsageExtension", "keyPurpose is null or empty.");
            }
            throw new IllegalArgumentException("keyPurpose is null or empty.");
        }
        this.keyPurposes = keyPurpose;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "ExtKeyUsageExtension");
        }
    }

    public ExtKeyUsageExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "ExtKeyUsageExtension");
        }
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = false;
        this.keyPurposes = new Vector();
        if (debug != null) {
            debug.exit(16384L, className, "ExtKeyUsageExtension");
        }
    }

    public ExtKeyUsageExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "ExtKeyUsageExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "ExtKeyUsageExtension", "Invalid encoding for ExtKeyUsageExtension.");
            }
            throw new IOException("Invalid encoding for ExtKeyUsageExtension.");
        }
        this.keyPurposes = new Vector();
        while (val.getData().available() != 0) {
            ObjectIdentifier keyPurpose = val.getData().getOID();
            this.keyPurposes.addElement(keyPurpose);
        }
        if (debug != null) {
            debug.exit(16384L, className, "ExtKeyUsageExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.keyPurposes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        String s = super.toString() + "ExtKeyUsage [\r\n";
        if (this.keyPurposes == null || this.keyPurposes.size() == 0) {
            s = s + "\tnull";
        } else {
            for (int i = 0; i < this.keyPurposes.size(); ++i) {
                ObjectIdentifier oid = this.keyPurposes.elementAt(i);
                s = s + "\t" + oid.toString();
            }
        }
        s = s + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", s);
        }
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(EXT_KEY_USAGE)) {
            if (!(obj instanceof Vector)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Vector.");
                }
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
        }
        this.keyPurposes = (Vector)((Vector)obj).clone();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Vector<ObjectIdentifier> get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(EXT_KEY_USAGE)) {
            if (this.keyPurposes != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.keyPurposes.clone());
                }
                return (Vector)this.keyPurposes.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.keyPurposes);
            }
            return this.keyPurposes;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(EXT_KEY_USAGE)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
        }
        this.keyPurposes = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(EXT_KEY_USAGE);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public List<String> getExtendedKeyUsage() {
        ArrayList<String> al = new ArrayList<String>(this.keyPurposes.size());
        for (ObjectIdentifier oid : this.keyPurposes) {
            al.add(oid.toString());
        }
        return al;
    }
}

