/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.AlgorithmDecomposer;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractAlgorithmConstraints
implements AlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    protected AbstractAlgorithmConstraints(AlgorithmDecomposer decomposer) {
        this.decomposer = decomposer;
    }

    static List<String> getAlgorithms(final String propertyName) {
        String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(propertyName);
            }
        });
        String[] algorithmsInProperty = null;
        if (property != null && !property.isEmpty()) {
            if (property.length() >= 2 && property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
                property = property.substring(1, property.length() - 1);
            }
            algorithmsInProperty = property.split(",");
            for (int i = 0; i < algorithmsInProperty.length; ++i) {
                algorithmsInProperty[i] = algorithmsInProperty[i].trim();
            }
        }
        if (algorithmsInProperty == null) {
            algorithmsInProperty = new String[]{};
        }
        if (propertyName.equals("jdk.tls.disabledAlgorithms")) {
            boolean foundDH = false;
            for (int i = 0; i < algorithmsInProperty.length; ++i) {
                if (algorithmsInProperty[i] == null || !algorithmsInProperty[i].toLowerCase(Locale.ENGLISH).startsWith("dh")) continue;
                foundDH = true;
                break;
            }
            if (!foundDH) {
                String[] largerAlgorithmsInProperty = new String[algorithmsInProperty.length + 1];
                System.arraycopy(algorithmsInProperty, 0, largerAlgorithmsInProperty, 0, algorithmsInProperty.length);
                largerAlgorithmsInProperty[largerAlgorithmsInProperty.length - 1] = "DH keySize < 768";
                return new ArrayList<String>(Arrays.asList(largerAlgorithmsInProperty));
            }
        }
        return new ArrayList<String>(Arrays.asList(algorithmsInProperty));
    }

    public static boolean checkAlgorithm(String[] algorithms, String algorithm, AlgorithmDecomposer decomposer) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < algorithms.length; ++i) {
            list.add(algorithms[i]);
        }
        return AbstractAlgorithmConstraints.checkAlgorithm(list, algorithm, decomposer);
    }

    protected static boolean checkAlgorithm(List<String> algorithms, String algorithm, AlgorithmDecomposer decomposer) {
        if (algorithm == null || algorithm.isEmpty()) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        Set<String> elements = null;
        for (String item : algorithms) {
            if (item == null || item.isEmpty()) continue;
            if (item.equalsIgnoreCase(algorithm)) {
                return false;
            }
            if (elements == null) {
                elements = decomposer.decompose(algorithm);
            }
            for (String element : elements) {
                if (!item.equalsIgnoreCase(element)) continue;
                return false;
            }
        }
        return true;
    }
}

