/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X500Signer;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import sun.security.util.SignatureUtil;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertAndKeyGen";

    public CertAndKeyGen(String keyType, String sigAlg) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "CertAndKeyGen", keyType, sigAlg);
        }
        this.keyGen = KeyPairGenerator.getInstance(keyType);
        this.sigAlg = sigAlg;
        if (debug != null) {
            debug.exit(16384L, className, "CertAndKeyGen");
        }
    }

    public CertAndKeyGen(String keyType, String sigAlg, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            Object[] parms = new Object[]{keyType, sigAlg, provider};
            debug.entry(16384L, (Object)className, "CertAndKeyGen", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
            this.keyGen = KeyPairGenerator.getInstance(keyType, provider);
        } else {
            this.keyGen = KeyPairGenerator.getInstance(keyType);
        }
        this.sigAlg = sigAlg;
        if (debug != null) {
            debug.exit(16384L, className, "CertAndKeyGen");
        }
    }

    public void setRandom(SecureRandom generator) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setRandom", generator);
            debug.exit(16384L, className, "setRandom");
        }
        this.prng = generator;
    }

    public void generate(int keyBits) throws InvalidKeyException {
        KeyPair pair;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generate", new Integer(keyBits));
        }
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(keyBits, this.prng);
            pair = this.keyGen.generateKeyPair();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "generate", e);
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
        if (debug != null) {
            debug.exit(16384L, className, "generate");
        }
    }

    public void generate(AlgorithmParameterSpec params) throws InvalidKeyException {
        KeyPair pair;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generate", params);
        }
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(params, this.prng);
            pair = this.keyGen.generateKeyPair();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "generate", e);
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
        if (debug != null) {
            debug.exit(16384L, className, "generate");
        }
    }

    public X509Key getPublicKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getPublicKey");
        }
        if (!(this.publicKey instanceof X509Key)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPublicKey_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPublicKey_2", (X509Key)this.publicKey);
        }
        return (X509Key)this.publicKey;
    }

    public PublicKey getPublicKeyAnyway() {
        return this.publicKey;
    }

    public Key newGetPublicKey() {
        if (debug != null) {
            debug.entry(16384L, className, "newGetPublicKey");
            debug.exit(16384L, (Object)className, "newGetPublicKey", this.publicKey);
        }
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getPrivateKey");
            debug.exit(16384L, (Object)className, "getPrivateKey", this.privateKey);
        }
        return this.privateKey;
    }

    public KeyPairGenerator getKeyPairGenerator() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyPairGenerator");
            debug.exit(16384L, (Object)className, "getKeyPairGenerator", this.keyGen);
        }
        return this.keyGen;
    }

    public X509Certificate getSelfCert(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            if (debug != null) {
                Object[] parms = new Object[]{myname, new Long(validity)};
                debug.entry(16384L, (Object)className, "getSelfCert", parms);
            }
            X500Signer issuer = this.getSigner2(myname);
            Date firstDate = new Date();
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 1000L);
            CertAndKeyGen.checkValidityDate(lastDate);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(2));
            info.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
            AlgorithmId algID = issuer.getAlgorithmId();
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", myname);
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", issuer.getSigner());
            X509CertImpl cert = new X509CertImpl(info);
            if (this.provider == null) {
                cert.sign(this.privateKey, this.sigAlg);
            } else {
                cert.sign(this.privateKey, this.sigAlg, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCert", cert);
            }
            return cert;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCert", e);
            }
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public X509Certificate getSelfCert(X500Name myname, long validity, AlgorithmParameterSpec sigParameterSpec) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return this.dogetSelfCert(myname, validity, sigParameterSpec);
    }

    public X509Certificate dogetSelfCert(X500Name myname, long validity, AlgorithmParameterSpec sigParameterSpec) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        try {
            if (debug != null) {
                Object[] parms = new Object[]{myname, new Long(validity), sigParameterSpec};
                debug.entry(16384L, (Object)className, "getSelfCert", parms);
            }
            X500Signer issuer = this.getSigner2(myname, sigParameterSpec);
            Date firstDate = new Date();
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 1000L);
            CertAndKeyGen.checkValidityDate(lastDate);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(2));
            info.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
            AlgorithmId algID = issuer.getAlgorithmId();
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", myname);
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", issuer.getSigner());
            X509CertImpl cert = new X509CertImpl(info);
            if (this.provider == null) {
                cert.sign(this.privateKey, this.sigAlg, sigParameterSpec);
            } else {
                cert.sign(this.privateKey, this.sigAlg, this.provider, sigParameterSpec);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCert", cert);
            }
            return cert;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCert", e);
            }
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, className, "getSelfCertificate", myname, new Long(validity));
            debug.exit(16384L, (Object)className, "getSelfCertificate", this.getSelfCertificate(myname, validity, 2));
        }
        return this.getSelfCertificate(myname, validity, 2);
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity, int version) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            if (debug != null) {
                Object[] parms = new Object[]{myname, new Long(validity), new Integer(version)};
                debug.entry(16384L, (Object)className, "getSelfCertificate", parms);
            }
            X500Signer issuer = this.getSigner(myname);
            Date firstDate = new Date();
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 1000L);
            CertAndKeyGen.checkValidityDate(lastDate);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            if (version != 0 && version != 1 && version != 2) {
                info.set("version", new CertificateVersion(2));
            } else {
                info.set("version", new CertificateVersion(version));
            }
            info.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
            AlgorithmId algID = issuer.getAlgorithmId();
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", myname);
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", issuer.getSigner());
            X509CertImpl cert = new X509CertImpl(info);
            if (this.provider == null) {
                cert.sign(this.privateKey, this.sigAlg);
            } else {
                cert.sign(this.privateKey, this.sigAlg, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCertificate", cert);
            }
            return cert;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCertificate", e);
            }
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity, int version, AlgorithmParameterSpec sigAlgParamSpec) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        try {
            if (debug != null) {
                Object[] parms = new Object[]{myname, new Long(validity), new Integer(version)};
                debug.entry(16384L, (Object)className, "getSelfCertificate", parms);
            }
            X500Signer issuer = this.getSigner(myname, sigAlgParamSpec);
            Date firstDate = new Date();
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 1000L);
            CertAndKeyGen.checkValidityDate(lastDate);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            if (version != 0 && version != 1 && version != 2) {
                info.set("version", new CertificateVersion(2));
            } else {
                info.set("version", new CertificateVersion(version));
            }
            info.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
            AlgorithmId algID = issuer.getAlgorithmId();
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", myname);
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", issuer.getSigner());
            X509CertImpl cert = new X509CertImpl(info);
            if (this.provider == null) {
                cert.sign(this.privateKey, this.sigAlg, sigAlgParamSpec);
            } else {
                cert.sign(this.privateKey, this.sigAlg, this.provider, sigAlgParamSpec);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCertificate", cert);
            }
            return cert;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCertificate", e);
            }
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(myname, firstDate, validity, null);
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity, CertificateExtensions ext) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            if (debug != null) {
                Object[] parms = new Object[]{myname, firstDate, new Long(validity)};
                debug.entry(16384L, (Object)className, "getSelfCertificate", parms);
            }
            Date lastDate = new Date();
            lastDate.setTime(firstDate.getTime() + validity * 1000L);
            CertAndKeyGen.checkValidityDate(lastDate);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(2));
            info.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
            AlgorithmId algID = AlgorithmId.get(this.sigAlg);
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", myname);
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", myname);
            if (ext != null) {
                info.set("extensions", ext);
            }
            X509CertImpl cert = new X509CertImpl(info);
            cert.sign(this.privateKey, this.sigAlg);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCertificate", cert);
            }
            return cert;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCertificate", e);
            }
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity, CertificateExtensions ext, AlgorithmParameterSpec sigAlgParameterSpec) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return this.dogetSelfCertificate(myname, firstDate, validity, ext, sigAlgParameterSpec);
    }

    public X509Certificate dogetSelfCertificate(X500Name myname, Date firstDate, long validity, CertificateExtensions ext, AlgorithmParameterSpec sigAlgParameterSpec) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        try {
            if (debug != null) {
                Object[] parms = new Object[]{myname, firstDate, new Long(validity)};
                debug.entry(16384L, (Object)className, "getSelfCertificate", parms);
            }
            Date lastDate = new Date();
            lastDate.setTime(firstDate.getTime() + validity * 1000L);
            CertAndKeyGen.checkValidityDate(lastDate);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(2));
            info.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
            AlgorithmId algID = AlgorithmId.get(this.sigAlg);
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", myname);
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", myname);
            if (ext != null) {
                info.set("extensions", ext);
            }
            X509CertImpl cert = new X509CertImpl(info);
            cert.sign(this.privateKey, this.sigAlg, sigAlgParameterSpec);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCertificate", cert);
            }
            return cert;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCertificate", e);
            }
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public CertificationRequest getCertRequest(X500Name myname) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        CertificationRequest req2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCertRequest", myname);
        }
        CertificationRequestInfo cri = new CertificationRequestInfo(myname, this.publicKey, null, this.provider);
        CertificationRequest req = new CertificationRequest(cri, this.provider);
        try {
            req2 = req.sign(this.sigAlg, this.privateKey);
        }
        catch (PKCSException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getCertRequest", e);
            }
            throw new SignatureException(this.sigAlg + " PKCSException");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertRequest", req2);
        }
        return req2;
    }

    private X500Signer getSigner(X500Name me) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        AlgorithmParameters sigParams;
        Signature signature;
        block7: {
            signature = null;
            sigParams = null;
            if (debug != null) {
                debug.entry(16384L, (Object)className, "getSigner", me);
            }
            signature = this.provider != null ? Signature.getInstance(this.sigAlg, this.provider) : Signature.getInstance(this.sigAlg);
            try {
                sigParams = signature.getParameters();
            }
            catch (UnsupportedOperationException e) {
                sigParams = null;
                if (debug == null) break block7;
                debug.text(16384L, className, "getSigner", "Signature does not support AlgorithmParameters");
            }
        }
        try {
            SignatureUtil.initSignWithParam(signature, this.privateKey, SignatureUtil.getParamSpec(this.sigAlg, sigParams), null);
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigner", new X500Signer(signature, me));
        }
        return new X500Signer(signature, me);
    }

    private X500Signer getSigner(X500Name me, AlgorithmParameterSpec sigParameterSpec) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, SignatureException {
        Signature signature = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSigner", new Object[]{me, sigParameterSpec});
        }
        signature = this.provider != null ? Signature.getInstance(this.sigAlg, this.provider) : Signature.getInstance(this.sigAlg);
        if (sigParameterSpec != null) {
            signature.setParameter(sigParameterSpec);
        }
        try {
            SignatureUtil.initSignWithParam(signature, this.privateKey, sigParameterSpec, null);
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigner", new X500Signer(signature, me));
        }
        return new X500Signer(signature, me, sigParameterSpec);
    }

    private X500Signer getSigner2(X500Name me) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        Signature signature = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSigner", me);
        }
        signature = this.provider != null ? Signature.getInstance(this.sigAlg, this.provider) : Signature.getInstance(this.sigAlg);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigner", new X500Signer(signature, me));
        }
        return new X500Signer(signature, me);
    }

    private X500Signer getSigner2(X500Name me, AlgorithmParameterSpec sigParameterSpec) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        Signature signature = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSigner", new Object[]{me, sigParameterSpec});
        }
        signature = this.provider != null ? Signature.getInstance(this.sigAlg, this.provider) : Signature.getInstance(this.sigAlg);
        if (sigParameterSpec != null) {
            signature.setParameter(sigParameterSpec);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigner", new X500Signer(signature, me));
        }
        return new X500Signer(signature, me, sigParameterSpec);
    }

    private static void checkValidityDate(Date lastDate) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "checkValidityDate", lastDate);
        }
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        c.setTime(lastDate);
        if (c.get(1) > 9999) {
            throw new CertificateException("Validity period ends at calendar year " + c.get(1) + " which is greater than 9999");
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "checkValidityDate", lastDate);
        }
    }
}

