/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;

public final class PKCS12 {
    static final String MAC_ALGORITHM = "SHA1";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PKCS12";
    public static final byte KEY_ID = 1;
    public static final byte IV_ID = 2;
    public static final byte MAC_ID = 3;
    public static final int NO_ENCRYPT = 1;
    public static final int PASSWD_ENCRYPT = 2;
    public static final int PUBKEY_ENCRYPT = 3;

    private PKCS12() {
    }

    private PKCS12(String provider) {
    }

    public static byte[] genKey(byte id, String digestAlg, char[] pwd, byte[] salt, int iterations, int keysize) throws NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{new Byte(id), digestAlg, pwd, salt, new Integer(iterations), new Integer(keysize)};
            debug.entry(49152L, (Object)className, "genKey", parms);
            debug.exit(49152L, className, "genKey");
        }
        return PKCS12.genKey(id, digestAlg, pwd, salt, iterations, keysize, null);
    }

    public static byte[] genKey(byte id, String digestAlg, char[] pwd, byte[] salt, int iterations, int keysize, String provider) throws NoSuchAlgorithmException {
        int v;
        int u;
        if (debug != null) {
            Object[] parms = new Object[]{new Byte(id), digestAlg, pwd, salt, new Integer(iterations), new Integer(keysize), provider};
            debug.entry(49152L, (Object)className, "genKey", parms);
        }
        if (id != 1 && id != 2 && id != 3) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Illegal identifier byte: " + id + ". Must be one of 1, 2 or 3.");
            }
            throw new IllegalArgumentException("Illegal identifier byte: " + id + ". Must be one of 1, 2 or 3.");
        }
        if (digestAlg == null || digestAlg.length() == 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "No digest algorithm specified.");
            }
            throw new IllegalArgumentException("No digest algorithm specified.");
        }
        if (iterations <= 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Iterations must be greater than zero.");
            }
            throw new IllegalArgumentException("Iterations must be greater than zero.");
        }
        if (keysize <= 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Keybits must be greater than zero.");
            }
            throw new IllegalArgumentException("Keybits must be greater than zero.");
        }
        if (digestAlg.equalsIgnoreCase("SHA") || digestAlg.equalsIgnoreCase(MAC_ALGORITHM) || digestAlg.equalsIgnoreCase("SHA-1")) {
            u = 20;
            v = 64;
        } else if (digestAlg.equalsIgnoreCase("MD2") || digestAlg.equalsIgnoreCase("MD5")) {
            u = 16;
            v = 64;
        } else {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Unsupported digest algorithm: " + digestAlg + ".  Must be one of SHA, MD2 or MD5.");
            }
            throw new IllegalArgumentException("Unsupported digest algorithm: " + digestAlg + ".  Must be one of SHA, MD2 or MD5.");
        }
        byte[] passwd = PKCS12Utils.ascii2bmp(pwd);
        MessageDigest md = null;
        if (provider != null) {
            try {
                md = MessageDigest.getInstance(digestAlg, provider);
            }
            catch (NoSuchProviderException nspe) {
                if (debug != null) {
                    debug.text(49152L, className, "genKey", "provider " + provider + " not found");
                }
                throw new IllegalArgumentException("provider " + provider + " not found");
            }
        } else {
            md = MessageDigest.getInstance(digestAlg);
        }
        int c = PKCS12.roundup(keysize, u) / u;
        byte[] D = new byte[v];
        int s = PKCS12.roundup(salt.length, v);
        int p = PKCS12.roundup(passwd.length, v);
        byte[] I = new byte[s + p];
        byte[] key = new byte[keysize];
        Arrays.fill(D, id);
        PKCS12.concat(salt, I, 0, s);
        PKCS12.concat(passwd, I, s, p);
        byte[] B = new byte[v];
        byte[] tmp = new byte[v];
        int i = 0;
        while (true) {
            md.update(D);
            md.update(I);
            byte[] Ai = md.digest();
            for (int r = 1; r < iterations; ++r) {
                Ai = md.digest(Ai);
            }
            System.arraycopy(Ai, 0, key, u * i, Math.min(keysize, u));
            if (i + 1 == c) break;
            PKCS12.concat(Ai, B, 0, B.length);
            BigInteger B1 = new BigInteger(1, B).add(BigInteger.ONE);
            for (int j = 0; j < I.length; j += v) {
                if (tmp.length != v) {
                    tmp = new byte[v];
                }
                System.arraycopy(I, j, tmp, 0, v);
                BigInteger Ij = new BigInteger(1, tmp);
                Ij = Ij.add(B1);
                tmp = Ij.toByteArray();
                int trunc = tmp.length - v;
                if (trunc >= 0) {
                    System.arraycopy(tmp, trunc, I, j, v);
                    continue;
                }
                if (trunc >= 0) continue;
                Arrays.fill(I, j, j + -trunc, (byte)0);
                System.arraycopy(tmp, 0, I, j + -trunc, tmp.length);
            }
            ++i;
            keysize -= u;
        }
        Arrays.fill(passwd, (byte)0);
        if (debug != null) {
            debug.exit(49152L, (Object)className, "genKey", key);
        }
        return key;
    }

    private static int roundup(int x, int y) {
        if (debug != null) {
            debug.entry(49152L, className, "roundup", new Integer(x), new Integer(y));
            debug.exit(49152L, (Object)className, "roundup", (x + (y - 1)) / y * y);
        }
        return (x + (y - 1)) / y * y;
    }

    private static void concat(byte[] src, byte[] dst, int start, int len) {
        int loop = len / src.length;
        if (debug != null) {
            Object[] parms = new Object[]{src, dst, new Integer(start), new Integer(len)};
            debug.entry(49152L, (Object)className, "concat", parms);
        }
        int i = 0;
        int off = 0;
        while (i < loop) {
            System.arraycopy(src, 0, dst, off + start, src.length);
            ++i;
            off += src.length;
        }
        System.arraycopy(src, 0, dst, off + start, len - off);
        if (debug != null) {
            debug.exit(49152L, className, "concat");
        }
    }
}

