/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.NonPrintableAsciiEncryptDecrypt;
import com.ibm.security.cmskeystore.RecordEncoding;
import com.ibm.security.cmskeystore.RecordEncodingFactory$RecordEncodingImpl;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

final class RecordEncodingFactory {
    private static final byte[] NON_DEFAULT_KEY_FLAGS = new byte[]{7, -128};
    private static final byte[] DEFAULT_KEY_FLAGS = new byte[]{6, -64};
    private static final byte[] UNTRUSTED_CERT_FLAGS = new byte[]{7, 0};
    private static final byte[] TRUSTED_CERT_FLAGS = new byte[]{7, -128};
    private static final Boolean IBMJCE_FOUND = RecordEncodingFactory.checkForIBMJCEProvider();

    private static boolean checkForIBMJCEProvider() {
        return Security.getProvider("IBMJCE") != null || Security.getProvider("IBMJCEPlus") != null;
    }

    private RecordEncodingFactory() {
        throw new UnsupportedOperationException();
    }

    public static RecordEncoding newRecordEncoding(Buffer buffer) throws IOException {
        return new RecordEncodingFactory$RecordEncodingImpl(buffer);
    }

    public static RecordEncoding newRecordEncoding(int n, Certificate certificate, String string, boolean bl) throws CertificateEncodingException, IOException {
        byte[] byArray = certificate.getEncoded();
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(n);
        derOutputStream.putTag((byte)-128, true, (byte)1);
        derOutputStream.putLength(byArray.length);
        derOutputStream.write(byArray);
        derOutputStream.putVisibleString(string);
        derOutputStream.write(3);
        derOutputStream.putLength(2);
        derOutputStream.write(bl ? TRUSTED_CERT_FLAGS : UNTRUSTED_CERT_FLAGS);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return new RecordEncodingFactory$RecordEncodingImpl(IntableByteSequenceFactory.newIntableByteSequence(derOutputStream2.size()), ByteSequenceFactory.newByteSequence(derOutputStream2.toByteArray()));
    }

    public static RecordEncoding newKeyRecordEncoding(int n, Certificate certificate, PrivateKey privateKey, char[] cArray, String string, boolean bl) throws IOException, PKCSException, CertificateEncodingException, NoSuchAlgorithmException {
        Object object;
        PrivateKeyInfo privateKeyInfo;
        String string2;
        String string3;
        byte[] byArray = null;
        if (IBMJCE_FOUND.booleanValue()) {
            string3 = "PBEWithSHAAnd3KeyTripleDES";
            string2 = "3KeyTripleDES";
        } else {
            string3 = "PBEWithSHA1AndDESede";
            string2 = "DESede";
        }
        String string4 = "SHA1";
        if (RecordEncodingFactory.isPrintable(cArray)) {
            privateKeyInfo = new PrivateKeyInfo(privateKey.getEncoded());
            object = new EncryptedPrivateKeyInfo(cArray, privateKeyInfo, string4, string2);
            byArray = object.encode();
        } else {
            byArray = NonPrintableAsciiEncryptDecrypt.encrypt(cArray, privateKey, AlgorithmId.get((String)string3));
        }
        privateKeyInfo = new DerOutputStream();
        privateKeyInfo.putSequence(new DerValue[]{new DerValue(certificate.getEncoded()), new DerValue(byArray)});
        object = privateKeyInfo.toByteArray();
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(n);
        derOutputStream.putTag((byte)-128, true, (byte)2);
        derOutputStream.putLength(((EncryptedPrivateKeyInfo)object).length);
        derOutputStream.write((byte[])object);
        derOutputStream.putVisibleString(string);
        derOutputStream.write(3);
        derOutputStream.putLength(2);
        derOutputStream.write(bl ? DEFAULT_KEY_FLAGS : NON_DEFAULT_KEY_FLAGS);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return new RecordEncodingFactory$RecordEncodingImpl(IntableByteSequenceFactory.newIntableByteSequence(derOutputStream2.size()), ByteSequenceFactory.newByteSequence(derOutputStream2.toByteArray()));
    }

    private static boolean isPrintable(char[] cArray) {
        for (char c : cArray) {
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    static boolean access$000(char[] cArray) {
        return RecordEncodingFactory.isPrintable(cArray);
    }
}

