/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import java.security.InvalidParameterException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class NonPrintableAsciiPBEKey
implements SecretKey {
    private byte[] keyData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NonPrintableAsciiPBEKey(KeySpec keySpec) {
        char[] cArray = null;
        try {
            if (!(keySpec instanceof PBEKeySpec)) {
                throw new InvalidParameterException("spec must be PBEKeySpec");
            }
            PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
            cArray = pBEKeySpec.getPassword();
            if (cArray == null || cArray.length == 0) {
                throw new InvalidParameterException("password is null or empty");
            }
            this.keyData = new byte[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] >= '\u0080') {
                    Arrays.fill(this.keyData, (byte)0);
                    throw new InvalidParameterException("password is not ASCII");
                }
                this.keyData[i] = (byte)cArray[i];
            }
            if (cArray == null) return;
        }
        catch (Throwable throwable) {
            if (cArray == null) throw throwable;
            Arrays.fill(cArray, ' ');
            throw throwable;
        }
        Arrays.fill(cArray, ' ');
    }

    public String getAlgorithm() {
        return "PBE";
    }

    public byte[] getEncoded() {
        return this.keyData;
    }

    public String getFormat() {
        return "RAW";
    }
}

