/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.auth.kerberos.KrbServicePermissionCollection;

public final class ServicePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -1227585031618624935L;
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    public ServicePermission(String string, String string2) {
        super(string);
        this.init(string, ServicePermission.getMask(string2));
    }

    private void init(String string, int n) {
        if (string == null) {
            throw new NullPointerException("service principal can't be null");
        }
        if ((n & 3) != n) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.mask = n;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        return (this.mask & servicePermission.mask) == servicePermission.mask && this.impliesIgnoreMask(servicePermission);
    }

    boolean impliesIgnoreMask(ServicePermission servicePermission) {
        return this.getName().equals("*") || this.getName().equals(servicePermission.getName()) || servicePermission.getName().startsWith("@") && this.getName().endsWith(servicePermission.getName());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)object;
        return (this.mask & servicePermission.mask) == servicePermission.mask && this.getName().equals(servicePermission.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() ^ this.mask;
    }

    private static String getActions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((n & 1) == 1) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("initiate");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("accept");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = ServicePermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new KrbServicePermissionCollection();
    }

    int getMask() {
        return this.mask;
    }

    private static int getMask(String string) {
        int n;
        if (string == null) {
            throw new NullPointerException("action can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        int n2 = 0;
        if (string == null) {
            return n2;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length == 1 && cArray[0] == '-') {
            return n2;
        }
        for (int i = cArray.length - 1; i != -1; i -= n) {
            char c;
            while (i != -1 && ((c = cArray[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 7 || cArray[i - 7] != 'i' && cArray[i - 7] != 'I' || cArray[i - 6] != 'n' && cArray[i - 6] != 'N' || cArray[i - 5] != 'i' && cArray[i - 5] != 'I' || cArray[i - 4] != 't' && cArray[i - 4] != 'T' || cArray[i - 3] != 'i' && cArray[i - 3] != 'I' || cArray[i - 2] != 'a' && cArray[i - 2] != 'A' || cArray[i - 1] != 't' && cArray[i - 1] != 'T' || cArray[i] != 'e' && cArray[i] != 'E')) {
                n = 8;
                n2 |= 1;
            } else if (!(i < 5 || cArray[i - 5] != 'a' && cArray[i - 5] != 'A' || cArray[i - 4] != 'c' && cArray[i - 4] != 'C' || cArray[i - 3] != 'c' && cArray[i - 3] != 'C' || cArray[i - 2] != 'e' && cArray[i - 2] != 'E' || cArray[i - 1] != 'p' && cArray[i - 1] != 'P' || cArray[i] != 't' && cArray[i] != 'T')) {
                n = 6;
                n2 |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl = false;
            while (i >= n && !bl) {
                switch (cArray[i - n]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --i;
            }
        }
        return n2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), ServicePermission.getMask(this.actions));
    }
}

