/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class DataHeader {
    protected byte[] eyecatcher;
    protected int length;
    protected int version;
    protected int modification;
    protected String signature;
    boolean ascii = true;
    protected static final int DATAHEADER_SIZE = 16;
    int[] AscToEbcDef = new int[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 37, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 34, 29, 53, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 173, 224, 189, 95, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 79, 208, 161, 7, 67, 32, 33, 28, 35, 235, 36, 155, 113, 40, 56, 73, 144, 186, 236, 223, 69, 41, 42, 157, 114, 43, 138, 154, 103, 86, 100, 74, 83, 104, 89, 70, 234, 218, 44, 222, 139, 85, 65, 254, 88, 81, 82, 72, 105, 219, 142, 141, 115, 116, 117, 250, 21, 176, 177, 179, 180, 181, 106, 183, 184, 185, 204, 188, 171, 62, 59, 10, 191, 143, 58, 20, 160, 23, 203, 202, 26, 27, 156, 4, 52, 239, 30, 6, 8, 9, 119, 112, 190, 187, 172, 84, 99, 101, 102, 98, 48, 66, 71, 87, 238, 51, 182, 225, 205, 237, 54, 68, 206, 207, 49, 170, 252, 158, 174, 140, 221, 220, 57, 251, 128, 175, 253, 120, 118, 178, 159, 255};

    public DataHeader(TraceContext context, ByteBuffer data, String signature) throws IllegalArgumentException {
        this(context, data, signature, true);
    }

    protected DataHeader(TraceContext context, ByteBuffer data, String signature, boolean confirmBody) throws IllegalArgumentException {
        byte[] sigBytes;
        if (data.remaining() < 16) {
            context.error(this, "Truncated data header");
            throw new BufferUnderflowException();
        }
        try {
            sigBytes = signature.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No ascii charset available");
        }
        this.eyecatcher = new byte[sigBytes.length];
        data.get(this.eyecatcher);
        for (int i = 0; i < sigBytes.length; ++i) {
            if (this.eyecatcher[i] == sigBytes[i] && this.ascii) continue;
            if (this.eyecatcher[i] == this.AscToEbcDef[sigBytes[i] & 0xFF]) {
                this.ascii = false;
                continue;
            }
            throw new IllegalArgumentException("Eyecatcher \"" + signature + "\" not found");
        }
        this.length = data.getInt();
        this.version = data.getInt();
        this.modification = data.getInt();
        this.signature = signature;
        if (confirmBody && data.remaining() < this.length - 16) {
            context.error(this, "Truncated " + signature + " section, bytes required: " + (this.length - 16) + ", bytes available: " + data.remaining());
            throw new BufferUnderflowException();
        }
    }

    public String toString() {
        return this.signature + ": eyecatcher:         " + this.eyecatcher + System.getProperty("line.separator") + this.signature + ": length:             " + this.length + System.getProperty("line.separator") + this.signature + ": version:            " + this.version + System.getProperty("line.separator") + this.signature + ": modification:       " + this.modification + System.getProperty("line.separator");
    }
}

