/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.HiddenInstanceField;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;
import java.util.LinkedList;

public class ObjectFieldInfo {
    ValueTypeHelper valueTypeHelper = ValueTypeHelper.getValueTypeHelper();
    J9ROMClassPointer romClass;
    int superclassFieldsSize;
    boolean objectCanUseBackfill;
    public static final int fj9object_t_SizeOf = J9ObjectHelper.compressObjectReferences ? 4 : UDATA.SIZEOF;
    public static final int j9objectmonitor_t_SizeOf;
    int instanceObjectCount = 0;
    int instanceSingleCount = 0;
    int instanceDoubleCount = 0;
    int totalObjectCount = 0;
    int totalSingleCount = 0;
    int totalDoubleCount = 0;
    boolean instanceFieldBackfillEligible;
    int hiddenFieldCount = 0;
    int superclassBackfillOffset;
    int myBackfillOffset;
    int subclassBackfillOffset;
    boolean isValue = false;
    J9ClassPointer containerClazz = J9ClassPointer.NULL;
    int totalFlatFieldDoubleBytes = 0;
    int totalFlatFieldRefBytes = 0;
    int totalFlatFieldSingleBytes = 0;
    int flatAlignedObjectInstanceBackfill = 0;
    int flatAlignedSingleInstanceBackfill = 0;
    int flatUnAlignedObjectInstanceBackfill = 0;
    int flatUnAlignedSingleInstanceBackfill = 0;
    boolean classRequiresPrePadding = false;
    boolean isBackFillPostPadded = false;
    public static final int NO_BACKFILL_AVAILABLE = -1;
    public static final int BACKFILL_SIZE = 4;
    public static final int LOCKWORD_SIZE;
    public static final int FINALIZE_LINK_SIZE;
    private static final int OBJECT_SIZE_INCREMENT_IN_BYTES = 8;

    ObjectFieldInfo(J9ROMClassPointer romClass) {
        this.romClass = romClass;
        this.superclassFieldsSize = -1;
        this.superclassBackfillOffset = -1;
        this.myBackfillOffset = -1;
        this.subclassBackfillOffset = -1;
        this.objectCanUseBackfill = fj9object_t_SizeOf == 4;
        this.instanceFieldBackfillEligible = false;
    }

    ObjectFieldInfo(J9ROMClassPointer romClass, J9ClassPointer clazz) throws CorruptDataException {
        this(romClass);
        this.containerClazz = clazz;
        this.isValue = this.valueTypeHelper.isRomClassAValueType(romClass);
        this.totalFlatFieldDoubleBytes = 0;
        this.totalFlatFieldRefBytes = 0;
        this.totalFlatFieldSingleBytes = 0;
    }

    int getTotalDoubleCount() {
        return this.totalDoubleCount;
    }

    int getTotalObjectCount() {
        return this.totalObjectCount;
    }

    int getTotalSingleCount() {
        return this.totalSingleCount;
    }

    int getNonBackfilledObjectCount() {
        int nonBackfilledObjects = this.totalObjectCount;
        if (this.isBackfillSuitableObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 != nonBackfilledObjects) {
            --nonBackfilledObjects;
        }
        return nonBackfilledObjects;
    }

    int getNonBackfilledSingleCount() {
        int nonBackfilledSingle = this.totalSingleCount;
        if (this.isBackfillSuitableSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 != nonBackfilledSingle) {
            --nonBackfilledSingle;
        }
        return nonBackfilledSingle;
    }

    int getNonBackfilledInstanceObjectCount() {
        int nonBackfilledObjects = this.instanceObjectCount;
        if (this.isBackfillSuitableInstanceObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 != nonBackfilledObjects) {
            --nonBackfilledObjects;
        }
        return nonBackfilledObjects;
    }

    int getNonBackfilledInstanceSingleCount() {
        int nonBackfilledSingle = this.instanceSingleCount;
        if (this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 != nonBackfilledSingle) {
            --nonBackfilledSingle;
        }
        return nonBackfilledSingle;
    }

    int getInstanceDoubleCount() {
        return this.instanceDoubleCount;
    }

    int getInstanceObjectCount() {
        return this.instanceObjectCount;
    }

    int getInstanceSingleCount() {
        return this.instanceSingleCount;
    }

    int getHiddenFieldCount() {
        return this.hiddenFieldCount;
    }

    boolean isBackfillSuitableSingleAvailable() {
        return 0 != this.getTotalSingleCount() || 0 != this.getFlatAlignedSingleInstanceBackfillSize() || 0 != this.getFlatUnAlignedSingleInstanceBackfillSize();
    }

    boolean isBackfillSuitableObjectAvailable() {
        return this.objectCanUseBackfill && 0 != this.getTotalObjectCount() || 0 != this.getFlatAlignedObjectInstanceBackfillSize() || 0 != this.getFlatUnAlignedObjectInstanceBackfillSize();
    }

    boolean isBackfillSuitableInstanceSingleAvailable() {
        return 0 != this.getInstanceSingleCount();
    }

    boolean isBackfillSuitableFlatInstanceSingleAvailable() {
        return 0 != this.getFlatAlignedSingleInstanceBackfillSize() || 0 != this.getFlatUnAlignedSingleInstanceBackfillSize();
    }

    boolean isBackfillSuitableInstanceObjectAvailable() {
        return this.objectCanUseBackfill && 0 != this.getInstanceObjectCount() || 0 != this.getFlatAlignedObjectInstanceBackfillSize() || 0 != this.getFlatUnAlignedObjectInstanceBackfillSize();
    }

    boolean isBackfillSuitableFieldAvailable() {
        return this.isBackfillSuitableSingleAvailable() || this.isBackfillSuitableObjectAvailable();
    }

    UDATA getMyBackfillOffsetForHiddenField() {
        return new UDATA((long)this.myBackfillOffset + J9ObjectHelper.headerSize());
    }

    int getSuperclassFieldsSize() {
        return this.superclassFieldsSize;
    }

    long getSuperclassObjectSize() {
        return (long)this.superclassFieldsSize + J9ObjectHelper.headerSize();
    }

    void setSuperclassFieldsSize(int i) {
        this.superclassFieldsSize = i;
    }

    boolean isMyBackfillSlotAvailable() {
        return this.myBackfillOffset >= 0;
    }

    boolean isSuperclassBackfillSlotAvailable() {
        return this.superclassBackfillOffset >= 0;
    }

    int calculateFieldDataStart() {
        boolean doubleAlignment;
        int fieldDataStart = this.getSuperclassFieldsSize();
        boolean bl = doubleAlignment = this.totalDoubleCount > 0 || this.totalFlatFieldDoubleBytes > 0;
        if (this.getSuperclassObjectSize() % 8L != 0L && (doubleAlignment || !this.objectCanUseBackfill && this.totalObjectCount > 0) && !this.isBackfillTypeEndAligned(fieldDataStart += this.getBackfillSize())) {
            fieldDataStart += 4;
            this.isBackFillPostPadded = true;
        }
        return fieldDataStart;
    }

    int addDoublesArea(int start) {
        return start + this.totalDoubleCount * 8;
    }

    int addObjectsArea(int start) {
        int nonBackfilledObjects = this.getNonBackfilledObjectCount();
        return start + nonBackfilledObjects * fj9object_t_SizeOf;
    }

    int getMyBackfillOffset() {
        return this.myBackfillOffset;
    }

    int getBackfillSize() {
        int backFillSize = 4;
        if (0 == this.getInstanceSingleCount() && 0 == this.getInstanceObjectCount()) {
            if (0 != this.getFlatAlignedSingleInstanceBackfillSize()) {
                backFillSize = this.getFlatAlignedSingleInstanceBackfillSize();
            } else if (0 != this.getFlatAlignedObjectInstanceBackfillSize()) {
                backFillSize = this.getFlatAlignedObjectInstanceBackfillSize();
            } else if (0 != this.getFlatUnAlignedSingleInstanceBackfillSize()) {
                backFillSize = this.getFlatUnAlignedSingleInstanceBackfillSize();
            } else if (0 != this.getFlatUnAlignedObjectInstanceBackfillSize()) {
                backFillSize = this.getFlatUnAlignedObjectInstanceBackfillSize();
            }
        }
        return backFillSize;
    }

    int getSubclassBackfillOffset() {
        return this.subclassBackfillOffset;
    }

    void setSuperclassBackfillOffset(int superclassBackfillOffset) {
        this.superclassBackfillOffset = superclassBackfillOffset;
    }

    int getSuperclassBackfillOffset() {
        return this.superclassBackfillOffset;
    }

    boolean isInstanceFieldBackfillEligible() {
        return this.instanceFieldBackfillEligible;
    }

    void countInstanceFields() throws CorruptDataException {
        J9ROMFieldShapeIterator fields = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
        for (J9ROMFieldShapePointer f : fields) {
            UDATA modifiers = f.modifiers();
            if (modifiers.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                if (this.valueTypeHelper.isFlattenableFieldSignature(J9ROMFieldShapeHelper.getSignature(f))) {
                    boolean forceDoubleAlignment;
                    int size = 0;
                    J9ClassPointer fieldClass = this.valueTypeHelper.findJ9ClassInFlattenedClassCacheWithFieldName(this.containerClazz, J9ROMFieldShapeHelper.getName(f));
                    if (!this.valueTypeHelper.isJ9FieldIsFlattened(fieldClass, f)) {
                        ++this.instanceObjectCount;
                        ++this.totalObjectCount;
                        continue;
                    }
                    if (fj9object_t_SizeOf == 4) {
                        UDATA instanceSize = fieldClass.totalInstanceSize();
                        UDATA doubleSize = new UDATA(8L);
                        if (this.valueTypeHelper.classRequires4BytePrePadding(fieldClass)) {
                            instanceSize = instanceSize.sub(4L);
                        }
                        forceDoubleAlignment = modifiers.allBitsIn(J9JavaAccessFlags.J9AccVolatile) && instanceSize.eq(doubleSize);
                    } else {
                        forceDoubleAlignment = true;
                    }
                    if (forceDoubleAlignment || this.valueTypeHelper.isJ9ClassLargestAlignmentConstraintDouble(fieldClass)) {
                        UDATA doubleSize = fieldClass.totalInstanceSize();
                        if (this.valueTypeHelper.classRequires4BytePrePadding(fieldClass)) {
                            doubleSize = doubleSize.sub(4L);
                        }
                        size = Scalar.roundToSizeofU64(doubleSize).intValue();
                        this.totalFlatFieldDoubleBytes += size;
                        continue;
                    }
                    if (this.valueTypeHelper.isJ9ClassLargestAlignmentConstraintReference(fieldClass)) {
                        size = Scalar.roundToSizeToFJ9object(fieldClass.totalInstanceSize()).intValue();
                        this.totalFlatFieldRefBytes += size;
                        this.setPotentialFlatObjectInstanceBackfill(size);
                        continue;
                    }
                    size = fieldClass.totalInstanceSize().intValue();
                    this.totalFlatFieldSingleBytes += size;
                    this.setPotentialFlatSingleInstanceBackfill(size);
                    continue;
                }
                ++this.instanceObjectCount;
                ++this.totalObjectCount;
                continue;
            }
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this.instanceDoubleCount;
                ++this.totalDoubleCount;
                continue;
            }
            ++this.instanceSingleCount;
            ++this.totalSingleCount;
        }
        this.instanceFieldBackfillEligible = this.instanceSingleCount > 0 || this.objectCanUseBackfill && this.instanceSingleCount > 0;
    }

    int countAndCopyHiddenFields(LinkedList<HiddenInstanceField> hiddenFieldList, ArrayList<HiddenInstanceField> hiddenFieldArray) throws CorruptDataException {
        String className = J9UTF8Helper.stringValue(this.romClass.className());
        this.hiddenFieldCount = 0;
        for (HiddenInstanceField hiddenField : hiddenFieldList) {
            if (hiddenField.className() != null && !className.equals(hiddenField.className())) continue;
            UDATA modifiers = hiddenField.shape().modifiers();
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                ++this.totalObjectCount;
            } else if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this.totalDoubleCount;
            } else {
                ++this.totalSingleCount;
            }
            hiddenFieldArray.add(hiddenField);
            ++this.hiddenFieldCount;
        }
        return this.hiddenFieldCount;
    }

    int calculateTotalFieldsSizeAndBackfill() {
        long accumulator = (long)this.superclassFieldsSize + (long)this.totalObjectCount * J9ObjectHelper.headerSize() + (long)(this.totalSingleCount * 4) + (long)(this.totalDoubleCount * 8);
        accumulator += (long)(this.totalFlatFieldDoubleBytes + this.totalFlatFieldRefBytes + this.totalFlatFieldSingleBytes);
        if (this.isValue) {
            int firstFieldOffset = this.calculateFieldDataStart();
            if (0 < firstFieldOffset) {
                if (this.isBackfillSuitableFieldAvailable()) {
                    this.myBackfillOffset = 0;
                    if (this.isBackFillPostPadded()) {
                        accumulator += 4L;
                    }
                } else {
                    accumulator += (long)firstFieldOffset;
                    this.setClassRequiresPrePadding();
                }
            }
        } else {
            if (this.getSuperclassObjectSize() % 8L != 0L && (this.totalDoubleCount > 0 || !this.objectCanUseBackfill && this.totalObjectCount > 0)) {
                this.superclassBackfillOffset = this.getSuperclassFieldsSize();
                accumulator += 4L;
            }
            if (this.isSuperclassBackfillSlotAvailable() && this.isBackfillSuitableFieldAvailable()) {
                accumulator -= 4L;
                this.myBackfillOffset = this.superclassBackfillOffset;
                this.superclassBackfillOffset = -1;
            }
            if ((accumulator + J9ObjectHelper.headerSize()) % 8L != 0L) {
                this.subclassBackfillOffset = (int)accumulator;
                accumulator += 4L;
            } else {
                this.subclassBackfillOffset = this.superclassBackfillOffset;
            }
        }
        return (int)accumulator;
    }

    int addFlatDoublesArea(int start) {
        return start + this.totalFlatFieldDoubleBytes;
    }

    int addFlatObjectsArea(int start) {
        return start + this.getNonBackfilledFlatInstanceObjectSize();
    }

    int addFlatSinglesArea(int start) {
        return start + this.getNonBackfilledFlatInstanceSingleSize();
    }

    int getFlatAlignedSingleInstanceBackfillSize() {
        return this.flatAlignedSingleInstanceBackfill;
    }

    int getFlatUnAlignedSingleInstanceBackfillSize() {
        return this.flatUnAlignedSingleInstanceBackfill;
    }

    int getFlatAlignedObjectInstanceBackfillSize() {
        return this.flatAlignedObjectInstanceBackfill;
    }

    int getFlatUnAlignedObjectInstanceBackfillSize() {
        return this.flatUnAlignedObjectInstanceBackfill;
    }

    void setFlatAlignedSingleInstanceBackfill(int size) {
        this.flatAlignedSingleInstanceBackfill = size;
    }

    void setFlatUnAlignedSingleInstanceBackfill(int size) {
        this.flatUnAlignedSingleInstanceBackfill = size;
    }

    void setFlatAlignedObjectInstanceBackfill(int size) {
        this.flatAlignedObjectInstanceBackfill = size;
    }

    void setFlatUnAlignedObjectInstanceBackfill(int size) {
        this.flatUnAlignedObjectInstanceBackfill = size;
    }

    void setPotentialFlatObjectInstanceBackfill(int size) {
        if (this.isValue) {
            if (4 == size % 8) {
                if (0 == this.getFlatAlignedObjectInstanceBackfillSize()) {
                    this.setFlatAlignedObjectInstanceBackfill(size);
                }
            } else if (0 == this.getFlatUnAlignedObjectInstanceBackfillSize()) {
                this.setFlatUnAlignedObjectInstanceBackfill(size);
            }
        }
    }

    void setPotentialFlatSingleInstanceBackfill(int size) {
        if (this.isValue) {
            if (4 == size % 8) {
                if (0 == this.getFlatAlignedSingleInstanceBackfillSize()) {
                    this.setFlatAlignedSingleInstanceBackfill(size);
                }
            } else if (0 == this.getFlatUnAlignedSingleInstanceBackfillSize()) {
                this.setFlatUnAlignedSingleInstanceBackfill(size);
            }
        }
    }

    int getNonBackfilledFlatInstanceObjectSize() {
        int nonBackfilledFlatObjectsSize = this.totalFlatFieldRefBytes;
        if (this.isBackfillSuitableInstanceObjectAvailable() && this.isMyBackfillSlotAvailable() && 0 == this.getInstanceSingleCount() && this.objectCanUseBackfill && 0 == this.getInstanceObjectCount() && 0 == this.getFlatAlignedSingleInstanceBackfillSize()) {
            int backfillSize = this.getFlatAlignedObjectInstanceBackfillSize();
            if (0 == backfillSize && 0 == this.getFlatUnAlignedSingleInstanceBackfillSize()) {
                backfillSize = this.getFlatUnAlignedObjectInstanceBackfillSize();
            }
            nonBackfilledFlatObjectsSize -= backfillSize;
        }
        return nonBackfilledFlatObjectsSize;
    }

    int getNonBackfilledFlatInstanceSingleSize() {
        int nonBackfilledFlatSinglesSize = this.totalFlatFieldSingleBytes;
        if (this.isBackfillSuitableFlatInstanceSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 == this.getInstanceSingleCount() && this.objectCanUseBackfill && 0 == this.getInstanceObjectCount()) {
            int backfillSize = this.getFlatAlignedSingleInstanceBackfillSize();
            if (0 == backfillSize && 0 == this.getFlatAlignedObjectInstanceBackfillSize()) {
                backfillSize = this.getFlatUnAlignedSingleInstanceBackfillSize();
            }
            nonBackfilledFlatSinglesSize -= backfillSize;
        }
        return nonBackfilledFlatSinglesSize;
    }

    boolean doesClassRequiresPrePadding() {
        return this.classRequiresPrePadding;
    }

    void setClassRequiresPrePadding() {
        this.classRequiresPrePadding = true;
    }

    boolean isBackfillTypeEndAligned(int fieldDataStart) {
        return 4 == fieldDataStart % 8;
    }

    boolean isBackFillPostPadded() {
        return this.isBackFillPostPadded;
    }

    static {
        LOCKWORD_SIZE = j9objectmonitor_t_SizeOf = J9ObjectHelper.compressObjectReferences ? 4 : UDATA.SIZEOF;
        FINALIZE_LINK_SIZE = fj9object_t_SizeOf;
    }
}

