/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.ROMHelp;
import com.ibm.j9ddr.vm27.j9.stackmap.StackMap;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.io.PrintStream;

public class StackmapCommand
extends Command {
    static final int MAX_STACKSLOTS_COUNT = 65536;
    static final int INT_SIZE_IN_BITS = 32;

    public StackmapCommand() {
        this.addCommand("stackmap", "<pc>", "calculate the stack slot map for the specified PC");
    }

    private void printUsage(PrintStream out) {
        out.println("stackmap <pc> - calculate the stack slot map for the specified PC");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            this.printUsage(out);
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (null == vm) {
                out.println("vm can not be found.");
            }
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            U8Pointer pc = U8Pointer.cast(address);
            CommandUtils.dbgPrint(out, "Searching for PC=%d in VM=%s...\n", pc.longValue(), vm.getHexAddress());
            J9MethodPointer remoteMethod = J9JavaVMHelper.getMethodFromPC(vm, pc);
            if (remoteMethod.notNull()) {
                long methodIndex;
                int[] stackMap = new int[2048];
                int leftMostBitIntMask = Integer.MIN_VALUE;
                CommandUtils.dbgPrint(out, "Found method %s !j9method %s\n", J9MethodHelper.getName(remoteMethod), remoteMethod.getHexAddress());
                UDATA offsetPC = new UDATA(pc.sub(U8Pointer.cast(remoteMethod.bytecodes())));
                CommandUtils.dbgPrint(out, "Relative PC = %d\n", offsetPC.longValue());
                J9ClassPointer localClass = this.J9_CLASS_FROM_CP(remoteMethod.constantPool());
                CommandUtils.dbgPrint(out, "Method index is %d\n", methodIndex);
                J9ROMMethodPointer localROMMethod = this.J9ROMCLASS_ROMMETHODS(localClass.romClass());
                for (methodIndex = new UDATA(remoteMethod.sub(localClass.ramMethods())).longValue(); methodIndex != 0L; --methodIndex) {
                    localROMMethod = ROMHelp.nextROMMethod(localROMMethod);
                }
                CommandUtils.dbgPrint(out, "Using ROM method %s\n", localROMMethod.getHexAddress());
                int errorCode = StackMap.j9stackmap_StackBitsForPC(offsetPC, localClass.romClass(), localROMMethod, null, 0);
                if (0 > errorCode) {
                    CommandUtils.dbgPrint(out, "Stack map failed, error code = %d\n", errorCode);
                } else {
                    int stackMapIndex = 0;
                    if (0 != errorCode) {
                        errorCode = StackMap.j9stackmap_StackBitsForPC(offsetPC, localClass.romClass(), localROMMethod, stackMap, errorCode);
                        int currentDescription = stackMap[stackMapIndex];
                        int descriptionInt = 0;
                        CommandUtils.dbgPrint(out, "Stack map (%d slots mapped): ", errorCode);
                        long bitsRemaining = errorCode % 32;
                        if (bitsRemaining != 0L) {
                            descriptionInt = currentDescription << (int)(32L - bitsRemaining);
                            ++currentDescription;
                        }
                        while (errorCode != 0) {
                            if (bitsRemaining == 0L) {
                                descriptionInt = currentDescription;
                                currentDescription = stackMap[++stackMapIndex];
                                bitsRemaining = 32L;
                            }
                            CommandUtils.dbgPrint(out, "%d", (descriptionInt & leftMostBitIntMask) != 0 ? 1 : 0);
                            descriptionInt <<= 1;
                            --bitsRemaining;
                            --errorCode;
                        }
                        CommandUtils.dbgPrint(out, "\n");
                    } else {
                        CommandUtils.dbgPrint(out, "Stack is empty\n");
                    }
                }
            } else {
                CommandUtils.dbgPrint(out, "Not found\n");
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    private J9ROMMethodPointer J9ROMCLASS_ROMMETHODS(J9ROMClassPointer base) throws CorruptDataException {
        return base.romMethods();
    }

    private J9ClassPointer J9_CLASS_FROM_CP(J9ConstantPoolPointer constantPool) throws CorruptDataException {
        return constantPool.ramClass();
    }
}

