/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.tenant;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassLoaderHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.types.U32;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TenantDataHelper {
    static final String tenantDataClassName = "Lcom/ibm/tenant/TenantData;";
    private J9ClassPointer tenantDataClazz;
    private HashMap<String, J9ObjectFieldOffset> tenantDataFieldOffsets;

    public TenantDataHelper(J9JavaVMPointer vm) throws CorruptDataException {
        J9ClassLoaderPointer loader = vm.systemClassLoader();
        this.tenantDataClazz = J9ClassLoaderHelper.findClass(loader, tenantDataClassName);
        this.tenantDataFieldOffsets = new HashMap();
        this.computeFieldOffsets(this.tenantDataClazz, this.tenantDataFieldOffsets);
    }

    private void computeFieldOffsets(J9ClassPointer clazz, HashMap<String, J9ObjectFieldOffset> offsets) throws CorruptDataException {
        if (J9ClassHelper.superclass(clazz).notNull()) {
            this.computeFieldOffsets(J9ClassHelper.superclass(clazz), offsets);
        }
        Iterator<J9ObjectFieldOffset> ofoIterator = J9ClassHelper.getFieldOffsets(clazz);
        while (ofoIterator.hasNext()) {
            J9ObjectFieldOffset ofo = ofoIterator.next();
            if (ofo.isStatic()) continue;
            offsets.put(ofo.getName(), ofo);
        }
    }

    public J9ClassPointer tenantDataClazz() {
        return this.tenantDataClazz;
    }

    public J9IndexableObjectPointer dataObj(J9ObjectPointer dataObject) throws CorruptDataException {
        J9ObjectPointer dataArrays = J9ObjectHelper.getObjectField(dataObject, this.tenantDataFieldOffsets.get("dataObj"));
        if (!J9ObjectHelper.isIndexable(dataArrays)) {
            throw new InternalError("Malformed object array");
        }
        return J9IndexableObjectPointer.cast(dataArrays);
    }

    public J9IndexableObjectPointer data32(J9ObjectPointer dataObject) throws CorruptDataException {
        J9ObjectPointer dataArrays = J9ObjectHelper.getObjectField(dataObject, this.tenantDataFieldOffsets.get("data32"));
        if (!J9ObjectHelper.isIndexable(dataArrays)) {
            throw new InternalError("Malformed object array");
        }
        return J9IndexableObjectPointer.cast(dataArrays);
    }

    public J9IndexableObjectPointer data64(J9ObjectPointer dataObject) throws CorruptDataException {
        J9ObjectPointer dataArrays = J9ObjectHelper.getObjectField(dataObject, this.tenantDataFieldOffsets.get("data64"));
        if (!J9ObjectHelper.isIndexable(dataArrays)) {
            throw new InternalError("Malformed object array");
        }
        return J9IndexableObjectPointer.cast(dataArrays);
    }

    public SlotStats getSlotStats(J9IndexableObjectPointer tenantData) throws CorruptDataException {
        U32 sliceCount = J9IndexableObjectHelper.size(tenantData);
        J9ObjectPointer[] slices = new J9ObjectPointer[sliceCount.intValue()];
        J9IndexableObjectHelper.getData(tenantData, slices, 0, sliceCount.intValue(), 0);
        int totalSlots = 0;
        int occupiedSlots = 0;
        int bytesPerSlot = 0;
        for (J9ObjectPointer slice : slices) {
            if (slice.isNull()) continue;
            String className = J9IndexableObjectHelper.getClassName(slice);
            int sliceSlots = J9IndexableObjectHelper.size(slice).intValue();
            totalSlots += sliceSlots;
            if (className.equals("[L")) {
                bytesPerSlot = 8;
                J9ObjectPointer[] oslots = new J9ObjectPointer[sliceSlots];
                try {
                    J9IndexableObjectHelper.getData(J9IndexableObjectPointer.cast(slice), oslots, 0, sliceSlots, 0);
                    for (J9ObjectPointer val : oslots) {
                        if (val.isNull()) continue;
                        ++occupiedSlots;
                    }
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
            }
            if (className.equals("[J")) {
                bytesPerSlot = 8;
                long[] scalar64 = new long[sliceSlots];
                try {
                    J9IndexableObjectHelper.getLongData(J9IndexableObjectPointer.cast(slice), scalar64, 0, sliceSlots, 0);
                    for (long jval : scalar64) {
                        if (jval == 0L) continue;
                        ++occupiedSlots;
                    }
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
            }
            bytesPerSlot = 4;
            int[] scalar32 = new int[sliceSlots];
            try {
                J9IndexableObjectHelper.getIntData(J9IndexableObjectPointer.cast(slice), scalar32, 0, sliceSlots, 0);
                for (int ival : scalar32) {
                    if (ival == 0) continue;
                    ++occupiedSlots;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        SlotStats stats = new SlotStats();
        stats.total = totalSlots;
        stats.used = occupiedSlots;
        stats.nbyte = totalSlots * bytesPerSlot + sliceCount.intValue() * 8;
        return stats;
    }

    public static class SlotStats {
        public int used = 0;
        public int total = 0;
        public long nbyte = 0L;

        public void add(SlotStats stats) {
            this.used += stats.used;
            this.total += stats.total;
            this.nbyte += stats.nbyte;
        }
    }
}

