/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.RomClassWalker;
import java.io.PrintStream;

public class DumpAllRomClassLinearCommand
extends Command {
    public DumpAllRomClassLinearCommand() {
        this.addCommand("dumpallromclasslinear", "[nestingThreshold]", "cfdump all J9ROMClass using the Linear ROM Class Dumper");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length > 1) {
            throw new DDRInteractiveCommandException("This debug extension accepts none or one argument!");
        }
        long nestingThreashold = args.length == 1 ? Long.valueOf(args[0]) : 1L;
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (null == vm) {
                throw new DDRInteractiveCommandException("Unable to find the VM in core dump!");
            }
            out.println();
            out.println("!j9javavm " + vm.getHexAddress());
            out.println();
            ROMClassesIterator iterator = new ROMClassesIterator(out, vm.classMemorySegments());
            while (iterator.hasNext()) {
                J9ROMClassPointer classPointer = iterator.next();
                out.println("!dumpromclasslinear " + classPointer.getHexAddress());
                out.println(String.format("ROM Class '%s' at %s", J9UTF8Helper.stringValue(classPointer.className()), classPointer.getHexAddress()));
                out.println();
                RomClassWalker classWalker = new RomClassWalker(classPointer, context);
                new LinearDumper().gatherLayoutInfo(out, classWalker, nestingThreashold);
                out.println();
            }
        }
        catch (CorruptDataException e1) {
            e1.printStackTrace();
        }
    }
}

