/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm26.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.StructurePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class WhatIsCommand
extends Command {
    private static final int DEFAULT_MAXIMUM_DEPTH = 6;
    public static final String WHATIS_COMMAND = "!whatis";
    public static final String WHATIS_SET_DEPTH_COMMAND = "!whatissetdepth";
    private int maxDepth = 6;
    private UDATA searchValue;
    private int skipCount = 0;
    private int foundCount = 0;
    private long fieldCount = 0L;
    private static final Map<Class<?>, Method[]> fieldAccessorMap = new HashMap();
    private UDATA closestBelow;
    private SearchStack closestBelowStack;
    private UDATA closestAbove;
    private SearchStack closestAboveStack;
    private UDATA shortestHammingDistance;
    private SearchStack shortestHammingDistanceStack;
    private int hammingDistance;
    private PrintStream out;

    public WhatIsCommand() {
        this.addCommand("whatis", "<address>", "Recursively searches fields for UDATA value");
        this.addCommand("whatissetdepth", "<n>", "Sets the maximum depth of the whatis search");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        this.out = out;
        if (command.equals(WHATIS_COMMAND)) {
            this.runWhatIs(args, context, out);
        } else if (command.equals(WHATIS_SET_DEPTH_COMMAND)) {
            this.runWhatIsSetDepth(args, context, out);
        } else {
            throw new DDRInteractiveCommandException("WhatIsCommand plugin does not recogise command: " + command);
        }
    }

    private void runWhatIsSetDepth(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            out.println("No argument supplied.");
            return;
        }
        int depth = 0;
        try {
            depth = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            out.println("Could not format " + args[0] + " as an integer");
            return;
        }
        if (depth <= 0) {
            out.println("Depth must be > 0");
            return;
        }
        this.maxDepth = depth;
        out.println("Max depth set to " + this.maxDepth);
    }

    private void runWhatIs(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        boolean found;
        long startTime;
        block24: {
            if (args.length == 0) {
                this.badOrMissingSearchValue(out);
                return;
            }
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            UDATA localSearchValue = new UDATA(address);
            if (localSearchValue.eq(0L)) {
                this.badOrMissingSearchValue(out);
                return;
            }
            if (this.searchValue == null || !this.searchValue.eq(localSearchValue)) {
                this.searchValue = localSearchValue;
            } else {
                out.println("Skip count now " + ++this.skipCount + ". Run !whatis 0 to reset it.");
            }
            this.resetFieldData();
            startTime = System.currentTimeMillis();
            J9JavaVMPointer vm = null;
            try {
                vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            }
            catch (CorruptDataException e) {
                throw new DDRInteractiveCommandException("Couldn't get VM", e);
            }
            found = this.walkStructuresFrom(vm);
            if (!found) {
                try {
                    J9VMThreadPointer mainThread = vm.mainThread();
                    LinkedList<J9VMThreadPointer> threads = new LinkedList<J9VMThreadPointer>();
                    if (mainThread.notNull()) {
                        J9VMThreadPointer thisThread;
                        J9VMThreadPointer threadCursor = vm.mainThread();
                        do {
                            threads.add(threadCursor);
                        } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread) && !found);
                        Collections.reverse(threads);
                        Iterator iterator = threads.iterator();
                        while (iterator.hasNext() && !(found = this.walkStructuresFrom(thisThread = (J9VMThreadPointer)iterator.next()))) {
                        }
                    }
                }
                catch (CorruptDataException e) {
                    out.println("CDE walking thread list.");
                    e.printStackTrace(out);
                }
            }
            if (!found) {
                try {
                    GCClassLoaderIterator it = GCClassLoaderIterator.from();
                    while (it.hasNext()) {
                        J9ClassLoaderPointer loader = it.next();
                        Iterator<J9ClassPointer> classIt = ClassIterator.fromJ9Classloader(loader);
                        while (classIt.hasNext()) {
                            J9ClassPointer clazz = classIt.next();
                            found = this.walkStructuresFrom(clazz);
                            if (!found) continue;
                            break block24;
                        }
                    }
                }
                catch (CorruptDataException e) {
                    out.println("CDE walking classes.");
                    e.printStackTrace(out);
                }
            }
        }
        long stopTime = System.currentTimeMillis();
        if (found) {
            out.println("Match found");
        } else {
            out.println("No match found");
            if (this.closestAboveStack != null) {
                out.print("Closest above was: ");
                this.closestAboveStack.dump(out);
                out.print(" at " + this.closestAbove.getHexValue());
                out.println();
            } else {
                out.println("No values found above search value");
            }
            if (this.closestBelowStack != null) {
                out.print("Closest below was: ");
                this.closestBelowStack.dump(out);
                out.print(" at " + this.closestBelow.getHexValue());
                out.println();
            } else {
                out.println("No values found below search value");
            }
            if (this.shortestHammingDistanceStack != null) {
                out.print("Value with shortest hamming distance (fewest single-bit changes required) was: ");
                this.shortestHammingDistanceStack.dump(out);
                out.print(" at " + this.shortestHammingDistance.getHexValue());
                out.print(". Hamming distance = " + this.hammingDistance);
                out.println();
            }
            this.searchValue = null;
        }
        out.println("Searched " + this.fieldCount + " fields to a depth of " + this.maxDepth + " in " + (stopTime - startTime) + " ms");
        this.resetFieldData();
    }

    private void resetFieldData() {
        this.foundCount = 0;
        this.fieldCount = 0L;
        this.closestAbove = new UDATA(-1L);
        this.closestAboveStack = null;
        this.closestBelow = new UDATA(0L);
        this.closestBelowStack = null;
        this.shortestHammingDistance = new UDATA(0L);
        this.shortestHammingDistanceStack = null;
        this.hammingDistance = Integer.MAX_VALUE;
        fieldAccessorMap.clear();
    }

    private boolean walkStructuresFrom(StructurePointer startPoint) throws DDRInteractiveCommandException {
        HashSet<StructurePointer> walked = new HashSet<StructurePointer>();
        SearchStack searchStack = new SearchStack(this.maxDepth);
        if (UDATA.cast(startPoint).eq(this.searchValue)) {
            this.out.println("Found " + this.searchValue.getHexValue() + " as " + startPoint.formatShortInteractive());
            return true;
        }
        searchStack.push(new SearchFrame(startPoint));
        walked.add(startPoint);
        boolean found = false;
        while (!searchStack.isEmpty() && !found) {
            int fieldIndex;
            SearchFrame current = searchStack.peek();
            ++current.fieldIndex;
            if (current.fieldAccessors.length <= fieldIndex) {
                searchStack.pop();
                continue;
            }
            try {
                AbstractPointer ptr;
                current.fieldName = current.fieldAccessors[fieldIndex].getName();
                Object result = current.fieldAccessors[fieldIndex].invoke((Object)current.ptr, new Object[0]);
                if (result == null) continue;
                ++this.fieldCount;
                if (result instanceof StructurePointer) {
                    ptr = (StructurePointer)result;
                    found = this.checkPointer(searchStack, ptr);
                    if (searchStack.isFull() || walked.contains(ptr)) continue;
                    walked.add((StructurePointer)ptr);
                    searchStack.push(new SearchFrame((StructurePointer)ptr));
                    continue;
                }
                if (result instanceof AbstractPointer) {
                    ptr = (AbstractPointer)result;
                    found = this.checkPointer(searchStack, ptr);
                    continue;
                }
                if (result instanceof Scalar) {
                    Scalar s = (Scalar)result;
                    found = this.checkScalar(searchStack, s);
                    continue;
                }
                this.out.println("Unexpected type walked: " + result.getClass().getName());
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CorruptDataException || cause instanceof NoSuchFieldError || cause instanceof NoClassDefFoundError) continue;
                throw new DDRInteractiveCommandException("Unexpected exception during walk", cause);
            }
            catch (Exception e) {
                throw new DDRInteractiveCommandException("Unexpected exception during !whatis walk", e);
            }
        }
        return found;
    }

    private boolean checkPointer(SearchStack searchStack, AbstractPointer ptr) {
        UDATA cmpValue = UDATA.cast(ptr);
        if (this.searchValue.eq(cmpValue)) {
            if (++this.foundCount > this.skipCount) {
                this.out.print("Found " + this.searchValue.getHexValue() + " as " + ptr.formatShortInteractive() + ": ");
                searchStack.dump(this.out);
                this.out.println();
                return true;
            }
        } else {
            this.updateClosest(searchStack, cmpValue);
        }
        return false;
    }

    private boolean checkScalar(SearchStack searchStack, Scalar s) {
        UDATA cmpValue = new UDATA(s);
        if (this.searchValue.eq(s)) {
            if (++this.foundCount > this.skipCount) {
                this.out.print("Found " + this.searchValue.getHexValue() + " as " + s + ": ");
                searchStack.dump(this.out);
                this.out.println();
                return true;
            }
        } else {
            this.updateClosest(searchStack, cmpValue);
        }
        return false;
    }

    private void updateClosest(SearchStack searchStack, UDATA value) {
        int hd;
        if (value.gt(this.searchValue)) {
            if (value.lt(this.closestAbove)) {
                this.closestAbove = value;
                this.closestAboveStack = searchStack.copy();
            }
        } else if (value.gt(this.closestBelow)) {
            this.closestBelow = value;
            this.closestBelowStack = searchStack.copy();
        }
        if ((hd = WhatIsCommand.hammingDistance(this.searchValue, value)) < this.hammingDistance) {
            this.shortestHammingDistance = value;
            this.shortestHammingDistanceStack = searchStack.copy();
            this.hammingDistance = hd;
        }
    }

    private static int hammingDistance(UDATA v1, UDATA v2) {
        int hammingDistance = 0;
        for (long differences = v1.longValue() ^ v2.longValue(); differences != 0L; differences >>>= 1) {
            if ((differences & 1L) != 1L) continue;
            ++hammingDistance;
        }
        return hammingDistance;
    }

    private void badOrMissingSearchValue(PrintStream out) {
        out.println("Bad or missing search value. Skip count reset to 0.");
        this.skipCount = 0;
        this.searchValue = null;
    }

    static final class SearchStack {
        private final SearchFrame[] storage;
        private int stackTop;

        public SearchStack(int capacity) {
            this.storage = new SearchFrame[capacity];
            this.stackTop = 0;
        }

        private SearchStack(SearchFrame[] storage, int stackTop) {
            this.storage = storage;
            this.stackTop = stackTop;
        }

        public SearchFrame pop() {
            return this.storage[--this.stackTop];
        }

        public SearchFrame peek() {
            return this.storage[this.stackTop - 1];
        }

        public void push(SearchFrame obj) {
            this.storage[this.stackTop++] = obj;
        }

        public boolean isEmpty() {
            return this.stackTop <= 0;
        }

        public boolean isFull() {
            return this.stackTop >= this.storage.length;
        }

        public void dump(PrintStream out) {
            out.print(this.storage[0].ptr.formatShortInteractive());
            for (int i = 0; i < this.stackTop; ++i) {
                out.print("->");
                out.print(this.storage[i].fieldName);
            }
        }

        public SearchStack copy() {
            SearchFrame[] copy = new SearchFrame[this.storage.length];
            for (int i = 0; i < copy.length; ++i) {
                if (this.storage[i] == null) continue;
                copy[i] = this.storage[i].copy();
            }
            return new SearchStack(copy, this.stackTop);
        }
    }

    static final class SearchFrame {
        final StructurePointer ptr;
        final Method[] fieldAccessors;
        String fieldName = null;
        int fieldIndex = 0;

        SearchFrame(StructurePointer ptr) {
            this.ptr = ptr;
            this.fieldAccessors = this.getFieldAccessors();
        }

        private SearchFrame(StructurePointer ptr, Method[] fieldAccessors, String fieldName, int fieldIndex) {
            this.ptr = ptr;
            this.fieldAccessors = fieldAccessors;
            this.fieldName = fieldName;
            this.fieldIndex = fieldIndex;
        }

        private Method[] getFieldAccessors() {
            Class<?> ptrClass = this.ptr.getClass();
            if (fieldAccessorMap.containsKey(ptrClass)) {
                return (Method[])fieldAccessorMap.get(ptrClass);
            }
            Method[] allMethods = this.ptr.getClass().getMethods();
            LinkedList<Method> fieldAccessors = new LinkedList<Method>();
            for (Method m : allMethods) {
                if (!m.isAnnotationPresent(GeneratedFieldAccessor.class)) continue;
                fieldAccessors.add(m);
            }
            Method[] accessorFieldArray = fieldAccessors.toArray(new Method[fieldAccessors.size()]);
            fieldAccessorMap.put(ptrClass, accessorFieldArray);
            return accessorFieldArray;
        }

        public SearchFrame copy() {
            return new SearchFrame(this.ptr, this.fieldAccessors, this.fieldName, this.fieldIndex);
        }
    }
}

