/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.Pointer;
import com.ibm.j9ddr.vm26.types.IDATA;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

public class IDATAPointer
extends Pointer {
    public static final int SIZEOF = IDATA.SIZEOF;
    public static final IDATAPointer NULL = new IDATAPointer(0L);

    protected IDATAPointer(long address) {
        super(address);
    }

    public static IDATAPointer cast(AbstractPointer pointer) {
        return IDATAPointer.cast(pointer.getAddress());
    }

    public static IDATAPointer cast(UDATA udata) {
        return IDATAPointer.cast(udata.longValue());
    }

    public static IDATAPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new IDATAPointer(address);
    }

    @Override
    public IDATA at(long index) throws CorruptDataException {
        return new IDATA(this.getIDATAAtOffset(index * (long)SIZEOF));
    }

    @Override
    public IDATA at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public IDATAPointer untag() {
        return this.untag(SIZEOF - 1);
    }

    @Override
    public IDATAPointer untag(long mask) {
        return new IDATAPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public IDATAPointer add(long count) {
        return new IDATAPointer(this.address + (long)SIZEOF * count);
    }

    @Override
    public IDATAPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public IDATAPointer addOffset(long offset) {
        return new IDATAPointer(this.address + offset);
    }

    @Override
    public IDATAPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public IDATAPointer sub(long count) {
        return new IDATAPointer(this.address - (long)SIZEOF * count);
    }

    @Override
    public IDATAPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public IDATAPointer subOffset(long offset) {
        return new IDATAPointer(this.address - offset);
    }

    @Override
    public IDATAPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }
}

