/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.view.dtfj.java;

import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.java.helper.DTFJJavaFieldHelper;
import com.ibm.j9ddr.vm24.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm24.pointer.I32Pointer;
import com.ibm.j9ddr.vm24.pointer.I64Pointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm24.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaField;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaObject;

public class DTFJJavaFieldStatic
extends DTFJJavaField {
    public DTFJJavaFieldStatic(DTFJJavaClass clazz, J9ObjectFieldOffset ptr) throws CorruptDataException {
        super(clazz, ptr);
    }

    public Object get(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            switch (this.getSigFlag()) {
                case 'Z': {
                    return this.getBoolean(object);
                }
                case 'B': {
                    return this.getByte(object);
                }
                case 'C': {
                    return Character.valueOf(this.getChar(object));
                }
                case 'S': {
                    return this.getShort(object);
                }
                case 'I': {
                    return this.getInt(object);
                }
                case 'F': {
                    return Float.valueOf(this.getFloat(object));
                }
                case 'J': {
                    return this.getLong(object);
                }
                case 'D': {
                    return this.getDouble(object);
                }
                case 'L': 
                case '[': {
                    J9ObjectPointer data = this.getObject();
                    if (data.isNull()) {
                        return null;
                    }
                    return new DTFJJavaObject(null, data);
                }
            }
            throw new IllegalArgumentException("Cannot determine the correct data type");
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public boolean getBoolean(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            int data = this.getIntField();
            return data == 1;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public byte getByte(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            byte data = (byte)(this.getIntField() & 0xFF);
            return data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public char getChar(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            char data = (char)(this.getIntField() & 0xFFFF);
            return data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public double getDouble(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            long data = this.getLongField();
            return Double.longBitsToDouble(data);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public float getFloat(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            int data = this.getIntField();
            return Float.intBitsToFloat(data);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public int getInt(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            int data = this.getIntField();
            return data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public long getLong(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            long data = this.getLongField();
            return data;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public short getShort(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            int data = this.getIntField();
            return (short)(data & 0xFFFF);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    public String getString(JavaObject object) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (!DTFJJavaFieldHelper.fieldIsString(this)) {
            throw new IllegalArgumentException("JavaField.getString() called on non-String field.");
        }
        try {
            J9ObjectPointer data = this.getObject();
            return J9ObjectHelper.stringValue(data);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, allowlist);
        }
    }

    private J9ObjectPointer getObject() throws CorruptDataException {
        UDATAPointer pointer = this.clazz.getJ9Class().ramStatics().addOffset(this.fieldOffset.getOffsetOrAddress());
        return J9ObjectPointer.cast(pointer.at(0L));
    }

    private int getIntField() throws CorruptDataException {
        I32Pointer pointer = I32Pointer.cast(this.clazz.getJ9Class().ramStatics().addOffset(this.fieldOffset.getOffsetOrAddress()));
        return pointer.at(0L).intValue();
    }

    private long getLongField() throws CorruptDataException {
        I64Pointer pointer = I64Pointer.cast(this.clazz.getJ9Class().ramStatics().addOffset(this.fieldOffset.getOffsetOrAddress()));
        return pointer.at(0L).longValue();
    }

    public boolean isNestedPacked() {
        return false;
    }

    public boolean isNestedPackedArray() {
        return false;
    }

    public int getPackedLengthAnnotationValue() {
        return 0;
    }
}

