/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCScavengerForwardedHeader;
import com.ibm.j9ddr.vm24.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.structure.J9MemorySegment;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm24.types.UDATA;

class CheckObjectHeap
extends Check {
    CheckObjectHeap() {
    }

    @Override
    public void check() {
        try {
            GCSegmentIterator segments = GCSegmentIterator.fromJ9MemorySegmentList(this._javaVM.objectMemorySegments(), 0L);
            boolean midScavenge = this._engine.isMidscavengeFlagSet();
            block2: while (segments.hasNext()) {
                this._engine.clearPreviousObjects();
                J9MemorySegmentPointer segment = segments.next();
                boolean isSegmentTypeNew = segment.type().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW);
                GCObjectHeapIterator heapIterator = GCObjectHeapIterator.fromJ9MemorySegment(segment, true, false);
                while (heapIterator.hasNext()) {
                    GCScavengerForwardedHeader scavengerForwardedHeader;
                    J9ObjectPointer object = heapIterator.peek();
                    if (midScavenge && isSegmentTypeNew && (scavengerForwardedHeader = GCScavengerForwardedHeader.fromJ9Object(object)).isForwardedPointer()) {
                        this._engine.reportForwardedObject(object, scavengerForwardedHeader.getForwardedObject());
                        UDATA objectSize = scavengerForwardedHeader.getObjectSize();
                        heapIterator.advance(objectSize);
                        this._engine.pushPreviousObject(object);
                        continue;
                    }
                    int result = this._engine.checkObjectHeap(object, segment);
                    if (result != 0) continue block2;
                    heapIterator.next();
                    this._engine.pushPreviousObject(object);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "HEAP";
    }

    @Override
    public void print() {
    }
}

