/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.helper;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.U32Pointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm24.structure.J9MemTag;
import com.ibm.j9ddr.vm24.structure.J9PortLibrary;
import com.ibm.j9ddr.vm24.types.IDATA;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;

public class J9MemTagHelper {
    public static final long ROUNDING_GRANULARITY = 8L;
    public static IDATA J9PORT_MEMTAG_HEADER_TAG_CORRUPTED = new IDATA(1L);
    public static IDATA J9PORT_MEMTAG_FOOTER_TAG_CORRUPTED = new IDATA(2L);
    public static IDATA J9PORT_MEMTAG_FOOTER_PADDING_CORRUPTED = new IDATA(4L);
    public static IDATA J9PORT_MEMTAG_NOT_A_TAG = new IDATA(8L);
    public static IDATA J9PORT_MEMTAG_VALID_TAG = new IDATA(16L);

    public static IDATA j9mem_check_tags(VoidPointer memoryPointer, long headerEyecatcher, long footerEyecatcher) throws J9MemTagCheckError {
        J9MemTagPointer footerTagAddress = J9MemTagPointer.NULL;
        J9MemTagPointer headerTagAddress = J9MemTagHelper.j9mem_get_header_tag(memoryPointer);
        try {
            footerTagAddress = J9MemTagHelper.j9mem_get_footer_tag(headerTagAddress);
            J9MemTagHelper.checkTagSumCheck(headerTagAddress, headerEyecatcher);
        }
        catch (J9MemTagCheckError e) {
            try {
                if (J9MemTagHelper.checkEyecatcher(footerTagAddress, footerEyecatcher)) {
                    throw e;
                }
                return J9PORT_MEMTAG_NOT_A_TAG;
            }
            catch (CorruptDataException e1) {
                return J9PORT_MEMTAG_NOT_A_TAG;
            }
        }
        catch (CorruptDataException e) {
            return J9PORT_MEMTAG_NOT_A_TAG;
        }
        try {
            J9MemTagHelper.checkTagSumCheck(footerTagAddress, footerEyecatcher);
        }
        catch (J9MemTagCheckError e) {
            if (headerEyecatcher == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_HEADER && footerEyecatcher == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_FOOTER) {
                return J9PORT_MEMTAG_FOOTER_TAG_CORRUPTED;
            }
            throw e;
        }
        catch (CorruptDataException e) {
            throw new J9MemTagCheckError(headerTagAddress, e);
        }
        try {
            J9MemTagHelper.checkPadding(headerTagAddress);
        }
        catch (J9MemTagCheckError e) {
            if (headerEyecatcher == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_HEADER && footerEyecatcher == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_FOOTER) {
                return J9PORT_MEMTAG_FOOTER_PADDING_CORRUPTED;
            }
            throw e;
        }
        catch (CorruptDataException e) {
            throw new J9MemTagCheckError(headerTagAddress, e);
        }
        return J9PORT_MEMTAG_VALID_TAG;
    }

    public static void checkTagSumCheck(J9MemTagPointer tag, long eyeCatcher) throws CorruptDataException {
        int sum = 0;
        if (!J9MemTagHelper.checkEyecatcher(tag, eyeCatcher)) {
            throw new J9MemTagCheckError(tag, "Wrong eyecatcher. Expected 0x" + Long.toHexString(eyeCatcher) + " but was " + UDATA.cast(tag).getHexValue());
        }
        U32Pointer slots = U32Pointer.cast(tag);
        int i = 0;
        while ((long)i < J9MemTag.SIZEOF / 4L) {
            sum = (int)((long)sum ^ slots.at(i).longValue());
            ++i;
        }
        if (J9BuildFlags.env_data64) {
            U32 a = new U32(UDATA.cast(tag).rightShift(32));
            U32 b = new U32(UDATA.cast(tag).bitAnd(U32.MAX));
            sum = (int)((long)sum ^ (a.longValue() ^ b.longValue()));
        } else {
            sum = (int)((long)sum ^ tag.longValue());
        }
        if (sum != 0) {
            throw new J9MemTagCheckError(tag, "J9MemTag sumcheck failed: " + sum);
        }
    }

    private static boolean checkEyecatcher(J9MemTagPointer tag, long eyeCatcher) throws CorruptDataException {
        return tag.eyeCatcher().eq(eyeCatcher);
    }

    public static VoidPointer j9mem_get_memory_base(J9MemTagPointer headerEyeCatcherAddress) {
        return VoidPointer.cast(U8Pointer.cast(headerEyeCatcherAddress).add(J9MemTag.SIZEOF));
    }

    public static J9MemTagPointer j9mem_get_footer_tag(J9MemTagPointer headerEyeCatcherAddress) throws CorruptDataException {
        UDATA footerOffset = J9MemTagHelper.ROUNDED_FOOTER_OFFSET(headerEyeCatcherAddress.allocSize());
        return J9MemTagPointer.cast(U8Pointer.cast(headerEyeCatcherAddress).add(footerOffset));
    }

    public static J9MemTagPointer j9mem_get_header_tag(VoidPointer memoryPointer) {
        return J9MemTagPointer.cast(U8Pointer.cast(memoryPointer).sub(J9MemTag.SIZEOF));
    }

    public static void checkPadding(J9MemTagPointer headerTagAddress) throws CorruptDataException {
        U8Pointer padding = U8Pointer.cast(J9MemTagHelper.j9mem_get_footer_padding(headerTagAddress));
        while (!UDATA.cast(padding).bitAnd(7L).eq(0L)) {
            if (padding.at(0L).eq(J9PortLibrary.J9MEMTAG_PADDING_BYTE)) {
                padding = padding.add(1L);
                continue;
            }
            throw new J9MemTagCheckError(headerTagAddress, "J9MemTag Footer Padding Corrupted at " + padding.getHexAddress() + ". Value: " + padding.at(0L));
        }
    }

    public static VoidPointer j9mem_get_footer_padding(J9MemTagPointer headerEyeCatcherAddress) throws CorruptDataException {
        UDATA cursor = UDATA.cast(U8Pointer.cast(headerEyeCatcherAddress).add(J9MemTag.SIZEOF));
        U8Pointer padding = U8Pointer.cast(cursor.add(headerEyeCatcherAddress.allocSize()));
        return VoidPointer.cast(padding);
    }

    public static UDATA ROUNDED_FOOTER_OFFSET(UDATA number) {
        UDATA a = number.add(7L).add(J9MemTag.SIZEOF);
        UDATA b = new UDATA(7L).bitNot();
        return a.bitAnd(b);
    }

    public static class J9MemTagCheckError
    extends AddressedCorruptDataException {
        private static final long serialVersionUID = -8326638947722902353L;
        private final J9MemTagPointer memTag;

        J9MemTagCheckError(J9MemTagPointer memTag, String message2) {
            super(memTag.getAddress(), message2);
            this.memTag = memTag;
        }

        public J9MemTagCheckError(J9MemTagPointer memTag, CorruptDataException e) {
            super(memTag.getAddress(), (Throwable)e);
            this.memTag = memTag;
        }

        public J9MemTagPointer getMemTag() {
            return this.memTag;
        }
    }
}

