/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.structure.CardAction;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=CardAction.class)
public class CardActionPointer
extends StructurePointer {
    public static final CardActionPointer NULL = new CardActionPointer(0L);

    protected CardActionPointer(long address) {
        super(address);
    }

    public static CardActionPointer cast(AbstractPointer structure) {
        return CardActionPointer.cast(structure.getAddress());
    }

    public static CardActionPointer cast(UDATA udata) {
        return CardActionPointer.cast(udata.longValue());
    }

    public static CardActionPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new CardActionPointer(address);
    }

    @Override
    public CardActionPointer add(long count) {
        return CardActionPointer.cast(this.address + CardAction.SIZEOF * count);
    }

    @Override
    public CardActionPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public CardActionPointer addOffset(long offset) {
        return CardActionPointer.cast(this.address + offset);
    }

    @Override
    public CardActionPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public CardActionPointer sub(long count) {
        return CardActionPointer.cast(this.address - CardAction.SIZEOF * count);
    }

    @Override
    public CardActionPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public CardActionPointer subOffset(long offset) {
        return CardActionPointer.cast(this.address - offset);
    }

    @Override
    public CardActionPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public CardActionPointer untag(long mask) {
        return CardActionPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public CardActionPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return CardAction.SIZEOF;
    }
}

