/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.I32Pointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.U16Pointer;
import com.ibm.j9ddr.vm24.pointer.U32Pointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.structure.ByteDataWrapper;
import com.ibm.j9ddr.vm24.types.I32;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U16;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.U8;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=ByteDataWrapper.class)
public class ByteDataWrapperPointer
extends StructurePointer {
    public static final ByteDataWrapperPointer NULL = new ByteDataWrapperPointer(0L);

    protected ByteDataWrapperPointer(long address) {
        super(address);
    }

    public static ByteDataWrapperPointer cast(AbstractPointer structure) {
        return ByteDataWrapperPointer.cast(structure.getAddress());
    }

    public static ByteDataWrapperPointer cast(UDATA udata) {
        return ByteDataWrapperPointer.cast(udata.longValue());
    }

    public static ByteDataWrapperPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ByteDataWrapperPointer(address);
    }

    @Override
    public ByteDataWrapperPointer add(long count) {
        return ByteDataWrapperPointer.cast(this.address + ByteDataWrapper.SIZEOF * count);
    }

    @Override
    public ByteDataWrapperPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public ByteDataWrapperPointer addOffset(long offset) {
        return ByteDataWrapperPointer.cast(this.address + offset);
    }

    @Override
    public ByteDataWrapperPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public ByteDataWrapperPointer sub(long count) {
        return ByteDataWrapperPointer.cast(this.address - ByteDataWrapper.SIZEOF * count);
    }

    @Override
    public ByteDataWrapperPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public ByteDataWrapperPointer subOffset(long offset) {
        return ByteDataWrapperPointer.cast(this.address - offset);
    }

    @Override
    public ByteDataWrapperPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public ByteDataWrapperPointer untag(long mask) {
        return ByteDataWrapperPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ByteDataWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return ByteDataWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataLengthOffset_", declaredType="U32")
    public U32 dataLength() throws CorruptDataException {
        return new U32(this.getIntAtOffset(ByteDataWrapper._dataLengthOffset_));
    }

    public U32Pointer dataLengthEA() throws CorruptDataException {
        return U32Pointer.cast(this.nonNullFieldEA(ByteDataWrapper._dataLengthOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataTypeOffset_", declaredType="U8")
    public U8 dataType() throws CorruptDataException {
        return new U8(this.getByteAtOffset(ByteDataWrapper._dataTypeOffset_));
    }

    public U8Pointer dataTypeEA() throws CorruptDataException {
        return U8Pointer.cast(this.nonNullFieldEA(ByteDataWrapper._dataTypeOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_inPrivateUseOffset_", declaredType="U8")
    public U8 inPrivateUse() throws CorruptDataException {
        return new U8(this.getByteAtOffset(ByteDataWrapper._inPrivateUseOffset_));
    }

    public U8Pointer inPrivateUseEA() throws CorruptDataException {
        return U8Pointer.cast(this.nonNullFieldEA(ByteDataWrapper._inPrivateUseOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_privateOwnerIDOffset_", declaredType="U16")
    public U16 privateOwnerID() throws CorruptDataException {
        return new U16(this.getShortAtOffset(ByteDataWrapper._privateOwnerIDOffset_));
    }

    public U16Pointer privateOwnerIDEA() throws CorruptDataException {
        return U16Pointer.cast(this.nonNullFieldEA(ByteDataWrapper._privateOwnerIDOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_readWriteBlockOffsetOffset_", declaredType="I32")
    public I32 readWriteBlockOffset() throws CorruptDataException {
        return new I32(this.getIntAtOffset(ByteDataWrapper._readWriteBlockOffsetOffset_));
    }

    public I32Pointer readWriteBlockOffsetEA() throws CorruptDataException {
        return I32Pointer.cast(this.nonNullFieldEA(ByteDataWrapper._readWriteBlockOffsetOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_tokenOffsetOffset_", declaredType="I32")
    public I32 tokenOffset() throws CorruptDataException {
        return new I32(this.getIntAtOffset(ByteDataWrapper._tokenOffsetOffset_));
    }

    public I32Pointer tokenOffsetEA() throws CorruptDataException {
        return I32Pointer.cast(this.nonNullFieldEA(ByteDataWrapper._tokenOffsetOffset_));
    }
}

