/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.blobs;

import com.ibm.j9ddr.blobs.IBlobFactory;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class BlobFactory
implements IBlobFactory {
    private static final String BLOB_ROOT = "/data/";

    private BlobFactory() {
    }

    public static IBlobFactory getInstance() {
        return new BlobFactory();
    }

    @Override
    public ImageInputStream getBlob(IBlobFactory.Platforms platform, String id, int major, int minor, int revision) {
        String path = BLOB_ROOT + id + "/" + platform.toString() + "/" + major + "/" + minor + "/" + revision;
        return this.getBlob(path);
    }

    @Override
    public ImageInputStream getBlob(String path) {
        InputStream is;
        if (!path.startsWith(BLOB_ROOT)) {
            path = BLOB_ROOT + path;
        }
        if (!path.endsWith("/j9ddr.dat")) {
            path = path + "/j9ddr.dat";
        }
        if ((is = this.getClass().getResourceAsStream(path)) != null) {
            MemoryCacheImageInputStream in = new MemoryCacheImageInputStream(is);
            return in;
        }
        return null;
    }
}

